/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.os.Process;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.ErrorHelp;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AriaCrashHandler
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
    private ExecutorService mExecutorService = Executors.newSingleThreadExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        ex.printStackTrace();
        this.handleException(thread.getName(), ex);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.mDefaultHandler.uncaughtException(thread, ex);
            this.exit();
        }
    }

    private void handleException(String name, final Throwable ex) {
        if (ex == null) {
            return;
        }
        this.mExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                ErrorHelp.saveError("", ALog.getExceptionString(ex));
            }
        });
    }

    private void exit() {
        Process.killProcess((int)Process.myPid());
        System.exit(1);
    }
}

