/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.util;

import android.text.TextUtils;
import android.util.Log;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ALog {
    public static final boolean DEBUG = true;
    public static final int LOG_LEVEL_VERBOSE = 2;
    public static final int LOG_LEVEL_DEBUG = 3;
    public static final int LOG_LEVEL_INFO = 4;
    public static final int LOG_LEVEL_WARN = 5;
    public static final int LOG_LEVEL_ERROR = 6;
    public static final int LOG_LEVEL_ASSERT = 7;
    public static final int LOG_CLOSE = 8;
    public static final int LOG_DEFAULT = 3;
    public static int LOG_LEVEL = 3;

    public static int v(String tag, String msg) {
        return ALog.println(2, tag, msg);
    }

    public static int d(String tag, String msg) {
        return ALog.println(3, tag, msg);
    }

    public static int i(String tag, String msg) {
        return ALog.println(4, tag, msg);
    }

    public static int w(String tag, String msg) {
        return ALog.println(5, tag, msg);
    }

    public static int e(String tag, String msg) {
        return ALog.println(6, tag, msg);
    }

    public static void e(String tag, String msg, Throwable e) {
        Log.e((String)tag, (String)msg, (Throwable)e);
    }

    public static void m(String tag, Map map) {
        if (LOG_LEVEL <= 3) {
            Set set = map.entrySet();
            if (set.size() < 1) {
                ALog.d(tag, "[]");
                return;
            }
            int i = 0;
            Object[] s = new String[set.size()];
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry aSet;
                Map.Entry entry = aSet = iterator.next();
                s[i] = entry.getKey() + " = " + entry.getValue() + ",\n";
                ++i;
            }
            ALog.println(3, tag, Arrays.toString(s));
        }
    }

    public static void j(String tag, String jsonStr) {
        if (LOG_LEVEL <= 3) {
            String message;
            try {
                if (jsonStr.startsWith("{")) {
                    JSONObject jsonObject = new JSONObject(jsonStr);
                    message = jsonObject.toString(4);
                } else if (jsonStr.startsWith("[")) {
                    JSONArray jsonArray = new JSONArray(jsonStr);
                    message = jsonArray.toString(4);
                } else {
                    message = jsonStr;
                }
            }
            catch (JSONException e) {
                message = jsonStr;
            }
            ALog.println(3, tag, message);
        }
    }

    public static String getExceptionString(Throwable ex) {
        StackTraceElement[] stack;
        if (ex == null) {
            return "";
        }
        StringBuilder err = new StringBuilder();
        err.append("ExceptionDetailed:\n");
        err.append("====================Exception Info====================\n");
        err.append(ex.toString());
        err.append("\n");
        for (StackTraceElement stackTraceElement : stack = ex.getStackTrace()) {
            err.append(stackTraceElement.toString()).append("\n");
        }
        Throwable cause = ex.getCause();
        if (cause != null) {
            StackTraceElement[] stackTrace;
            err.append("\u3010Caused by\u3011: ");
            err.append(cause.toString());
            err.append("\n");
            for (StackTraceElement stackTraceElement : stackTrace = cause.getStackTrace()) {
                err.append(stackTraceElement.toString()).append("\n");
            }
        }
        err.append("===================================================");
        return err.toString();
    }

    private static int println(int level, String tag, String msg) {
        if (LOG_LEVEL <= level) {
            return Log.println((int)level, (String)tag, (String)(TextUtils.isEmpty((CharSequence)msg) ? "null" : msg));
        }
        return -1;
    }
}

