/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.orm;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.arialyy.aria.orm.AbsDbWrapper;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.orm.DelegateFind;
import com.arialyy.aria.orm.DelegateManager;
import com.arialyy.aria.orm.DelegateUpdate;
import com.arialyy.aria.orm.SqlHelper;
import com.arialyy.aria.orm.SqlUtil;
import java.util.List;

public class DelegateWrapper {
    private static final String TAG = "DelegateWrapper";
    private static volatile DelegateWrapper INSTANCE = null;
    private SQLiteDatabase mDb;
    private DelegateManager mDManager;

    private DelegateWrapper() {
    }

    private DelegateWrapper(Context context) {
        SqlHelper helper = SqlHelper.init(context.getApplicationContext());
        this.mDb = helper.getDb();
        this.mDManager = DelegateManager.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DelegateWrapper init(Context context) {
        if (INSTANCE != null) return INSTANCE;
        Class<DelegateWrapper> clazz = DelegateWrapper.class;
        synchronized (DelegateWrapper.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DelegateWrapper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    static DelegateWrapper getInstance() {
        if (INSTANCE == null) {
            throw new NullPointerException("\u8bf7\u5728Application\u4e2d\u8c03\u7528init\u8fdb\u884c\u6570\u636e\u5e93\u5de5\u5177\u6ce8\u518c\u6ce8\u518c");
        }
        return INSTANCE;
    }

    <T extends AbsDbWrapper> List<T> findRelationData(Class<T> clazz, String ... expression) {
        return this.mDManager.getDelegate(DelegateFind.class).findRelationData(this.mDb, clazz, expression);
    }

    <T extends AbsDbWrapper> List<T> findRelationData(Class<T> clazz, int page, int num, String ... expression) {
        return this.mDManager.getDelegate(DelegateFind.class).findRelationData(this.mDb, clazz, page, num, expression);
    }

    boolean checkDataExist(Class clazz, String ... expression) {
        return SqlUtil.checkDataExist(this.mDb, clazz, expression);
    }

    <T extends DbEntity> void clean(Class<T> clazz) {
        SqlUtil.clean(this.mDb, clazz);
    }

    void exeSql(String sql) {
        this.mDb.execSQL(sql);
    }

    <T extends DbEntity> void delData(Class<T> clazz, String ... expression) {
        this.mDManager.getDelegate(DelegateUpdate.class).delData(this.mDb, clazz, expression);
    }

    void updateData(DbEntity dbEntity) {
        this.mDManager.getDelegate(DelegateUpdate.class).updateData(this.mDb, dbEntity);
    }

    <T extends DbEntity> void updateManyData(List<T> dbEntitys) {
        this.mDManager.getDelegate(DelegateUpdate.class).updateManyData(this.mDb, dbEntitys);
    }

    <T extends DbEntity> List<T> findAllData(Class<T> clazz) {
        return this.mDManager.getDelegate(DelegateFind.class).findAllData(this.mDb, clazz);
    }

    <T extends DbEntity> List<T> findData(Class<T> clazz, String ... expression) {
        return this.mDManager.getDelegate(DelegateFind.class).findData(this.mDb, clazz, expression);
    }

    <T extends DbEntity> List<T> findData(Class<T> clazz, int page, int num, String ... expression) {
        return this.mDManager.getDelegate(DelegateFind.class).findData(this.mDb, clazz, page, num, expression);
    }

    <T extends DbEntity> List<T> findDataByFuzzy(Class<T> clazz, String conditions) {
        return this.mDManager.getDelegate(DelegateFind.class).findDataByFuzzy(this.mDb, clazz, conditions);
    }

    <T extends DbEntity> List<T> findDataByFuzzy(Class<T> clazz, int page, int num, String conditions) {
        return this.mDManager.getDelegate(DelegateFind.class).findDataByFuzzy(this.mDb, clazz, page, num, conditions);
    }

    <T extends DbEntity> boolean isExist(Class<T> clazz, long rowId) {
        return this.mDManager.getDelegate(DelegateFind.class).itemExist(this.mDb, clazz, rowId);
    }

    boolean isExist(String tableName, long rowId) {
        return this.mDManager.getDelegate(DelegateFind.class).itemExist(this.mDb, tableName, rowId);
    }

    void insertData(DbEntity dbEntity) {
        this.mDManager.getDelegate(DelegateUpdate.class).insertData(this.mDb, dbEntity);
    }

    <T extends DbEntity> void insertManyData(List<T> dbEntitys) {
        this.mDManager.getDelegate(DelegateUpdate.class).insertManyData(this.mDb, dbEntitys);
    }

    public boolean tableExists(Class clazz) {
        return SqlUtil.tableExists(this.mDb, clazz);
    }

    int[] getRowId(Class clazz) {
        return this.mDManager.getDelegate(DelegateFind.class).getRowId(this.mDb, clazz);
    }

    int getRowId(Class clazz, Object[] wheres, Object[] values) {
        return this.mDManager.getDelegate(DelegateFind.class).getRowId(this.mDb, clazz, wheres, values);
    }
}

