/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.orm;

import android.content.Context;
import android.content.ContextWrapper;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import com.arialyy.aria.util.CommonUtil;
import java.io.File;
import java.io.IOException;

class DatabaseContext
extends ContextWrapper {
    public DatabaseContext(Context context) {
        super(context);
    }

    public File getDatabasePath(String name) {
        String dbDir = CommonUtil.getAppPath(this.getBaseContext());
        dbDir = dbDir + "DB";
        String dbPath = dbDir + "/" + name;
        File dirFile = new File(dbDir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        boolean isFileCreateSuccess = false;
        File dbFile = new File(dbPath);
        if (!dbFile.exists()) {
            try {
                isFileCreateSuccess = dbFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            isFileCreateSuccess = true;
        }
        if (isFileCreateSuccess) {
            return dbFile;
        }
        return null;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        return SQLiteDatabase.openOrCreateDatabase((File)this.getDatabasePath(name), null);
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, DatabaseErrorHandler errorHandler) {
        return SQLiteDatabase.openOrCreateDatabase((File)this.getDatabasePath(name), null);
    }
}

