/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.task;

import android.net.TrafficStats;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Process;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.SubThreadConfig;
import com.arialyy.aria.core.manager.ThreadTaskManager;
import com.arialyy.aria.core.task.IThreadTask;
import com.arialyy.aria.core.task.IThreadTaskAdapter;
import com.arialyy.aria.core.task.IThreadTaskObserver;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.core.wrapper.ITaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.ErrorHelp;
import com.arialyy.aria.util.FileUtil;
import com.arialyy.aria.util.NetUtils;
import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ThreadTask
implements IThreadTask,
IThreadTaskObserver {
    private final int RETRY_NUM = 2;
    private final String TAG = CommonUtil.getClassName(this.getClass());
    private AbsEntity mEntity;
    protected AbsTaskWrapper mTaskWrapper;
    private int mFailTimes = 0;
    private long mLastSaveTime;
    private long mLastSendProgressTime;
    private boolean isNotNetRetry;
    private boolean taskBreak = false;
    private boolean isDestroy = false;
    protected boolean isCancel = false;
    protected boolean isStop = false;
    private ExecutorService mConfigThreadPool;
    private Handler mStateHandler;
    private SubThreadConfig mConfig;
    private long mRangeProgress;
    private long mLastRangeProgress;
    private IThreadTaskAdapter mAdapter;
    private ThreadRecord mRecord;
    private String mThreadName;
    private long updateInterval;
    private Thread mConfigThread = new Thread(new Runnable(){

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            long currentTemp = ThreadTask.this.mRangeProgress;
            ThreadTask.this.writeConfig(false, currentTemp);
        }
    });

    public ThreadTask(SubThreadConfig config) {
        this.mConfig = config;
        this.mTaskWrapper = config.taskWrapper;
        this.mRecord = config.record;
        this.mStateHandler = config.stateHandler;
        this.mEntity = this.mTaskWrapper.getEntity();
        this.mLastSaveTime = System.currentTimeMillis();
        this.mConfigThreadPool = Executors.newCachedThreadPool();
        this.isNotNetRetry = AriaConfig.getInstance().getAConfig().isNotNetRetry();
        this.mLastRangeProgress = this.mRangeProgress = this.mRecord.startLocation;
        this.updateInterval = config.updateInterval;
        this.checkFileExist();
    }

    private void checkFileExist() {
        if (!this.getConfig().tempFile.exists()) {
            FileUtil.createFile(this.getConfig().tempFile);
        }
    }

    public void setAdapter(IThreadTaskAdapter adapter) {
        this.mAdapter = adapter;
        this.mAdapter.attach(this);
    }

    protected String getFileName() {
        return this.mConfig.tempFile.getName();
    }

    public SubThreadConfig getConfig() {
        return this.mConfig;
    }

    @Override
    public void destroy() {
        this.isDestroy = true;
    }

    @Override
    public boolean isLive() {
        return !Thread.currentThread().isInterrupted() && !this.isDestroy;
    }

    @Override
    public boolean isThreadComplete() {
        return this.mRecord.isComplete;
    }

    protected AbsEntity getEntity() {
        return this.mEntity;
    }

    protected ITaskWrapper getTaskWrapper() {
        return this.mTaskWrapper;
    }

    @Override
    public void setMaxSpeed(int speed) {
        if (this.mAdapter != null) {
            this.mAdapter.setMaxSpeed(speed);
        }
    }

    @Override
    public void breakTask() {
        this.taskBreak = true;
        if (this.mTaskWrapper.isSupportBP()) {
            long currentTemp = this.mRangeProgress;
            this.updateState(1, null);
            ALog.d(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011thread__%s__\u4e2d\u65ad\u3010\u505c\u6b62\u4f4d\u7f6e\uff1a%s\u3011", this.getFileName(), this.mRecord.threadId, currentTemp));
            this.writeConfig(false, currentTemp);
        } else {
            ALog.i(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u5df2\u4e2d\u65ad", this.getFileName()));
        }
    }

    @Override
    public boolean isDestroy() {
        return Thread.currentThread().isInterrupted();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mConfigThreadPool != null) {
            this.mConfigThreadPool.shutdown();
        }
    }

    @Override
    public boolean isBreak() {
        return this.isCancel || this.isStop || this.taskBreak;
    }

    @Override
    public boolean checkBlock() {
        if (!this.mConfig.isBlock) {
            return true;
        }
        File blockFile = this.mConfig.tempFile;
        if (!blockFile.exists() || blockFile.length() != this.mRecord.blockLen) {
            ALog.i(this.TAG, String.format("\u5206\u5757\u3010%s\u3011\u9519\u8bef\uff0cblockFileLen: %s, threadRect: %s; \u5373\u5c06\u91cd\u65b0\u4e0b\u8f7d\u8be5\u5206\u5757\uff0c\u5f00\u59cb\u4f4d\u7f6e\uff1a%s\uff0c\u7ed3\u675f\u4f4d\u7f6e\uff1a%s", blockFile.getName(), blockFile.length(), this.mRecord.blockLen, this.mRecord.startLocation, this.mRecord.endLocation));
            if (blockFile.exists()) {
                FileUtil.deleteFile(blockFile);
                ALog.i(this.TAG, String.format("\u5220\u9664\u5206\u5757\u3010%s\u3011\u6210\u529f", blockFile.getName()));
            }
            this.retryBlockTask(this.isBreak());
            return false;
        }
        return true;
    }

    @Override
    public int getThreadId() {
        return this.mRecord.threadId;
    }

    @Override
    public String getThreadName() {
        return this.mThreadName == null ? (this.mThreadName = CommonUtil.getThreadName(this.getEntity().getKey(), this.getThreadId())) : this.mThreadName;
    }

    @Override
    public void stop() {
        this.isStop = true;
        long stopLocation = this.mRangeProgress;
        this.updateState(1, null);
        if (this.mTaskWrapper.getRequestType() == 7) {
            this.writeConfig(false, this.getConfig().tempFile.length());
            ALog.i(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u5df2\u505c\u6b62", this.getFileName()));
            return;
        }
        if (this.mTaskWrapper.isSupportBP()) {
            ALog.d(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011thread__%s__\u505c\u6b62\u3010\u5f53\u524d\u7ebf\u7a0b\u505c\u6b62\u4f4d\u7f6e\uff1a%s\u3011", this.getFileName(), this.mRecord.threadId, stopLocation));
            this.writeConfig(false, stopLocation);
            return;
        }
        ALog.i(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u5df2\u505c\u6b62", this.getFileName()));
    }

    @Override
    public synchronized void updateState(int state, Bundle bundle) {
        Thread loopThread;
        Message msg = this.mStateHandler.obtainMessage();
        if (bundle == null) {
            bundle = new Bundle();
        }
        msg.setData(bundle);
        bundle.putString("DATA_THREAD_NAME", this.getThreadName());
        bundle.putLong("DATA_THREAD_LOCATION", this.mRangeProgress);
        msg.what = state;
        int reqType = this.getConfig().threadType;
        if (reqType == 3) {
            this.sendM3U8Info(state, msg);
        }
        if (!(loopThread = this.mStateHandler.getLooper().getThread()).isAlive() || loopThread.isInterrupted()) {
            return;
        }
        msg.sendToTarget();
    }

    private void sendM3U8Info(int state, Message msg) {
        Bundle bundle = msg.getData();
        if (state != 6) {
            msg.obj = this;
        }
        if (state == 4 || state == 2) {
            bundle.putString("DATA_M3U8_URL", this.getConfig().url);
            bundle.putString("DATA_M3U8_PEER_PATH", this.getConfig().tempFile.getPath());
            bundle.putInt("DATA_M3U8_PEER_INDEX", this.getConfig().peerIndex);
        }
    }

    @Override
    public synchronized void updateCompleteState() {
        ALog.i(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u7ebf\u7a0b__%s__\u5b8c\u6210", this.getTaskWrapper().getKey(), this.mRecord.threadId));
        this.writeConfig(true, this.mRecord.endLocation);
        this.sendRunningState();
        this.updateState(4, null);
    }

    @Override
    public synchronized void updateFailState(AriaException e, boolean needRetry) {
        this.fail(this.mRangeProgress, e, needRetry);
    }

    @Override
    public synchronized void updateProgress(long len) {
        this.mRangeProgress += len;
        Thread loopThread = this.mStateHandler.getLooper().getThread();
        if (!loopThread.isAlive() || loopThread.isInterrupted()) {
            return;
        }
        if (System.currentTimeMillis() - this.mLastSendProgressTime > this.updateInterval) {
            this.sendRunningState();
            this.mLastRangeProgress = this.mRangeProgress;
            this.mLastSendProgressTime = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.mLastSaveTime > 5000L && this.mRangeProgress < this.mRecord.endLocation) {
            this.mLastSaveTime = System.currentTimeMillis();
            if (!this.mConfigThreadPool.isShutdown()) {
                this.mConfigThreadPool.execute(this.mConfigThread);
            }
        }
    }

    private void sendRunningState() {
        Message msg = this.mStateHandler.obtainMessage();
        Bundle b = msg.getData();
        if (b == null) {
            b = new Bundle();
            msg.setData(b);
        }
        b.putString("DATA_THREAD_NAME", this.getThreadName());
        b.putLong("DATA_ADD_LEN", this.mRangeProgress - this.mLastRangeProgress);
        msg.what = 5;
        msg.obj = this.mRangeProgress;
        Thread loopThread = this.mStateHandler.getLooper().getThread();
        if (!loopThread.isAlive() || loopThread.isInterrupted()) {
            return;
        }
        msg.sendToTarget();
    }

    @Override
    public long getThreadProgress() {
        return this.mRangeProgress;
    }

    @Override
    public void cancel() {
        this.isCancel = true;
        this.updateState(3, null);
        ALog.d(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011thread__%s__\u53d6\u6d88", this.getFileName(), this.mRecord.threadId));
    }

    protected void fail(long subCurrentLocation, AriaException ex, boolean needRetry) {
        if (ex != null) {
            ex.printStackTrace();
        }
        if (this.mTaskWrapper.getRequestType() == 7) {
            this.writeConfig(false, 0L);
            this.retryM3U8Peer(needRetry);
            return;
        }
        if (this.mTaskWrapper.isSupportBP()) {
            this.writeConfig(false, subCurrentLocation);
            this.retryBlockTask(needRetry);
            return;
        }
        ALog.e(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u6267\u884c\u5931\u8d25", this.getFileName()));
        ErrorHelp.saveError("", ALog.getExceptionString(ex));
        this.sendFailMsg(null, needRetry);
    }

    private void retryM3U8Peer(boolean needRetry) {
        if (this.mConfig.ignoreFailure) {
            ALog.d(this.TAG, "\u5ffd\u7565\u5931\u8d25\u7684\u5207\u7247");
            this.sendFailMsg(null, false);
            return;
        }
        boolean isConnected = NetUtils.isConnected(AriaConfig.getInstance().getAPP());
        if (!isConnected && !this.isNotNetRetry) {
            ALog.w(this.TAG, String.format("ts\u5207\u7247\u3010%s\u3011\u91cd\u8bd5\u5931\u8d25\uff0c\u7f51\u7edc\u672a\u8fde\u63a5", this.getFileName()));
            this.sendFailMsg(null, false);
            return;
        }
        if (this.mFailTimes < 2 && needRetry && (NetUtils.isConnected(AriaConfig.getInstance().getAPP()) || this.isNotNetRetry) && !this.isBreak()) {
            ALog.w(this.TAG, String.format("ts\u5207\u7247\u3010%s\u3011\u7b2c%s\u91cd\u8bd5", this.getFileName(), String.valueOf(this.mFailTimes)));
            ++this.mFailTimes;
            FileUtil.deleteFile(this.mConfig.tempFile);
            FileUtil.createFile(this.mConfig.tempFile);
            ThreadTaskManager.getInstance().retryThread(this);
            return;
        }
        this.sendFailMsg(null, false);
    }

    private void retryBlockTask(boolean needRetry) {
        if (!NetUtils.isConnected(AriaConfig.getInstance().getAPP()) && !this.isNotNetRetry) {
            ALog.w(this.TAG, String.format("\u5206\u5757\u3010%s\u3011\u91cd\u8bd5\u5931\u8d25\uff0c\u7f51\u7edc\u672a\u8fde\u63a5", this.getFileName()));
            this.sendFailMsg(null, false);
            return;
        }
        if (this.mFailTimes < 2 && needRetry && (NetUtils.isConnected(AriaConfig.getInstance().getAPP()) || this.isNotNetRetry) && !this.isBreak()) {
            ALog.w(this.TAG, String.format("\u5206\u5757\u3010%s\u3011\u7b2c%s\u6b21\u91cd\u8bd5", this.getFileName(), String.valueOf(this.mFailTimes)));
            ++this.mFailTimes;
            this.handleBlockRecord();
            ThreadTaskManager.getInstance().retryThread(this);
            return;
        }
        ALog.e(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u6267\u884c\u5931\u8d25", this.getFileName()));
        this.sendFailMsg(null, needRetry);
    }

    private void handleBlockRecord() {
        if (this.mConfig.isBlock) {
            File temp = this.mConfig.tempFile;
            long blockFileLen = temp.length();
            long threadRect = this.mRecord.blockLen;
            if (!temp.exists()) {
                ALog.i(this.TAG, String.format("\u5206\u5757\u6587\u4ef6\u3010%s\u3011\u4e0d\u5b58\u5728\uff0c\u8be5\u5206\u5757\u5c06\u91cd\u65b0\u5f00\u59cb", temp.getName()));
                this.mRecord.isComplete = false;
                this.mRecord.startLocation = this.mRecord.endLocation - threadRect;
            } else if (blockFileLen > threadRect) {
                ALog.i(this.TAG, String.format("\u5206\u5757\u3010%s\u3011\u9519\u8bef\uff0c\u5c06\u91cd\u65b0\u4e0b\u8f7d\u8be5\u5206\u5757", temp.getName()));
                FileUtil.deleteFile(temp);
                this.mRecord.startLocation = this.mRecord.endLocation - this.mRecord.blockLen;
                this.mRecord.isComplete = false;
            } else if (blockFileLen < this.mRecord.blockLen) {
                this.mRecord.startLocation = this.mRecord.endLocation - this.mRecord.blockLen + blockFileLen;
                this.mRecord.isComplete = false;
                this.updateState(6, null);
                ALog.i(this.TAG, String.format("\u4fee\u6b63\u5206\u5757\u3010%s\u3011\u8bb0\u5f55\uff0c\u5f00\u59cb\u4f4d\u7f6e\uff1a%s\uff0c\u7ed3\u675f\u4f4d\u7f6e\uff1a%s", temp.getName(), this.mRecord.startLocation, this.mRecord.endLocation));
            } else {
                ALog.i(this.TAG, String.format("\u5206\u5757\u3010%s\u3011\u5df2\u5b8c\u6210\uff0c\u66f4\u65b0\u8bb0\u5f55", temp.getName()));
                this.mRecord.isComplete = true;
            }
            this.mRecord.update();
        }
    }

    private void sendFailMsg(AriaException e, boolean needRetry) {
        Bundle b = new Bundle();
        b.putBoolean("DATA_RETRY", needRetry);
        if (e != null) {
            b.putSerializable("DATA_ERROR_INFO", (Serializable)e);
        }
        this.updateState(2, b);
    }

    private void writeConfig(boolean isComplete, long record) {
        if (this.mRecord != null) {
            this.mRecord.isComplete = isComplete;
            if (this.mConfig.isBlock) {
                this.mRecord.startLocation = this.mConfig.tempFile.length();
            } else if (0L < record && record < this.mRecord.endLocation) {
                this.mRecord.startLocation = record;
            }
            this.mRecord.update();
        }
    }

    @Override
    public ThreadTask call() throws Exception {
        this.isDestroy = false;
        Process.setThreadPriority((int)10);
        TrafficStats.setThreadStatsTag((int)UUID.randomUUID().toString().hashCode());
        this.mAdapter.call(this);
        return this;
    }
}

