/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.manager;

import android.text.TextUtils;
import com.arialyy.aria.core.task.IThreadTask;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class ThreadTaskManager {
    private final String TAG = CommonUtil.getClassName(this);
    private static volatile ThreadTaskManager INSTANCE = null;
    private static final int CORE_POOL_NUM = 20;
    private static final ReentrantLock LOCK = new ReentrantLock();
    private ThreadPoolExecutor mExePool;
    private Map<String, Set<FutureContainer>> mThreadTasks = new ConcurrentHashMap<String, Set<FutureContainer>>();

    public static synchronized ThreadTaskManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ThreadTaskManager();
        }
        return INSTANCE;
    }

    private ThreadTaskManager() {
        this.mExePool = new ThreadPoolExecutor(20, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.mExePool.allowsCoreThreadTimeOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllThreadTask() {
        if (this.mThreadTasks.isEmpty()) {
            return;
        }
        try {
            LOCK.tryLock(2L, TimeUnit.SECONDS);
            for (Set<FutureContainer> threads : this.mThreadTasks.values()) {
                for (FutureContainer container : threads) {
                    if (container.future.isDone() || container.future.isCancelled()) continue;
                    container.threadTask.destroy();
                }
                threads.clear();
            }
            this.mThreadTasks.clear();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startThread(String key, IThreadTask threadTask) {
        try {
            LOCK.tryLock(2L, TimeUnit.SECONDS);
            if (this.mExePool.isShutdown()) {
                ALog.e(this.TAG, "\u7ebf\u7a0b\u6c60\u5df2\u7ecf\u5173\u95ed");
                return;
            }
            Set<FutureContainer> temp = this.mThreadTasks.get(key = this.getKey(key));
            if (temp == null) {
                temp = new HashSet<FutureContainer>();
                this.mThreadTasks.put(key, temp);
            }
            FutureContainer container = new FutureContainer();
            container.threadTask = threadTask;
            container.future = this.mExePool.submit(threadTask);
            temp.add(container);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            LOCK.unlock();
        }
    }

    public boolean taskIsRunning(String key) {
        return this.mThreadTasks.get(this.getKey(key)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTaskThread(String key) {
        try {
            LOCK.tryLock(2L, TimeUnit.SECONDS);
            if (this.mExePool.isShutdown()) {
                ALog.e(this.TAG, "\u7ebf\u7a0b\u6c60\u5df2\u7ecf\u5173\u95ed");
                return;
            }
            Set<FutureContainer> temp = this.mThreadTasks.get(key = this.getKey(key));
            if (temp != null && temp.size() > 0) {
                for (FutureContainer container : temp) {
                    if (container.future.isDone() || container.future.isCancelled()) continue;
                    container.threadTask.destroy();
                }
                temp.clear();
                this.mThreadTasks.remove(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSingleTaskThread(String key, String threadName) {
        try {
            LOCK.tryLock(2L, TimeUnit.SECONDS);
            if (this.mExePool.isShutdown()) {
                ALog.e(this.TAG, "\u7ebf\u7a0b\u6c60\u5df2\u7ecf\u5173\u95ed");
                boolean bl = false;
                return bl;
            }
            if (TextUtils.isEmpty((CharSequence)threadName)) {
                ALog.e(this.TAG, "\u7ebf\u7a0b\u540d\u4e3a\u7a7a");
                boolean bl = false;
                return bl;
            }
            Set<FutureContainer> temp = this.mThreadTasks.get(key = this.getKey(key));
            if (temp != null && temp.size() > 0) {
                FutureContainer tempC = null;
                for (FutureContainer container : temp) {
                    if (!container.threadTask.getThreadName().equals(threadName)) continue;
                    tempC = container;
                    break;
                }
                if (tempC != null) {
                    tempC.threadTask.destroy();
                    temp.remove(tempC);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            LOCK.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSingleTaskThread(String key, IThreadTask task) {
        try {
            LOCK.tryLock(2L, TimeUnit.SECONDS);
            if (this.mExePool.isShutdown()) {
                ALog.e(this.TAG, "\u7ebf\u7a0b\u6c60\u5df2\u7ecf\u5173\u95ed");
                boolean bl = false;
                return bl;
            }
            if (task == null) {
                ALog.e(this.TAG, "\u7ebf\u7a0b\u4efb\u52a1\u4e3a\u7a7a");
                boolean bl = false;
                return bl;
            }
            Set<FutureContainer> temp = this.mThreadTasks.get(key = this.getKey(key));
            if (temp != null && temp.size() > 0) {
                FutureContainer tempC = null;
                for (FutureContainer container : temp) {
                    if (container.threadTask != task) continue;
                    tempC = container;
                    break;
                }
                if (tempC != null) {
                    task.destroy();
                    temp.remove(tempC);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            LOCK.unlock();
        }
        return false;
    }

    public void retryThread(IThreadTask task) {
        try {
            LOCK.tryLock(2L, TimeUnit.SECONDS);
            if (this.mExePool.isShutdown()) {
                ALog.e(this.TAG, "\u7ebf\u7a0b\u6c60\u5df2\u7ecf\u5173\u95ed");
                return;
            }
            if (task == null || task.isDestroy()) {
                ALog.e(this.TAG, "\u7ebf\u7a0b\u4e3a\u7a7a\u6216\u7ebf\u7a0b\u5df2\u7ecf\u4e2d\u65ad");
                return;
            }
            this.mExePool.submit(task);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            LOCK.unlock();
        }
    }

    private String getKey(String key) {
        return CommonUtil.getStrMd5(key);
    }

    private class FutureContainer {
        Future future;
        IThreadTask threadTask;

        private FutureContainer() {
        }
    }
}

