/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.loader;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.CompleteInfo;
import com.arialyy.aria.core.inf.IThreadStateManager;
import com.arialyy.aria.core.loader.IInfoTask;
import com.arialyy.aria.core.loader.ILoader;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.core.loader.IRecordHandler;
import com.arialyy.aria.core.loader.IThreadTaskBuilder;
import com.arialyy.aria.core.manager.ThreadTaskManager;
import com.arialyy.aria.core.task.IThreadTask;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public final class SubLoader
implements ILoader,
ILoaderVisitor {
    private String TAG = CommonUtil.getClassName(this);
    private boolean needGetInfo = true;
    private Handler schedulers;
    private boolean isCancel = false;
    private boolean isStop = false;
    private AbsTaskWrapper wrapper;
    private IInfoTask infoTask;
    private IThreadTaskBuilder ttBuild;
    private IRecordHandler recordHandler;
    private List<IThreadTask> mTask = new ArrayList<IThreadTask>();
    private String parentKey;
    private TaskRecord record;
    protected IThreadStateManager mStateManager;

    public SubLoader(AbsTaskWrapper wrapper, Handler schedulers) {
        this.wrapper = wrapper;
        this.schedulers = schedulers;
    }

    public AbsTaskWrapper getWrapper() {
        return this.wrapper;
    }

    private void sendNormalState(int state) {
        Message msg = this.schedulers.obtainMessage();
        Bundle b = msg.getData();
        if (b == null) {
            b = new Bundle();
        }
        b.putString("DATA_THREAD_NAME", this.getKey());
        msg.what = state;
        msg.setData(b);
        msg.sendToTarget();
    }

    private void sendFailState(boolean needRetry) {
        Message msg = this.schedulers.obtainMessage();
        Bundle b = msg.getData();
        if (b == null) {
            b = new Bundle();
        }
        b.putString("DATA_THREAD_NAME", this.getKey());
        b.putBoolean("DATA_RETRY", needRetry);
        msg.what = 2;
        msg.setData(b);
        msg.sendToTarget();
    }

    private void handlerTask() {
        if (this.isBreak()) {
            return;
        }
        Looper looper = Looper.myLooper();
        if (looper == null) {
            Looper.prepare();
            looper = Looper.myLooper();
        }
        this.record = this.recordHandler.getRecord(((AbsEntity)this.wrapper.getEntity()).getFileSize());
        if (this.record == null) {
            ALog.d(this.TAG, "\u5b50\u4efb\u52a1\u8bb0\u5f55\u4e3a\u7a7a");
            this.sendFailState(false);
            return;
        }
        if (this.record.threadRecords != null && !TextUtils.isEmpty((CharSequence)this.record.filePath) && new File(this.record.filePath).exists() && !this.record.threadRecords.isEmpty() && this.record.threadRecords.get((int)0).isComplete) {
            ALog.d(this.TAG, "\u5b50\u4efb\u52a1\u5df2\u5b8c\u6210\uff0ckey\uff1a" + this.wrapper.getKey());
            this.sendNormalState(4);
            return;
        }
        List<IThreadTask> task = this.ttBuild.buildThreadTask(this.record, new Handler(looper, this.mStateManager.getHandlerCallback()));
        this.mStateManager.setLooper(this.record, looper);
        if (task == null || task.isEmpty()) {
            ALog.e(this.TAG, "\u521b\u5efa\u5b50\u4efb\u52a1\u7684\u7ebf\u7a0b\u4efb\u52a1\u5931\u8d25\uff0ckey\uff1a" + this.wrapper.getKey());
            this.sendFailState(false);
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.parentKey)) {
            ALog.e(this.TAG, "parentKey\u4e3a\u7a7a");
            this.sendFailState(false);
            return;
        }
        this.sendNormalState(7);
        this.mTask.addAll(task);
        try {
            for (IThreadTask iThreadTask : this.mTask) {
                ThreadTaskManager.getInstance().startThread(this.parentKey, iThreadTask);
            }
            this.sendNormalState(8);
            this.mStateManager.updateCurrentProgress(((AbsEntity)this.getWrapper().getEntity()).getCurrentProgress());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Looper.loop();
    }

    public TaskRecord getRecord() {
        return this.record;
    }

    public void setParentKey(String parentKey) {
        this.parentKey = parentKey;
    }

    public void setNeedGetInfo(boolean needGetInfo) {
        this.needGetInfo = needGetInfo;
    }

    public void retryTask() {
        try {
            if (!this.mTask.isEmpty()) {
                for (IThreadTask iThreadTask : this.mTask) {
                    iThreadTask.call();
                }
                return;
            }
            ALog.e(this.TAG, "\u5b50\u4efb\u52a1\u7684\u7ebf\u7a0b\u4efb\u52a1\u4e3a\u7a7a");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stop() {
        if (this.isStop) {
            ALog.w(this.TAG, "\u5b50\u4efb\u52a1\u5df2\u505c\u6b62");
            return;
        }
        this.isStop = true;
        for (IThreadTask iThreadTask : this.mTask) {
            iThreadTask.stop();
        }
    }

    @Override
    public boolean isRunning() {
        if (this.mTask.isEmpty()) {
            return false;
        }
        for (IThreadTask iThreadTask : this.mTask) {
            if (iThreadTask.isBreak()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void cancel() {
        if (this.isCancel) {
            ALog.w(this.TAG, "\u5b50\u4efb\u52a1\u5df2\u53d6\u6d88");
            return;
        }
        this.isCancel = true;
        for (IThreadTask iThreadTask : this.mTask) {
            iThreadTask.cancel();
        }
    }

    @Override
    public boolean isBreak() {
        if (this.isCancel || this.isStop) {
            ALog.d(this.TAG, "isCancel = " + this.isCancel + ", isStop = " + this.isStop);
            ALog.d(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u5df2\u505c\u6b62\u6216\u53d6\u6d88\u4e86", this.wrapper.getKey()));
            return true;
        }
        return false;
    }

    @Override
    public String getKey() {
        return CommonUtil.getThreadName(this.wrapper.getKey(), 0);
    }

    @Override
    public long getCurrentProgress() {
        return this.isRunning() ? this.mStateManager.getCurrentProgress() : ((AbsEntity)this.getWrapper().getEntity()).getCurrentProgress();
    }

    @Override
    public void addComponent(IRecordHandler recordHandler) {
        this.recordHandler = recordHandler;
    }

    @Override
    public void addComponent(IInfoTask infoTask) {
        this.infoTask = infoTask;
        infoTask.setCallback(new IInfoTask.Callback(){

            @Override
            public void onSucceed(String key, CompleteInfo info) {
                SubLoader.this.handlerTask();
            }

            @Override
            public void onFail(AbsEntity entity, AriaException e, boolean needRetry) {
                SubLoader.this.sendFailState(needRetry);
            }
        });
    }

    @Override
    public void addComponent(IThreadStateManager threadState) {
        this.mStateManager = threadState;
    }

    @Override
    public void addComponent(IThreadTaskBuilder builder) {
        this.ttBuild = builder;
    }

    @Override
    public void run() {
        this.checkComponent();
        if (this.isBreak()) {
            return;
        }
        if (this.needGetInfo) {
            this.infoTask.run();
            return;
        }
        this.handlerTask();
    }

    private void checkComponent() {
        if (this.recordHandler == null) {
            throw new NullPointerException("\u4efb\u52a1\u8bb0\u5f55\u7ec4\u4ef6\u4e3a\u7a7a");
        }
        if (this.infoTask == null) {
            throw new NullPointerException("\u6587\u4ef6\u4fe1\u606f\u7ec4\u4ef6\u4e3a\u7a7a");
        }
        if (this.ttBuild == null) {
            throw new NullPointerException("\u7ebf\u7a0b\u4efb\u52a1\u7ec4\u4ef6\u4e3a\u7a7a");
        }
    }
}

