/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.loader;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.inf.IThreadStateManager;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.loader.ILoaderVisitor;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class NormalThreadStateManager
implements IThreadStateManager {
    private final String TAG = CommonUtil.getClassName(this);
    private IEventListener mListener;
    private int mThreadNum;
    private AtomicInteger mCancelNum = new AtomicInteger(0);
    private AtomicInteger mStopNum = new AtomicInteger(0);
    private AtomicInteger mFailNum = new AtomicInteger(0);
    private AtomicInteger mCompleteNum = new AtomicInteger(0);
    private long mProgress;
    private TaskRecord mTaskRecord;
    private Looper mLooper;
    private Handler.Callback callback = new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            NormalThreadStateManager.this.checkLooper();
            switch (msg.what) {
                case 1: {
                    NormalThreadStateManager.this.mStopNum.getAndIncrement();
                    if (!NormalThreadStateManager.this.isStop()) break;
                    NormalThreadStateManager.this.quitLooper();
                    break;
                }
                case 3: {
                    NormalThreadStateManager.this.mCancelNum.getAndIncrement();
                    if (!NormalThreadStateManager.this.isCancel()) break;
                    NormalThreadStateManager.this.quitLooper();
                    break;
                }
                case 2: {
                    NormalThreadStateManager.this.mFailNum.getAndIncrement();
                    if (!NormalThreadStateManager.this.isFail()) break;
                    Bundle b = msg.getData();
                    NormalThreadStateManager.this.mListener.onFail(b.getBoolean("DATA_RETRY", false), (AriaException)b.getSerializable("DATA_ERROR_INFO"));
                    NormalThreadStateManager.this.quitLooper();
                    break;
                }
                case 4: {
                    NormalThreadStateManager.this.mCompleteNum.getAndIncrement();
                    if (!NormalThreadStateManager.this.isComplete()) break;
                    ALog.d(NormalThreadStateManager.this.TAG, "isComplete, completeNum = " + NormalThreadStateManager.this.mCompleteNum);
                    if (((NormalThreadStateManager)NormalThreadStateManager.this).mTaskRecord.isBlock) {
                        if (NormalThreadStateManager.this.mergeFile()) {
                            NormalThreadStateManager.this.mListener.onComplete();
                        } else {
                            NormalThreadStateManager.this.mListener.onFail(false, null);
                        }
                    } else {
                        NormalThreadStateManager.this.mListener.onComplete();
                    }
                    NormalThreadStateManager.this.quitLooper();
                    break;
                }
                case 5: {
                    Bundle b = msg.getData();
                    if (b == null) break;
                    long len = b.getLong("DATA_ADD_LEN", 0L);
                    NormalThreadStateManager.this.mProgress = NormalThreadStateManager.this.mProgress + len;
                    break;
                }
                case 6: {
                    if (msg.obj == null) {
                        NormalThreadStateManager.this.mProgress = NormalThreadStateManager.this.updateBlockProgress();
                        break;
                    }
                    if (!(msg.obj instanceof Long)) break;
                    NormalThreadStateManager.this.mProgress = (Long)msg.obj;
                }
            }
            return false;
        }
    };

    public NormalThreadStateManager(IEventListener listener) {
        this.mListener = listener;
    }

    @Override
    public void setLooper(TaskRecord taskRecord, Looper looper) {
        this.mTaskRecord = taskRecord;
        this.mThreadNum = this.mTaskRecord.threadNum;
        this.mLooper = looper;
    }

    private void checkLooper() {
        if (this.mTaskRecord == null) {
            throw new NullPointerException("\u4efb\u52a1\u8bb0\u5f55\u4e3a\u7a7a");
        }
        if (this.mLooper == null) {
            throw new NullPointerException("Looper\u4e3a\u7a7a");
        }
    }

    @Override
    public void updateCurrentProgress(long currentProgress) {
        this.mProgress = currentProgress;
    }

    private void quitLooper() {
        this.mLooper.quit();
    }

    @Override
    public long getCurrentProgress() {
        return this.mProgress;
    }

    @Override
    public Handler.Callback getHandlerCallback() {
        return this.callback;
    }

    public boolean isStop() {
        return this.mStopNum.get() == this.mThreadNum || this.mStopNum.get() + this.mCompleteNum.get() == this.mThreadNum;
    }

    @Override
    public boolean isFail() {
        return this.mCompleteNum.get() != this.mThreadNum && (this.mFailNum.get() == this.mThreadNum || this.mFailNum.get() + this.mCompleteNum.get() == this.mThreadNum);
    }

    @Override
    public boolean isComplete() {
        return this.mCompleteNum.get() == this.mThreadNum;
    }

    public boolean isCancel() {
        return this.mCancelNum.get() == this.mThreadNum;
    }

    private long updateBlockProgress() {
        long size = 0L;
        int len = this.mTaskRecord.threadRecords.size();
        for (int i = 0; i < len; ++i) {
            File temp = new File(String.format("%s.%s.part", this.mTaskRecord.filePath, i));
            if (!temp.exists()) continue;
            size += temp.length();
        }
        return size;
    }

    private boolean mergerSFtp() {
        if (this.mTaskRecord.threadNum == 1) {
            File partFile = new File(String.format("%s.%s.part", this.mTaskRecord.filePath, 0));
            return partFile.renameTo(new File(this.mTaskRecord.filePath));
        }
        ArrayList<String> partPath = new ArrayList<String>();
        int len = this.mTaskRecord.threadNum;
        for (int i = 0; i < len; ++i) {
            partPath.add(String.format("%s.%s.part", this.mTaskRecord.filePath, i));
        }
        FileUtil.mergeSFtpFile(this.mTaskRecord.filePath, partPath, this.mTaskRecord.fileLength);
        for (String pp : partPath) {
            FileUtil.deleteFile(pp);
        }
        return true;
    }

    private boolean mergeFile() {
        if (this.mTaskRecord.threadNum == 1) {
            File partFile = new File(String.format("%s.%s.part", this.mTaskRecord.filePath, 0));
            return partFile.renameTo(new File(this.mTaskRecord.filePath));
        }
        ArrayList<String> partPath = new ArrayList<String>();
        int len = this.mTaskRecord.threadNum;
        for (int i = 0; i < len; ++i) {
            partPath.add(String.format("%s.%s.part", this.mTaskRecord.filePath, i));
        }
        boolean isSuccess = FileUtil.mergeFile(this.mTaskRecord.filePath, partPath);
        if (isSuccess) {
            for (String pp : partPath) {
                FileUtil.deleteFile(pp);
            }
            File targetFile = new File(this.mTaskRecord.filePath);
            if (targetFile.exists() && targetFile.length() > this.mTaskRecord.fileLength) {
                ALog.e(this.TAG, String.format("\u4efb\u52a1\u3010%s\u3011\u5206\u5757\u6587\u4ef6\u5408\u5e76\u5931\u8d25\uff0c\u4e0b\u8f7d\u957f\u5ea6\u8d85\u51fa\u6587\u4ef6\u771f\u5b9e\u957f\u5ea6\uff0cdownloadLen: %s\uff0cfileSize: %s", targetFile.getName(), targetFile.length(), this.mTaskRecord.fileLength));
                return false;
            }
            return true;
        }
        ALog.e(this.TAG, "\u5408\u5e76\u5931\u8d25");
        return false;
    }

    @Override
    public void accept(ILoaderVisitor visitor) {
        visitor.addComponent(this);
    }
}

