/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.loader;

import com.arialyy.aria.core.inf.IUtil;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.loader.AbsNormalLoader;
import com.arialyy.aria.core.loader.LoaderStructure;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;

public abstract class AbsNormalLoaderUtil
implements IUtil {
    protected String TAG = CommonUtil.getClassName(this.getClass());
    private IEventListener mListener;
    protected AbsNormalLoader mLoader;
    private AbsTaskWrapper mTaskWrapper;
    private boolean isStop = false;
    private boolean isCancel = false;

    protected AbsNormalLoaderUtil() {
    }

    @Override
    public IUtil setParams(AbsTaskWrapper taskWrapper, IEventListener listener) {
        this.mTaskWrapper = taskWrapper;
        this.mListener = listener;
        this.mLoader = this.getLoader();
        return this;
    }

    public abstract AbsNormalLoader getLoader();

    public abstract LoaderStructure BuildLoaderStructure();

    @Override
    public String getKey() {
        return this.mTaskWrapper.getKey();
    }

    @Override
    public long getFileSize() {
        return this.mLoader.getFileSize();
    }

    @Override
    public long getCurrentLocation() {
        return this.mLoader.getCurrentProgress();
    }

    @Override
    public boolean isRunning() {
        return this.mLoader.isRunning();
    }

    @Override
    public void cancel() {
        this.isCancel = true;
        this.mLoader.cancel();
        this.onCancel();
    }

    protected void onCancel() {
    }

    @Override
    public void stop() {
        this.isStop = true;
        this.mLoader.stop();
        this.onStop();
    }

    protected void onStop() {
    }

    @Override
    public void start() {
        if (this.isStop || this.isCancel) {
            ALog.w(this.TAG, "\u542f\u52a8\u4efb\u52a1\u5931\u8d25\uff0c\u4efb\u52a1\u5df2\u505c\u6b62\u6216\u5df2\u53d6\u6d88");
            return;
        }
        this.mListener.onPre();
        this.BuildLoaderStructure();
        new Thread(this.mLoader).start();
        this.onStart();
    }

    protected void onStart() {
    }

    public boolean isStop() {
        return this.isStop;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public IEventListener getListener() {
        return this.mListener;
    }

    protected void fail(AriaException e, boolean needRetry) {
        if (this.isStop || this.isCancel) {
            return;
        }
        this.mListener.onFail(needRetry, e);
        this.mLoader.onDestroy();
    }

    public AbsTaskWrapper getTaskWrapper() {
        return this.mTaskWrapper;
    }
}

