/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.listener;

import android.os.Handler;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.group.GroupSendParams;
import com.arialyy.aria.core.listener.BaseListener;
import com.arialyy.aria.core.listener.IDGroupListener;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.task.AbsTask;
import com.arialyy.aria.core.task.DownloadGroupTask;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.DeleteDGRecord;
import com.arialyy.aria.util.ErrorHelp;

public class DownloadGroupListener
extends BaseListener
implements IDGroupListener {
    private GroupSendParams<DownloadGroupTask, DownloadEntity> mSeedEntity;

    @Override
    public IEventListener setParams(AbsTask task, Handler outHandler) {
        IEventListener listener = super.setParams(task, outHandler);
        this.mSeedEntity = new GroupSendParams();
        this.mSeedEntity.groupTask = (DownloadGroupTask)task;
        return listener;
    }

    @Override
    public void onSubPre(DownloadEntity subEntity) {
        this.handleSubSpeed(subEntity, 0L);
        this.saveSubState(5, subEntity);
        this.sendInState2Target(161, subEntity);
    }

    @Override
    public void supportBreakpoint(boolean support, DownloadEntity subEntity) {
    }

    @Override
    public void onSubStart(DownloadEntity subEntity) {
        this.handleSubSpeed(subEntity, 0L);
        this.saveSubState(4, subEntity);
        this.sendInState2Target(162, subEntity);
    }

    @Override
    public void onSubStop(DownloadEntity subEntity, long stopLocation) {
        subEntity.setCurrentProgress(stopLocation);
        this.handleSubSpeed(subEntity, 0L);
        this.saveSubState(2, subEntity);
        this.saveCurrentLocation();
        this.sendInState2Target(163, subEntity);
    }

    @Override
    public void onSubComplete(DownloadEntity subEntity) {
        this.handleSubSpeed(subEntity, 0L);
        this.saveSubState(1, subEntity);
        this.saveCurrentLocation();
        this.sendInState2Target(167, subEntity);
    }

    @Override
    public void onSubFail(DownloadEntity subEntity, AriaException e) {
        this.handleSubSpeed(subEntity, 0L);
        this.saveSubState(0, subEntity);
        this.saveCurrentLocation();
        ((DownloadGroupTask)this.mSeedEntity.groupTask).putExpand("ERROR_INFO_KEY", e);
        this.sendInState2Target(165, subEntity);
        if (e != null) {
            e.printStackTrace();
            ErrorHelp.saveError("", ALog.getExceptionString(e));
        }
    }

    @Override
    public void onSubCancel(DownloadEntity subEntity) {
        this.handleSubSpeed(subEntity, 0L);
        this.saveSubState(7, subEntity);
        this.saveCurrentLocation();
        this.sendInState2Target(164, subEntity);
    }

    @Override
    public void onSubRunning(DownloadEntity subEntity, long currentProgress) {
        this.handleSubSpeed(subEntity, currentProgress);
        if (System.currentTimeMillis() - this.mLastSaveTime >= 5000L) {
            this.saveSubState(4, subEntity);
            this.mLastSaveTime = System.currentTimeMillis();
        }
        this.sendInState2Target(166, subEntity);
    }

    private void handleSubSpeed(DownloadEntity subEntity, long currentProgress) {
        if (currentProgress == 0L) {
            subEntity.setSpeed(0L);
            subEntity.setConvertSpeed("0kb/s");
            return;
        }
        long speed = currentProgress - subEntity.getCurrentProgress();
        subEntity.setSpeed(speed);
        subEntity.setConvertSpeed(speed <= 0L ? "" : String.format("%s/s", CommonUtil.formatFileSize(speed)));
        subEntity.setPercent((int)(subEntity.getFileSize() <= 0L ? 0L : subEntity.getCurrentProgress() * 100L / subEntity.getFileSize()));
        subEntity.setCurrentProgress(currentProgress);
        if (speed == 0L) {
            subEntity.setTimeLeft(Integer.MAX_VALUE);
        } else {
            subEntity.setTimeLeft((int)((subEntity.getFileSize() - subEntity.getCurrentProgress()) / speed));
        }
    }

    private void sendInState2Target(int state, DownloadEntity subEntity) {
        if (this.outHandler.get() != null) {
            this.mSeedEntity.entity = subEntity;
            ((Handler)this.outHandler.get()).obtainMessage(state, 209, 0, this.mSeedEntity).sendToTarget();
        }
    }

    private void saveSubState(int state, DownloadEntity subEntity) {
        subEntity.setState(state);
        if (state == 2) {
            subEntity.setStopTime(System.currentTimeMillis());
        } else if (state == 1) {
            subEntity.setComplete(true);
            subEntity.setCompleteTime(System.currentTimeMillis());
            subEntity.setCurrentProgress(subEntity.getFileSize());
            subEntity.setPercent(100);
            subEntity.setConvertSpeed("0kb/s");
            subEntity.setSpeed(0L);
        }
        subEntity.update();
    }

    private void saveCurrentLocation() {
        DownloadGroupEntity dgEntity = (DownloadGroupEntity)this.mEntity;
        if (dgEntity.getSubEntities() == null || dgEntity.getSubEntities().isEmpty()) {
            ALog.w(this.TAG, "\u4fdd\u5b58\u8fdb\u5ea6\u5931\u8d25\uff0c\u5b50\u4efb\u52a1\u4e3anull");
            return;
        }
        long location = 0L;
        for (DownloadEntity e : dgEntity.getSubEntities()) {
            location += e.getCurrentProgress();
        }
        if (location > this.mEntity.getFileSize()) {
            location = this.mEntity.getFileSize();
        }
        this.mEntity.setCurrentProgress(location);
        this.mEntity.update();
    }

    @Override
    public void onPostPre(long fileSize) {
        this.mEntity.setFileSize(fileSize);
        this.mEntity.setConvertFileSize(CommonUtil.formatFileSize(fileSize));
        this.saveData(6, -1L);
        this.sendInState2Target(1);
    }

    @Override
    public void supportBreakpoint(boolean support) {
    }

    @Override
    protected void handleCancel() {
        int sType = this.getTask(DownloadGroupTask.class).getSchedulerType();
        if (sType == 4) {
            this.mEntity.setComplete(false);
            this.mEntity.setState(3);
            DeleteDGRecord.getInstance().deleteRecord(this.mEntity, this.mTaskWrapper.isRemoveFile(), false);
        } else {
            DeleteDGRecord.getInstance().deleteRecord(this.mEntity, this.mTaskWrapper.isRemoveFile(), true);
        }
    }
}

