/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.listener;

import android.os.Handler;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.listener.IEventListener;
import com.arialyy.aria.core.task.AbsTask;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.exception.AriaException;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.ErrorHelp;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public abstract class BaseListener
implements IEventListener {
    protected String TAG = this.getClass().getSimpleName();
    static final int RUN_SAVE_INTERVAL = 5000;
    protected SoftReference<Handler> outHandler;
    private long mLastLen;
    private boolean isFirst = true;
    private AbsTask mTask;
    long mLastSaveTime;
    protected AbsEntity mEntity;
    protected AbsTaskWrapper mTaskWrapper;
    private boolean isConvertSpeed;
    private long mUpdateInterval;

    @Override
    public IEventListener setParams(AbsTask task, Handler outHandler) {
        this.outHandler = new SoftReference<Handler>(outHandler);
        this.mTask = (AbsTask)new WeakReference<AbsTask>(task).get();
        this.mEntity = ((AbsTaskWrapper)this.mTask.getTaskWrapper()).getEntity();
        this.mTaskWrapper = this.mTask.getTaskWrapper();
        this.isConvertSpeed = this.mTaskWrapper.getConfig().isConvertSpeed();
        this.mUpdateInterval = this.mTaskWrapper.getConfig().getUpdateInterval();
        this.mLastLen = this.mEntity.getCurrentProgress();
        this.mLastSaveTime = System.currentTimeMillis();
        this.TAG = CommonUtil.getClassName(this.getClass());
        return this;
    }

    protected <TASK extends AbsTask> TASK getTask(Class<TASK> clazz) {
        return (TASK)this.mTask;
    }

    @Override
    public void onPre() {
        this.saveData(5, -1L);
        this.sendInState2Target(0);
    }

    @Override
    public void onStart(long startLocation) {
        this.saveData(4, startLocation);
        this.sendInState2Target(2);
    }

    @Override
    public void onResume(long resumeLocation) {
        this.saveData(4, resumeLocation);
        this.sendInState2Target(8);
    }

    @Override
    public void onProgress(long currentLocation) {
        this.mEntity.setCurrentProgress(currentLocation);
        long speed = currentLocation - this.mLastLen;
        if (this.isFirst) {
            speed = 0L;
            this.isFirst = false;
        }
        this.handleSpeed(speed);
        this.sendInState2Target(7);
        if (System.currentTimeMillis() - this.mLastSaveTime >= 5000L) {
            this.saveData(4, currentLocation);
            this.mLastSaveTime = System.currentTimeMillis();
        }
        this.mLastLen = currentLocation;
    }

    @Override
    public void onStop(long stopLocation) {
        this.saveData(this.mTask.getSchedulerType() == 3 ? 3 : 2, stopLocation);
        this.handleSpeed(0L);
        this.sendInState2Target(3);
    }

    @Override
    public void onComplete() {
        this.saveData(1, this.mEntity.getFileSize());
        this.handleSpeed(0L);
        this.sendInState2Target(6);
    }

    @Override
    public void onCancel() {
        this.saveData(7, -1L);
        this.handleSpeed(0L);
        if (this.mTask.getSchedulerType() != 4) {
            ALog.d(this.TAG, "\u5220\u9664\u4efb\u52a1\u5b8c\u6210");
            this.sendInState2Target(5);
        }
    }

    @Override
    public void onFail(boolean needRetry, AriaException e) {
        this.mEntity.setFailNum(this.mEntity.getFailNum() + 1);
        this.saveData(0, this.mEntity.getCurrentProgress());
        this.handleSpeed(0L);
        this.mTask.setNeedRetry(needRetry);
        this.mTask.putExpand("ERROR_INFO_KEY", e);
        this.sendInState2Target(4);
        if (e != null) {
            String error = ALog.getExceptionString(e);
            ALog.e(this.TAG, error);
            ErrorHelp.saveError(e.getMessage(), error);
        }
    }

    private void handleSpeed(long speed) {
        if (this.mUpdateInterval != 1000L) {
            speed = speed * 1000L / this.mUpdateInterval;
        }
        if (this.isConvertSpeed) {
            this.mEntity.setConvertSpeed(CommonUtil.formatFileSize(speed < 0L ? 0.0 : (double)speed) + "/s");
        }
        this.mEntity.setSpeed(speed < 0L ? 0L : speed);
        int taskType = this.mTaskWrapper.getRequestType();
        if (taskType != 7 && taskType != 8) {
            this.mEntity.setPercent((int)(this.mEntity.getFileSize() <= 0L ? 0L : this.mEntity.getCurrentProgress() * 100L / this.mEntity.getFileSize()));
        }
        if (this.mEntity.getFileSize() != 0L) {
            if (speed == 0L) {
                this.mEntity.setTimeLeft(Integer.MAX_VALUE);
            } else {
                this.mEntity.setTimeLeft((int)((this.mEntity.getFileSize() - this.mEntity.getCurrentProgress()) / speed));
            }
        }
    }

    private void handleComplete() {
        this.mEntity.setComplete(true);
        this.mEntity.setCompleteTime(System.currentTimeMillis());
        this.mEntity.setCurrentProgress(this.mEntity.getFileSize());
        this.mEntity.setPercent(100);
        this.handleSpeed(0L);
    }

    protected abstract void handleCancel();

    protected void sendInState2Target(int state) {
        if (this.outHandler.get() != null) {
            this.outHandler.get().obtainMessage(state, (Object)this.mTask).sendToTarget();
        }
    }

    protected void saveData(int state, long location) {
        this.mEntity.setState(state);
        if (state == 7) {
            this.handleCancel();
            return;
        }
        if (state == 2) {
            this.mEntity.setStopTime(System.currentTimeMillis());
        } else if (state == 1) {
            this.handleComplete();
        }
        if (location > 0L) {
            this.mEntity.setCurrentProgress(location);
        }
        this.mEntity.update();
    }
}

