/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.group;

import com.arialyy.aria.core.group.SimpleSubQueue;
import com.arialyy.aria.core.listener.IDGroupListener;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class GroupRunState {
    private String TAG = "GroupRunState";
    private int mSubSize;
    private AtomicInteger mCompleteNum = new AtomicInteger();
    private AtomicInteger mFailNum = new AtomicInteger();
    private AtomicInteger mStopNum = new AtomicInteger();
    private long mProgress;
    IDGroupListener listener;
    SimpleSubQueue queue;
    AtomicBoolean isRunning = new AtomicBoolean(false);
    private Set<String> mFailTemp = new HashSet<String>();
    private Set<String> mStopTemp = new HashSet<String>();
    private String mGroupHash;

    GroupRunState(String groupHash, IDGroupListener listener, SimpleSubQueue queue) {
        this.listener = listener;
        this.queue = queue;
        this.mGroupHash = groupHash;
    }

    public void setSubSize(int subSize) {
        this.mSubSize = subSize;
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public void setRunning(boolean running) {
        this.isRunning.set(running);
    }

    String getGroupHash() {
        return this.mGroupHash;
    }

    public int getSubSize() {
        return this.mSubSize;
    }

    public int getFailNum() {
        return this.mFailNum.get();
    }

    public int getStopNum() {
        return this.mStopNum.get();
    }

    public int getCompleteNum() {
        return this.mCompleteNum.get();
    }

    public long getProgress() {
        return this.mProgress;
    }

    public void updateCompleteNum() {
        this.mCompleteNum.getAndIncrement();
    }

    public void updateProgress(long newProgress) {
        this.mProgress = newProgress;
    }

    public void updateCount(String key) {
        if (this.mFailTemp.contains(key)) {
            this.mFailTemp.remove(key);
            this.mFailNum.getAndDecrement();
        } else if (this.mStopTemp.contains(key)) {
            this.mStopTemp.remove(key);
            this.mStopNum.getAndDecrement();
        }
    }

    public void countStopNum(String key) {
        this.mStopTemp.add(key);
        this.mStopNum.getAndIncrement();
    }

    public void countFailNum(String key) {
        this.mFailTemp.add(key);
        this.mFailNum.getAndIncrement();
    }
}

