/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.event;

import com.arialyy.aria.core.event.Event;
import com.arialyy.aria.core.event.EventMethodInfo;
import com.arialyy.aria.util.ALog;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class EventMsgUtil {
    private static final String TAG = "EventUtil";
    private static EventMsgUtil defaultInstance;
    private Map<Object, List<EventMethodInfo>> mEventMethods = new ConcurrentHashMap<Object, List<EventMethodInfo>>();
    private ArrayBlockingQueue<Object> mEventQueue = new ArrayBlockingQueue(10);
    private ExecutorService mPool = Executors.newFixedThreadPool(5);

    private EventMsgUtil() {
        ExecutorService pool = Executors.newSingleThreadExecutor();
        pool.execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Object info = EventMsgUtil.this.mEventQueue.take();
                            EventMsgUtil.this.sendEvent(info);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }

    private void sendEvent(final Object param) {
        this.mPool.submit(new Runnable(){

            @Override
            public void run() {
                Set keys = EventMsgUtil.this.mEventMethods.keySet();
                for (Object key : keys) {
                    List list = (List)EventMsgUtil.this.mEventMethods.get(key);
                    if (list == null || list.isEmpty()) continue;
                    for (EventMethodInfo info : list) {
                        try {
                            if (info.param != param.getClass()) continue;
                            Method method = key.getClass().getDeclaredMethod(info.methodName, info.param);
                            method.setAccessible(true);
                            method.invoke(key, param);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventMsgUtil getDefault() {
        if (defaultInstance != null) return defaultInstance;
        Class<EventMsgUtil> clazz = EventMsgUtil.class;
        synchronized (EventMsgUtil.class) {
            if (defaultInstance != null) return defaultInstance;
            defaultInstance = new EventMsgUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    public void register(Object obj) {
        Method[] methods;
        for (Method method : methods = obj.getClass().getDeclaredMethods()) {
            method.setAccessible(true);
            if (method.getAnnotation(Event.class) == null) continue;
            Class<?>[] clazz = method.getParameterTypes();
            if (clazz.length == 0 || clazz.length > 1) {
                ALog.e(TAG, String.format("%s.%s\u53c2\u6570\u6570\u91cf\u4e3a0\u6216\u53c2\u6570\u6570\u91cf\u5927\u4e8e1", obj.getClass().getName(), method.getName()));
                continue;
            }
            int modifier = method.getModifiers();
            if (Modifier.isStatic(modifier) || Modifier.isAbstract(modifier) || Modifier.isFinal(modifier)) {
                ALog.e(TAG, "\u6ce8\u518c\u7684\u65b9\u6cd5\u4e0d\u80fd\u4f7f\u7528final\u3001static\u3001abstract\u4fee\u9970");
                continue;
            }
            EventMethodInfo methodInfo = new EventMethodInfo();
            methodInfo.methodName = method.getName();
            methodInfo.param = clazz[0];
            List<EventMethodInfo> list = this.mEventMethods.get(obj);
            if (list == null) {
                list = new ArrayList<EventMethodInfo>();
                this.mEventMethods.put(obj, list);
            }
            list.add(methodInfo);
        }
    }

    public void unRegister(Object obj) {
        Iterator<Map.Entry<Object, List<EventMethodInfo>>> iter = this.mEventMethods.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, List<EventMethodInfo>> entry = iter.next();
            if (!entry.getKey().equals(obj)) continue;
            entry.getValue().clear();
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Object param) {
        Class<EventMsgUtil> clazz = EventMsgUtil.class;
        synchronized (EventMsgUtil.class) {
            try {
                this.mEventQueue.offer(param, 2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return;
        }
    }
}

