/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.download;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.ThreadRecord;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.orm.annotation.Default;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.DbDataHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;

public class M3U8Entity
extends DbEntity
implements Parcelable {
    private String filePath;
    private int peerIndex;
    private int peerNum;
    private boolean isLive;
    private String cacheDir;
    public String keyPath;
    public String keyUrl;
    public String method;
    public String iv;
    public String keyFormat;
    @Default(value="1")
    public String keyFormatVersion = "1";
    public static final Parcelable.Creator<M3U8Entity> CREATOR = new Parcelable.Creator<M3U8Entity>(){

        public M3U8Entity createFromParcel(Parcel source) {
            return new M3U8Entity(source);
        }

        public M3U8Entity[] newArray(int size) {
            return new M3U8Entity[size];
        }
    };

    public String getKeyFormat() {
        return this.keyFormat;
    }

    public void setKeyFormat(String keyFormat) {
        this.keyFormat = keyFormat;
    }

    public String getKeyFormatVersion() {
        return this.keyFormatVersion;
    }

    public void setKeyFormatVersion(String keyFormatVersion) {
        this.keyFormatVersion = keyFormatVersion;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public String getKeyUrl() {
        return this.keyUrl;
    }

    public void setKeyUrl(String keyUrl) {
        this.keyUrl = keyUrl;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getIv() {
        return this.iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public List<PeerInfo> getCompletedPeer() {
        if (TextUtils.isEmpty((CharSequence)this.getCacheDir())) {
            ALog.w("M3U8Entity", "\u4efb\u52a1\u672a\u4e0b\u8f7d\uff0c\u83b7\u53d6\u5207\u7247\u5931\u8d25");
            return null;
        }
        ArrayList<PeerInfo> peers = new ArrayList<PeerInfo>();
        TaskRecord taskRecord = DbDataHelper.getTaskRecord(this.filePath, this.isLive ? 8 : 7);
        File cacheDir = new File(this.getCacheDir());
        if ((taskRecord == null || taskRecord.threadRecords == null || taskRecord.threadRecords.isEmpty()) && !cacheDir.exists()) {
            return null;
        }
        if (taskRecord == null || taskRecord.threadRecords == null || taskRecord.threadRecords.isEmpty() && cacheDir.exists()) {
            String[] files;
            for (String fileName : files = cacheDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".ts");
                }
            })) {
                PeerInfo peerInfo = new PeerInfo(Integer.parseInt(fileName.substring(0, fileName.lastIndexOf(".ts"))), this.getCacheDir().concat("/").concat(fileName));
                peers.add(peerInfo);
            }
            return peers;
        }
        if (taskRecord.threadRecords != null && !taskRecord.threadRecords.isEmpty() && cacheDir.exists()) {
            for (ThreadRecord tr : taskRecord.threadRecords) {
                String peerPath;
                if (!tr.isComplete || !new File(peerPath = String.format("%s/%s.ts", cacheDir, tr.threadId)).exists()) continue;
                PeerInfo peerInfo = new PeerInfo(tr.threadId, peerPath);
                peers.add(peerInfo);
            }
            return peers;
        }
        return null;
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public void setLive(boolean live) {
        this.isLive = live;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getPeerIndex() {
        return this.peerIndex;
    }

    public void setPeerIndex(int peerIndex) {
        this.peerIndex = peerIndex;
    }

    public int getPeerNum() {
        return this.peerNum;
    }

    public void setPeerNum(int peerNum) {
        this.peerNum = peerNum;
    }

    public M3U8Entity() {
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.filePath);
        dest.writeInt(this.peerIndex);
        dest.writeInt(this.peerNum);
        dest.writeByte(this.isLive ? (byte)1 : 0);
        dest.writeString(this.cacheDir);
        dest.writeString(this.keyPath);
        dest.writeString(this.keyUrl);
        dest.writeString(this.method);
        dest.writeString(this.iv);
    }

    protected M3U8Entity(Parcel in) {
        this.filePath = in.readString();
        this.peerIndex = in.readInt();
        this.peerNum = in.readInt();
        this.isLive = in.readByte() != 0;
        this.cacheDir = in.readString();
        this.keyPath = in.readString();
        this.keyUrl = in.readString();
        this.method = in.readString();
        this.iv = in.readString();
    }

    public static class PeerInfo {
        public int peerId;
        public String peerPath;

        public PeerInfo(int peerId, String peerPath) {
            this.peerId = peerId;
            this.peerPath = peerPath;
        }
    }
}

