/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.config;

import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.config.AppConfig;
import com.arialyy.aria.core.config.DGroupConfig;
import com.arialyy.aria.core.config.DownloadConfig;
import com.arialyy.aria.core.config.UploadConfig;
import com.arialyy.aria.util.FileUtil;
import java.io.File;

public final class Configuration {
    private static final String TAG = "Configuration";
    private static volatile Configuration INSTANCE = null;
    public static final String XML_FILE = "/Aria/aria_config.xml";
    static final String DOWNLOAD_CONFIG_FILE = "/Aria/AriaDownload.cfg";
    static final String UPLOAD_CONFIG_FILE = "/Aria/AriaUpload.cfg";
    static final String APP_CONFIG_FILE = "/Aria/AriaApp.cfg";
    static final String DGROUP_CONFIG_FILE = "/Aria/AriaDGroup.cfg";
    public DownloadConfig downloadCfg;
    public UploadConfig uploadCfg;
    public AppConfig appCfg;
    public DGroupConfig dGroupCfg;

    private Configuration() {
        String basePath = AriaConfig.getInstance().getAPP().getFilesDir().getPath();
        this.del351Config(basePath);
        File newDCfg = new File(String.format("%s%s", basePath, DOWNLOAD_CONFIG_FILE));
        File newUCfg = new File(String.format("%s%s", basePath, UPLOAD_CONFIG_FILE));
        File newACfg = new File(String.format("%s%s", basePath, APP_CONFIG_FILE));
        File dgCfg = new File(String.format("%s%s", basePath, DGROUP_CONFIG_FILE));
        if (newDCfg.exists()) {
            this.downloadCfg = (DownloadConfig)FileUtil.readObjFromFile(newDCfg.getPath());
        }
        if (this.downloadCfg == null) {
            this.downloadCfg = new DownloadConfig();
        }
        if (newUCfg.exists()) {
            this.uploadCfg = (UploadConfig)FileUtil.readObjFromFile(newUCfg.getPath());
        }
        if (this.uploadCfg == null) {
            this.uploadCfg = new UploadConfig();
        }
        if (newACfg.exists()) {
            this.appCfg = (AppConfig)FileUtil.readObjFromFile(newACfg.getPath());
        }
        if (this.appCfg == null) {
            this.appCfg = new AppConfig();
        }
        if (dgCfg.exists()) {
            this.dGroupCfg = (DGroupConfig)FileUtil.readObjFromFile(dgCfg.getPath());
        }
        if (this.dGroupCfg == null) {
            this.dGroupCfg = new DGroupConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Configuration getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<AppConfig> clazz = AppConfig.class;
        synchronized (AppConfig.class) {
            INSTANCE = new Configuration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public boolean configExists() {
        String basePath = AriaConfig.getInstance().getAPP().getFilesDir().getPath();
        return new File(String.format("%s%s", basePath, DOWNLOAD_CONFIG_FILE)).exists() && new File(String.format("%s%s", basePath, UPLOAD_CONFIG_FILE)).exists() && new File(String.format("%s%s", basePath, APP_CONFIG_FILE)).exists() && new File(String.format("%s%s", basePath, DGROUP_CONFIG_FILE)).exists();
    }

    private void del351Config(String basePath) {
        File oldDCfg = new File(String.format("%s/Aria/DownloadConfig.properties", basePath));
        if (oldDCfg.exists()) {
            File oldUCfg = new File(String.format("%s/Aria/UploadConfig.properties", basePath));
            File oldACfg = new File(String.format("%s/Aria/AppConfig.properties", basePath));
            oldDCfg.delete();
            oldUCfg.delete();
            oldACfg.delete();
            File temp = new File(String.format("%s%s", basePath, XML_FILE));
            if (temp.exists()) {
                temp.delete();
            }
        }
    }
}

