/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core;

import com.arialyy.aria.core.common.BaseOption;
import com.arialyy.aria.core.inf.IEventHandler;
import com.arialyy.aria.core.processor.FtpInterceptHandler;
import com.arialyy.aria.core.processor.IBandWidthUrlConverter;
import com.arialyy.aria.core.processor.IFtpUploadInterceptor;
import com.arialyy.aria.core.processor.IHttpFileLenAdapter;
import com.arialyy.aria.core.processor.IHttpFileNameAdapter;
import com.arialyy.aria.core.processor.IKeyUrlConverter;
import com.arialyy.aria.core.processor.ILiveTsUrlConverter;
import com.arialyy.aria.core.processor.ITsMergeHandler;
import com.arialyy.aria.core.processor.IVodTsUrlConverter;
import com.arialyy.aria.util.CommonUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TaskOptionParams {
    private static List<Class> PROCESSORES = new ArrayList<Class>();
    private Map<String, Object> params = new HashMap<String, Object>();
    private Map<String, IEventHandler> handler = new HashMap<String, IEventHandler>();

    public void setParams(BaseOption option) {
        List<Field> fields = CommonUtil.getAllFields(option.getClass());
        for (Field field : fields) {
            field.setAccessible(true);
            try {
                if (PROCESSORES.contains(field.getType())) {
                    Object eventHandler = field.get(option);
                    if (eventHandler == null) continue;
                    this.setObjs(field.getName(), (IEventHandler)eventHandler);
                    continue;
                }
                Object params = field.get(option);
                if (params == null) continue;
                this.setParams(field.getName(), params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public TaskOptionParams setParams(String key, Object value) {
        this.params.put(key, value);
        return this;
    }

    public TaskOptionParams setObjs(String key, IEventHandler handler) {
        this.handler.put(key, handler);
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Object getParam(String key) {
        return this.params.get(key);
    }

    public IEventHandler getHandler(String key) {
        return this.handler.get(key);
    }

    public Map<String, IEventHandler> getHandler() {
        return this.handler;
    }

    static {
        PROCESSORES.add(FtpInterceptHandler.class);
        PROCESSORES.add(IBandWidthUrlConverter.class);
        PROCESSORES.add(IFtpUploadInterceptor.class);
        PROCESSORES.add(IHttpFileLenAdapter.class);
        PROCESSORES.add(IHttpFileNameAdapter.class);
        PROCESSORES.add(ILiveTsUrlConverter.class);
        PROCESSORES.add(ITsMergeHandler.class);
        PROCESSORES.add(IVodTsUrlConverter.class);
        PROCESSORES.add(IKeyUrlConverter.class);
    }
}

