/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.arialyy.aria.core.config.AppConfig;
import com.arialyy.aria.core.config.Configuration;
import com.arialyy.aria.core.config.DGroupConfig;
import com.arialyy.aria.core.config.DownloadConfig;
import com.arialyy.aria.core.config.UploadConfig;
import com.arialyy.aria.core.config.XMLReader;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AriaConfig {
    private static final String TAG = "AriaConfig";
    public static final String DOWNLOAD_TEMP_DIR = "/Aria/temp/download/";
    public static final String UPLOAD_TEMP_DIR = "/Aria/temp/upload/";
    public static final String IGNORE_CLASS_KLASS = "shadow$_klass_";
    public static final String IGNORE_CLASS_MONITOR = "shadow$_monitor_";
    private static volatile AriaConfig Instance;
    private static Context APP;
    private DownloadConfig mDConfig;
    private UploadConfig mUConfig;
    private AppConfig mAConfig;
    private DGroupConfig mDGConfig;
    private static boolean isConnectedNet;
    private Handler mAriaHandler;

    private AriaConfig(Context context) {
        APP = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AriaConfig init(Context context) {
        if (Instance != null) return Instance;
        Class<AriaConfig> clazz = AriaConfig.class;
        synchronized (AriaConfig.class) {
            if (Instance != null) return Instance;
            Instance = new AriaConfig(context);
            Instance.initData();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return Instance;
        }
    }

    public static AriaConfig getInstance() {
        if (Instance == null) {
            ALog.e(TAG, "\u8bf7\u4f7f\u7528init()\u521d\u59cb\u5316");
        }
        return Instance;
    }

    public Context getAPP() {
        return APP;
    }

    private void initData() {
        this.initConfig();
        this.regNetCallBack(APP);
    }

    public DownloadConfig getDConfig() {
        return this.mDConfig;
    }

    public UploadConfig getUConfig() {
        return this.mUConfig;
    }

    public AppConfig getAConfig() {
        return this.mAConfig;
    }

    public DGroupConfig getDGConfig() {
        return this.mDGConfig;
    }

    public synchronized Handler getAriaHandler() {
        if (this.mAriaHandler == null) {
            this.mAriaHandler = new Handler(Looper.getMainLooper());
        }
        return this.mAriaHandler;
    }

    private void regNetCallBack(Context context) {
        isConnectedNet = this.isNetworkAvailable();
        if (!this.getAConfig().isNetCheck()) {
            return;
        }
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return;
        }
        NetworkRequest.Builder builder = new NetworkRequest.Builder();
        NetworkRequest request = builder.addCapability(12).addTransportType(1).addTransportType(0).build();
        if (Build.VERSION.SDK_INT >= 21) {
            cm.registerNetworkCallback(request, new ConnectivityManager.NetworkCallback(){

                public void onLost(Network network) {
                    super.onLost(network);
                    isConnectedNet = AriaConfig.this.isNetworkAvailable();
                    ALog.d(AriaConfig.TAG, "onLost, isConnectNet = " + isConnectedNet);
                }

                public void onAvailable(Network network) {
                    super.onAvailable(network);
                    isConnectedNet = true;
                    ALog.d(AriaConfig.TAG, "onAvailable, isConnectNet = true");
                }
            });
        }
    }

    private boolean isNetworkAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.getAPP().getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo[] networkInfo = connectivityManager.getAllNetworkInfo();
        if (networkInfo != null && networkInfo.length > 0) {
            for (NetworkInfo info : networkInfo) {
                if (info.getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConnectedNet() {
        return isConnectedNet;
    }

    private void initConfig() {
        this.mDConfig = Configuration.getInstance().downloadCfg;
        this.mUConfig = Configuration.getInstance().uploadCfg;
        this.mAConfig = Configuration.getInstance().appCfg;
        this.mDGConfig = Configuration.getInstance().dGroupCfg;
        File xmlFile = new File(APP.getFilesDir().getPath() + "/Aria/aria_config.xml");
        File tempDir = new File(APP.getFilesDir().getPath() + "/temp");
        if (!xmlFile.exists()) {
            this.loadConfig();
        } else {
            try {
                String md5Code = CommonUtil.getFileMD5(xmlFile);
                File file = new File(APP.getFilesDir().getPath() + "/temp.xml");
                if (file.exists()) {
                    file.delete();
                }
                FileUtil.createFileFormInputStream(APP.getAssets().open("aria_config.xml"), file.getPath());
                if (!CommonUtil.checkMD5(md5Code, file) || !Configuration.getInstance().configExists()) {
                    this.loadConfig();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (tempDir.exists()) {
            File newDir = new File(APP.getFilesDir().getPath() + DOWNLOAD_TEMP_DIR);
            newDir.mkdirs();
            tempDir.renameTo(newDir);
        }
    }

    private void loadConfig() {
        try {
            XMLReader helper = new XMLReader();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(APP.getAssets().open("aria_config.xml"), (DefaultHandler)helper);
            FileUtil.createFileFormInputStream(APP.getAssets().open("aria_config.xml"), APP.getFilesDir().getPath() + "/Aria/aria_config.xml");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            ALog.e(TAG, e.toString());
        }
    }

    static {
        isConnectedNet = true;
    }
}

