/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.upload.target;

import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.AbsNormalTarget;
import com.arialyy.aria.core.event.ErrorEvent;
import com.arialyy.aria.core.inf.AbsTarget;
import com.arialyy.aria.core.inf.IConfigHandler;
import com.arialyy.aria.core.manager.TaskWrapperManager;
import com.arialyy.aria.core.queue.UTaskQueue;
import com.arialyy.aria.core.task.UploadTask;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.orm.DbEntity;
import java.io.File;

class UNormalConfigHandler<TARGET extends AbsTarget>
implements IConfigHandler {
    private UploadEntity mEntity;
    private TARGET mTarget;
    private UTaskWrapper mWrapper;

    UNormalConfigHandler(TARGET target, long taskId) {
        this.mTarget = target;
        this.initTarget(taskId);
    }

    private void initTarget(long taskId) {
        this.mWrapper = TaskWrapperManager.getInstance().getNormalTaskWrapper(UTaskWrapper.class, taskId);
        if (this.mTarget instanceof AbsNormalTarget) {
            if (taskId < 0L) {
                this.mWrapper.setErrorEvent(new ErrorEvent(taskId, "\u4efb\u52a1id\u4e3a\u7a7a"));
            } else if (((UploadEntity)this.mWrapper.getEntity()).getId() < 0L) {
                this.mWrapper.setErrorEvent(new ErrorEvent(taskId, "\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728"));
            }
        }
        this.mEntity = (UploadEntity)this.mWrapper.getEntity();
        ((AbsTarget)this.mTarget).setTaskWrapper((AbsTaskWrapper)this.mWrapper);
        this.getTaskWrapper().setTempUrl(this.mEntity.getUrl());
    }

    void setFilePath(String filePath) {
        File file = new File(filePath);
        this.mEntity.setFilePath(filePath);
        this.mEntity.setFileName(file.getName());
        this.mEntity.setFileSize(file.length());
    }

    @Override
    public AbsEntity getEntity() {
        return this.mEntity;
    }

    @Override
    public boolean taskExists() {
        return DbEntity.checkDataExist(UploadEntity.class, (String[])new String[]{"key=?", this.mEntity.getFilePath()});
    }

    @Override
    public boolean isRunning() {
        UploadTask task = (UploadTask)UTaskQueue.getInstance().getTask(this.mEntity.getKey());
        return task != null && task.isRunning();
    }

    void setTempUrl(String tempUrl) {
        this.getTaskWrapper().setTempUrl(tempUrl);
    }

    private UTaskWrapper getTaskWrapper() {
        return this.mWrapper;
    }
}

