/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.upload;

import android.text.TextUtils;
import com.arialyy.annotations.TaskEnum;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.AriaManager;
import com.arialyy.aria.core.command.CancelAllCmd;
import com.arialyy.aria.core.command.CmdHelper;
import com.arialyy.aria.core.command.NormalCmdFactory;
import com.arialyy.aria.core.common.ProxyHelper;
import com.arialyy.aria.core.event.EventMsgUtil;
import com.arialyy.aria.core.inf.AbsReceiver;
import com.arialyy.aria.core.inf.ReceiverType;
import com.arialyy.aria.core.queue.UTaskQueue;
import com.arialyy.aria.core.scheduler.TaskInternalListenerInterface;
import com.arialyy.aria.core.scheduler.TaskSchedulers;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.core.upload.UploadTaskListener;
import com.arialyy.aria.core.upload.target.FtpBuilderTarget;
import com.arialyy.aria.core.upload.target.FtpNormalTarget;
import com.arialyy.aria.core.upload.target.HttpBuilderTarget;
import com.arialyy.aria.core.upload.target.HttpNormalTarget;
import com.arialyy.aria.core.upload.target.UTargetFactory;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import com.arialyy.aria.util.ComponentUtil;
import java.util.List;
import java.util.Set;

public class UploadReceiver
extends AbsReceiver {
    public UploadReceiver(Object obj) {
        super(obj);
    }

    @Deprecated
    public UploadReceiver setMaxSpeed(int maxSpeed) {
        AriaConfig.getInstance().getUConfig().setMaxSpeed(maxSpeed);
        return this;
    }

    public HttpBuilderTarget load(String filePath) {
        ComponentUtil.getInstance().checkComponentExist(1);
        CheckUtil.checkUploadPathIsEmpty((String)filePath);
        return UTargetFactory.getInstance().generateBuilderTarget(HttpBuilderTarget.class, filePath);
    }

    public HttpNormalTarget load(long taskId) {
        ComponentUtil.getInstance().checkComponentExist(1);
        return UTargetFactory.getInstance().generateNormalTarget(HttpNormalTarget.class, taskId);
    }

    public FtpBuilderTarget loadFtp(String filePath) {
        ComponentUtil.getInstance().checkComponentExist(2);
        CheckUtil.checkUploadPathIsEmpty((String)filePath);
        return UTargetFactory.getInstance().generateBuilderTarget(FtpBuilderTarget.class, filePath);
    }

    public FtpNormalTarget loadFtp(long taskId) {
        ComponentUtil.getInstance().checkComponentExist(2);
        return UTargetFactory.getInstance().generateNormalTarget(FtpNormalTarget.class, taskId);
    }

    public UploadEntity getUploadEntity(long taskId) {
        if (taskId == -1L) {
            return null;
        }
        return (UploadEntity)DbEntity.findFirst(UploadEntity.class, (String[])new String[]{"rowid=?", String.valueOf(taskId)});
    }

    public UploadEntity getFirstUploadEntity(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        return (UploadEntity)DbEntity.findFirst(UploadEntity.class, (String[])new String[]{"filePath=?", filePath});
    }

    public List<UploadEntity> getUploadEntity(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        return DbEntity.findDatas(UploadEntity.class, (String[])new String[]{"filePath=?", filePath});
    }

    public boolean taskExists(String filePath) {
        return DbEntity.checkDataExist(UTaskWrapper.class, (String[])new String[]{"key=?", filePath});
    }

    public List<UploadEntity> getTaskList() {
        return DbEntity.findAllData(UploadEntity.class);
    }

    public List<UploadEntity> getTaskList(int page, int num) {
        CheckUtil.checkPageParams((int)page, (int)num);
        return DbEntity.findDatas(UploadEntity.class, (int)page, (int)num, (String[])new String[]{"isGroupChild=? and downloadPath!=''", "false"});
    }

    public List<UploadEntity> getAllNotCompleteTask() {
        return DbEntity.findDatas(UploadEntity.class, (String[])new String[]{"isGroupChild=? and isComplete=?", "false", "false"});
    }

    public List<UploadEntity> getAllNotCompleteTask(int page, int num) {
        CheckUtil.checkPageParams((int)page, (int)num);
        return DbEntity.findDatas(UploadEntity.class, (int)page, (int)num, (String[])new String[]{"isGroupChild=? and downloadPath!='' and isComplete=?", "false", "false"});
    }

    public List<UploadEntity> getAllCompleteTask() {
        return DbEntity.findDatas(UploadEntity.class, (String[])new String[]{"isGroupChild=? and isComplete=?", "false", "true"});
    }

    public List<UploadEntity> getAllCompleteTask(int page, int num) {
        CheckUtil.checkPageParams((int)page, (int)num);
        return DbEntity.findDatas(UploadEntity.class, (String[])new String[]{"isGroupChild=? and downloadPath!='' and isComplete=?", "false", "true"});
    }

    public void stopAllTask() {
        EventMsgUtil.getDefault().post((Object)NormalCmdFactory.getInstance().createCmd((AbsTaskWrapper)new UTaskWrapper(null), 183, 2));
    }

    public List<UploadEntity> getURunningTask() {
        return UTaskQueue.getInstance().getRunningTask(UploadEntity.class);
    }

    public void removeAllTask(boolean removeFile) {
        AriaManager am = AriaManager.getInstance();
        CancelAllCmd cancelCmd = (CancelAllCmd)CmdHelper.createNormalCmd(new UTaskWrapper(null), 185, 2);
        cancelCmd.removeFile = removeFile;
        EventMsgUtil.getDefault().post((Object)cancelCmd);
        Set<String> keys = am.getReceiver().keySet();
        for (String key : keys) {
            am.getReceiver().remove(key);
        }
    }

    @Override
    public void register() {
        if (this.obj == null) {
            ALog.e((String)this.TAG, (String)String.format("\u3010%s\u3011\u89c2\u5bdf\u8005\u4e3a\u7a7a", this.getTargetName()));
            return;
        }
        if (this.obj instanceof TaskInternalListenerInterface) {
            if (this.obj instanceof UploadTaskListener) {
                TaskSchedulers.getInstance().register(this.obj, TaskEnum.UPLOAD);
            }
            return;
        }
        Set<Integer> set = ProxyHelper.getInstance().checkProxyType(this.obj.getClass());
        if (set != null && !set.isEmpty()) {
            for (Integer type : set) {
                if (type != ProxyHelper.PROXY_TYPE_UPLOAD) continue;
                TaskSchedulers.getInstance().register(this.obj, TaskEnum.UPLOAD);
            }
        } else {
            ALog.e((String)this.TAG, (String)"\u6ca1\u6709Aria\u7684\u6ce8\u89e3\u65b9\u6cd5\uff0c\u8be6\u60c5\u89c1\uff1ahttps://aria.laoyuyu.me/aria_doc/other/annotaion_invalid.html");
        }
    }

    @Override
    public void unRegister() {
        if (this.isNeedRmListener()) {
            this.unRegisterListener();
        }
        AriaManager.getInstance().removeReceiver(this.obj);
    }

    @Override
    public ReceiverType getType() {
        return ReceiverType.UPLOAD;
    }

    @Override
    protected void unRegisterListener() {
        if (this.obj == null) {
            ALog.e((String)this.TAG, (String)String.format("\u3010%s\u3011\u89c2\u5bdf\u8005\u4e3a\u7a7a", this.getTargetName()));
            return;
        }
        Set<Integer> set = ProxyHelper.getInstance().mProxyCache.get(this.obj.getClass().getName());
        if (set != null) {
            for (Integer integer : set) {
                if (integer != ProxyHelper.PROXY_TYPE_UPLOAD) continue;
                TaskSchedulers.getInstance().unRegister(this.obj);
            }
        }
    }
}

