/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.upload;

import android.text.TextUtils;
import com.arialyy.aria.core.inf.ICheckEntityUtil;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import java.io.File;

public class CheckUEntityUtil
implements ICheckEntityUtil {
    private final String TAG = "CheckUEntityUtil";
    private UTaskWrapper mWrapper;
    private UploadEntity mEntity;
    private int action;

    public static CheckUEntityUtil newInstance(UTaskWrapper wrapper, int action) {
        return new CheckUEntityUtil(wrapper, action);
    }

    private CheckUEntityUtil(UTaskWrapper wrapper, int action) {
        this.action = action;
        this.mWrapper = wrapper;
        this.mEntity = (UploadEntity)this.mWrapper.getEntity();
    }

    @Override
    public boolean checkEntity() {
        boolean b;
        if (this.mWrapper.getErrorEvent() != null) {
            ALog.e((String)"CheckUEntityUtil", (String)String.format("\u4efb\u52a1\u64cd\u4f5c\u5931\u8d25\uff0c%s", this.mWrapper.getErrorEvent().errorMsg));
            return false;
        }
        boolean bl = b = this.checkUrl() && this.checkFilePath();
        if (b) {
            this.mEntity.save();
        }
        return b;
    }

    private boolean checkFilePath() {
        String filePath = this.mEntity.getFilePath();
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            ALog.e((String)"CheckUEntityUtil", (String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u4e3anull");
            return false;
        }
        if (!filePath.startsWith("/")) {
            ALog.e((String)"CheckUEntityUtil", (String)("\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u8def\u5f84\u3010" + filePath + "\u3011\u4e0d\u5408\u6cd5"));
            return false;
        }
        if (this.mWrapper.isNewTask() && !CheckUtil.checkUPathConflicts((boolean)this.mWrapper.isIgnoreFilePathOccupy(), (String)filePath, (int)this.mWrapper.getRequestType())) {
            return false;
        }
        File file = new File(this.mEntity.getFilePath());
        if (!file.exists()) {
            ALog.e((String)"CheckUEntityUtil", (String)("\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u3010" + filePath + "\u3011\u4e0d\u5b58\u5728"));
            return false;
        }
        if (file.isDirectory()) {
            ALog.e((String)"CheckUEntityUtil", (String)("\u4e0a\u4f20\u5931\u8d25\uff0c\u6587\u4ef6\u3010" + filePath + "\u3011\u4e0d\u80fd\u662f\u6587\u4ef6\u5939"));
            return false;
        }
        return true;
    }

    private boolean checkUrl() {
        String url = this.mWrapper.getTempUrl();
        if (TextUtils.isEmpty((CharSequence)url)) {
            ALog.e((String)"CheckUEntityUtil", (String)"\u4e0a\u4f20\u5931\u8d25\uff0curl\u4e3anull");
            return false;
        }
        if (!CheckUtil.checkUrl((String)url)) {
            ALog.e((String)"CheckUEntityUtil", (String)("\u4e0a\u4f20\u5931\u8d25\uff0curl\u3010" + url + "\u3011\u9519\u8bef"));
            return false;
        }
        int index = url.indexOf("://");
        if (index == -1) {
            ALog.e((String)"CheckUEntityUtil", (String)("\u4e0a\u4f20\u5931\u8d25\uff0curl\u3010" + url + "\u3011\u4e0d\u5408\u6cd5"));
            return false;
        }
        this.mEntity.setUrl(url);
        return true;
    }
}

