/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.scheduler;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Message;
import android.os.Parcelable;
import com.arialyy.annotations.TaskEnum;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.group.GroupSendParams;
import com.arialyy.aria.core.listener.ISchedulers;
import com.arialyy.aria.core.manager.TaskWrapperManager;
import com.arialyy.aria.core.queue.DGroupTaskQueue;
import com.arialyy.aria.core.queue.DTaskQueue;
import com.arialyy.aria.core.queue.ITaskQueue;
import com.arialyy.aria.core.queue.UTaskQueue;
import com.arialyy.aria.core.scheduler.FailureTaskHandler;
import com.arialyy.aria.core.scheduler.ISchedulerListener;
import com.arialyy.aria.core.scheduler.M3U8PeerTaskListener;
import com.arialyy.aria.core.scheduler.NormalTaskListenerInterface;
import com.arialyy.aria.core.scheduler.SubTaskListener;
import com.arialyy.aria.core.scheduler.TaskInternalListenerInterface;
import com.arialyy.aria.core.task.DownloadGroupTask;
import com.arialyy.aria.core.task.DownloadTask;
import com.arialyy.aria.core.task.ITask;
import com.arialyy.aria.core.task.UploadTask;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.NetUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TaskSchedulers<TASK extends ITask>
implements ISchedulers {
    private final String TAG = CommonUtil.getClassName(this.getClass());
    private static volatile TaskSchedulers INSTANCE;
    private static FailureTaskHandler mFailureTaskHandler;
    private Map<String, Map<TaskEnum, Object>> mObservers = new ConcurrentHashMap<String, Map<TaskEnum, Object>>();
    private AriaConfig mAriaConfig = AriaConfig.getInstance();

    private TaskSchedulers() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskSchedulers getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TaskSchedulers> clazz = TaskSchedulers.class;
        synchronized (TaskSchedulers.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new TaskSchedulers();
            mFailureTaskHandler = FailureTaskHandler.init(INSTANCE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    ITaskQueue getQueue(int taskType) {
        if (taskType == 1) {
            return DTaskQueue.getInstance();
        }
        if (taskType == 3) {
            return DGroupTaskQueue.getInstance();
        }
        if (taskType == 2) {
            return UTaskQueue.getInstance();
        }
        throw new NullPointerException("\u4efb\u52a1\u7c7b\u578b\u9519\u8bef\uff0ctype = " + taskType);
    }

    public void register(Object obj, TaskEnum taskEnum) {
        String targetName = obj.getClass().getName();
        Map<TaskEnum, Object> listeners = this.mObservers.get(this.getKey(obj));
        if (listeners == null) {
            listeners = new ConcurrentHashMap<TaskEnum, Object>();
            this.mObservers.put(this.getKey(obj), listeners);
        }
        if (!this.hasProxyListener(listeners, taskEnum)) {
            if (obj instanceof TaskInternalListenerInterface) {
                listeners.put(taskEnum, obj);
                return;
            }
            String proxyClassName = targetName + taskEnum.proxySuffix;
            ISchedulerListener listener = this.createListener(proxyClassName);
            if (listener != null) {
                listener.setListener(obj);
                listeners.put(taskEnum, listener);
            } else {
                ALog.e((String)this.TAG, (String)("\u6ce8\u518c\u9519\u8bef\uff0c\u6ca1\u6709\u3010" + proxyClassName + "\u3011\u89c2\u5bdf\u8005"));
            }
        }
    }

    private boolean hasProxyListener(Map<TaskEnum, Object> listeners, TaskEnum taskEnum) {
        return !listeners.isEmpty() && listeners.get(taskEnum) != null;
    }

    public void unRegister(Object obj) {
        if (!this.mObservers.containsKey(this.getKey(obj))) {
            return;
        }
        Iterator<Map.Entry<String, Map<TaskEnum, Object>>> iter = this.mObservers.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Map<TaskEnum, Object>> entry = iter.next();
            if (!entry.getKey().equals(this.getKey(obj))) continue;
            iter.remove();
        }
    }

    private String getKey(Object obj) {
        return obj.getClass().getName() + obj.hashCode();
    }

    private ISchedulerListener createListener(String proxyClassName) {
        ISchedulerListener listener = null;
        try {
            Class<?> clazz = Class.forName(proxyClassName);
            listener = (ISchedulerListener)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            ALog.e((String)this.TAG, (String)e.getMessage());
        }
        catch (InstantiationException e) {
            ALog.e((String)this.TAG, (String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            ALog.e((String)this.TAG, (String)e.getMessage());
        }
        return listener;
    }

    public boolean handleMessage(Message msg) {
        if (msg.what == 11) {
            this.handlePreFailTask(msg.arg1);
            return true;
        }
        if (msg.arg1 == 209) {
            return this.handleSubEvent(msg);
        }
        if (msg.arg1 == 210) {
            return this.handlePeerEvent(msg);
        }
        ITask task = (ITask)msg.obj;
        if (task == null) {
            ALog.e((String)this.TAG, (String)"\u8bf7\u4f20\u5165\u4e0b\u8f7d\u4efb\u52a1");
            return true;
        }
        this.handleNormalEvent(task, msg.what);
        return true;
    }

    private boolean handlePeerEvent(Message msg) {
        boolean canSend;
        Bundle data = msg.getData();
        if (this.mObservers.size() > 0) {
            Set<String> keys = this.mObservers.keySet();
            for (String key : keys) {
                M3U8PeerTaskListener listener;
                Map<TaskEnum, Object> listeners = this.mObservers.get(key);
                if (listeners == null || listeners.isEmpty() || (listener = (M3U8PeerTaskListener)listeners.get(TaskEnum.M3U8_PEER)) == null) continue;
                switch (msg.what) {
                    case 177: {
                        listener.onPeerStart(data.getString("DATA_M3U8_URL"), data.getString("DATA_M3U8_PEER_PATH"), data.getInt("DATA_M3U8_PEER_INDEX"));
                        break;
                    }
                    case 178: {
                        listener.onPeerComplete(data.getString("DATA_M3U8_URL"), data.getString("DATA_M3U8_PEER_PATH"), data.getInt("DATA_M3U8_PEER_INDEX"));
                        break;
                    }
                    case 179: {
                        listener.onPeerFail(data.getString("DATA_M3U8_URL"), data.getString("DATA_M3U8_PEER_PATH"), data.getInt("DATA_M3U8_PEER_INDEX"));
                    }
                }
            }
        }
        if (canSend = this.mAriaConfig.getAConfig().isUseBroadcast()) {
            Intent intent = new Intent("ARIA_TASK_INFO_ACTION");
            intent.setPackage(this.mAriaConfig.getAPP().getPackageName());
            intent.putExtras(data);
            this.mAriaConfig.getAPP().sendBroadcast(intent);
        }
        return true;
    }

    private boolean handleSubEvent(Message msg) {
        boolean canSend;
        GroupSendParams params = (GroupSendParams)msg.obj;
        if (this.mObservers.size() > 0) {
            Set<String> keys = this.mObservers.keySet();
            for (String key : keys) {
                SubTaskListener listener;
                Map<TaskEnum, Object> listeners = this.mObservers.get(key);
                if (listeners == null || listeners.isEmpty() || (listener = (SubTaskListener)listeners.get(TaskEnum.DOWNLOAD_GROUP_SUB)) == null) continue;
                switch (msg.what) {
                    case 161: {
                        listener.onSubTaskPre(params.groupTask, params.entity);
                        break;
                    }
                    case 162: {
                        listener.onSubTaskStart(params.groupTask, params.entity);
                        break;
                    }
                    case 163: {
                        listener.onSubTaskStop(params.groupTask, params.entity);
                        break;
                    }
                    case 165: {
                        listener.onSubTaskFail(params.groupTask, params.entity, (Exception)params.groupTask.getExpand("ERROR_INFO_KEY"));
                        break;
                    }
                    case 166: {
                        listener.onSubTaskRunning(params.groupTask, params.entity);
                        break;
                    }
                    case 164: {
                        listener.onSubTaskCancel(params.groupTask, params.entity);
                        break;
                    }
                    case 167: {
                        listener.onSubTaskComplete(params.groupTask, params.entity);
                    }
                }
            }
        }
        if (canSend = this.mAriaConfig.getAConfig().isUseBroadcast()) {
            this.mAriaConfig.getAPP().sendBroadcast(this.createData(msg.what, 4, (AbsEntity)params.entity));
        }
        return true;
    }

    private void handleNormalEvent(TASK task, int what) {
        ITaskQueue queue = this.getQueue(task.getTaskType());
        switch (what) {
            case 3: {
                if (task.getState() == 3) break;
                queue.removeTaskFormQueue(task.getKey());
                if (queue.getCurrentExePoolNum() < queue.getMaxTaskNum()) {
                    ALog.d((String)this.TAG, (String)String.format("\u505c\u6b62\u4efb\u52a1\u3010%s\u3011\u6210\u529f\uff0c\u5c1d\u8bd5\u5f00\u59cb\u4e0b\u4e00\u4efb\u52a1", task.getTaskName()));
                    this.startNextTask(queue, task.getSchedulerType());
                    break;
                }
                ALog.d((String)this.TAG, (String)String.format("\u505c\u6b62\u4efb\u52a1\u3010%s\u3011\u6210\u529f", task.getTaskName()));
                break;
            }
            case 5: {
                queue.removeTaskFormQueue(task.getKey());
                if (queue.getCurrentExePoolNum() < queue.getMaxTaskNum()) {
                    ALog.d((String)this.TAG, (String)String.format("\u5220\u9664\u4efb\u52a1\u3010%s\u3011\u6210\u529f\uff0c\u5c1d\u8bd5\u5f00\u59cb\u4e0b\u4e00\u4efb\u52a1", task.getTaskName()));
                    this.startNextTask(queue, task.getSchedulerType());
                    break;
                }
                ALog.d((String)this.TAG, (String)String.format("\u5220\u9664\u4efb\u52a1\u3010%s\u3011\u6210\u529f", task.getTaskName()));
                break;
            }
            case 6: {
                queue.removeTaskFormQueue(task.getKey());
                ALog.d((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u5904\u7406\u5b8c\u6210", task.getTaskName()));
                this.startNextTask(queue, task.getSchedulerType());
                break;
            }
            case 4: {
                this.handleFailTask(queue, task);
            }
        }
        if (what == 4 || what == 11) {
            return;
        }
        if (what == 5 || what == 6) {
            TaskWrapperManager.getInstance().removeTaskWrapper(task.getTaskWrapper());
        } else if (what != 7) {
            TaskWrapperManager.getInstance().putTaskWrapper(task.getTaskWrapper());
        }
        this.normalTaskCallback(what, task);
    }

    private void handlePreFailTask(int taskType) {
        this.startNextTask(this.getQueue(taskType), 1);
        boolean canSend = this.mAriaConfig.getAConfig().isUseBroadcast();
        if (canSend) {
            Intent intent = new Intent("ARIA_TASK_INFO_ACTION");
            intent.setPackage(this.mAriaConfig.getAPP().getPackageName());
            Bundle b = new Bundle();
            b.putInt("ARIA_TASK_TYPE", taskType);
            b.putInt("ARIA_TASK_STATE", 4);
            this.mAriaConfig.getAPP().sendBroadcast(intent);
        }
        if (this.mObservers.size() > 0) {
            Set<String> keys = this.mObservers.keySet();
            for (String key : keys) {
                Map<TaskEnum, Object> listeners = this.mObservers.get(key);
                if (listeners == null || listeners.isEmpty()) continue;
                NormalTaskListenerInterface listener = null;
                if (this.mObservers.get(key) != null) {
                    if (taskType == 1) {
                        listener = (NormalTaskListenerInterface)listeners.get(TaskEnum.DOWNLOAD);
                    } else if (taskType == 3) {
                        listener = (NormalTaskListenerInterface)listeners.get(TaskEnum.DOWNLOAD_GROUP);
                    } else if (taskType == 3) {
                        listener = (NormalTaskListenerInterface)listeners.get(TaskEnum.UPLOAD);
                    }
                }
                if (listener == null) continue;
                this.normalTaskCallback(11, null, listener);
            }
        }
    }

    private void normalTaskCallback(int state, TASK task) {
        this.sendNormalBroadcast(state, task);
        if (this.mObservers.size() > 0) {
            Set<String> keys = this.mObservers.keySet();
            for (String key : keys) {
                Map<TaskEnum, Object> listeners = this.mObservers.get(key);
                if (listeners == null || listeners.isEmpty()) continue;
                NormalTaskListenerInterface listener = null;
                if (this.mObservers.get(key) != null) {
                    if (task instanceof DownloadTask) {
                        listener = (NormalTaskListenerInterface)listeners.get(TaskEnum.DOWNLOAD);
                    } else if (task instanceof DownloadGroupTask) {
                        listener = (NormalTaskListenerInterface)listeners.get(TaskEnum.DOWNLOAD_GROUP);
                    } else if (task instanceof UploadTask) {
                        listener = (NormalTaskListenerInterface)listeners.get(TaskEnum.UPLOAD);
                    }
                }
                if (listener == null) continue;
                this.normalTaskCallback(state, task, listener);
            }
        }
    }

    private void normalTaskCallback(int state, TASK task, NormalTaskListenerInterface<TASK> listener) {
        if (listener != null) {
            if (task == null && state != 11) {
                ALog.e((String)this.TAG, (String)"TASK \u4e3anull\uff0c\u56de\u8c03\u5931\u8d25");
                return;
            }
            switch (state) {
                case 10: {
                    listener.onWait(task);
                    break;
                }
                case 0: {
                    listener.onPre(task);
                    break;
                }
                case 1: {
                    listener.onTaskPre(task);
                    break;
                }
                case 7: {
                    listener.onTaskRunning(task);
                    break;
                }
                case 2: {
                    listener.onTaskStart(task);
                    break;
                }
                case 3: {
                    listener.onTaskStop(task);
                    break;
                }
                case 8: {
                    listener.onTaskResume(task);
                    break;
                }
                case 5: {
                    listener.onTaskCancel(task);
                    break;
                }
                case 6: {
                    listener.onTaskComplete(task);
                    break;
                }
                case 4: {
                    listener.onTaskFail(task.getTaskType() == 6 ? null : (Object)task, (Exception)task.getExpand("ERROR_INFO_KEY"));
                    break;
                }
                case 11: {
                    listener.onTaskFail(null, null);
                    break;
                }
                case 9: {
                    listener.onNoSupportBreakPoint(task);
                }
            }
        }
    }

    private void sendNormalBroadcast(int state, TASK task) {
        boolean canSend = this.mAriaConfig.getAConfig().isUseBroadcast();
        if (!canSend) {
            return;
        }
        int type = task.getTaskType();
        if (type == 1 || type == 3) {
            this.mAriaConfig.getAPP().sendBroadcast(this.createData(state, type, task.getTaskWrapper().getEntity()));
        } else if (type == 2) {
            this.mAriaConfig.getAPP().sendBroadcast(this.createData(state, type, task.getTaskWrapper().getEntity()));
        } else {
            ALog.w((String)this.TAG, (String)"\u53d1\u9001\u5e7f\u64ad\u5931\u8d25\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u4efb\u52a1");
        }
    }

    private Intent createData(int taskState, int taskType, AbsEntity entity) {
        Intent intent = new Intent("ARIA_TASK_INFO_ACTION");
        intent.setPackage(this.mAriaConfig.getAPP().getPackageName());
        Bundle b = new Bundle();
        b.putInt("ARIA_TASK_TYPE", taskType);
        b.putInt("ARIA_TASK_STATE", taskState);
        b.putLong("ARIA_TASK_SPEED", entity.getSpeed());
        b.putInt("ARIA_TASK_PERCENT", entity.getPercent());
        b.putParcelable("ARIA_TASK_ENTITY", (Parcelable)entity);
        intent.putExtras(b);
        return intent;
    }

    private void handleFailTask(ITaskQueue queue, TASK task) {
        if (!task.isNeedRetry() || task.isStop() || task.isCancel()) {
            queue.removeTaskFormQueue(task.getKey());
            this.startNextTask(queue, task.getSchedulerType());
            this.normalTaskCallback(4, task);
            return;
        }
        int num = task.getTaskWrapper().getConfig().getReTryNum();
        boolean isNotNetRetry = this.mAriaConfig.getAConfig().isNotNetRetry();
        if (!NetUtils.isConnected((Context)this.mAriaConfig.getAPP()) && !isNotNetRetry || task.getTaskWrapper().getEntity().getFailNum() > num) {
            queue.removeTaskFormQueue(task.getKey());
            this.startNextTask(queue, task.getSchedulerType());
            TaskWrapperManager.getInstance().removeTaskWrapper(task.getTaskWrapper());
            this.normalTaskCallback(4, task);
            return;
        }
        mFailureTaskHandler.offer(task);
    }

    void startNextTask(ITaskQueue queue, int schedulerType) {
        if (schedulerType == 2) {
            return;
        }
        Object newTask = queue.getNextTask();
        if (newTask == null) {
            if (queue.getCurrentExePoolNum() == 0) {
                ALog.i((String)this.TAG, (String)"\u6ca1\u6709\u7b49\u5f85\u4e2d\u7684\u4efb\u52a1");
            }
            return;
        }
        if (newTask.getState() == 3) {
            queue.startTask(newTask);
        }
    }
}

