/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.scheduler;

import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.manager.TaskWrapperManager;
import com.arialyy.aria.core.queue.ITaskQueue;
import com.arialyy.aria.core.scheduler.TaskSchedulers;
import com.arialyy.aria.core.task.ITask;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class FailureTaskHandler<TASK extends ITask> {
    private final String TAG = CommonUtil.getClassName(this.getClass());
    private static volatile FailureTaskHandler INSTANCE;
    private final int MAX_EXE_NUM = 5;
    private ArrayBlockingQueue<TASK> mQueue = new ArrayBlockingQueue(100);
    private List<TASK> mExeQueue = new ArrayList<TASK>(5);
    private List<Integer> mHashList = new ArrayList<Integer>();
    private TaskSchedulers mSchedulers;
    private final ReentrantLock LOCK = new ReentrantLock();
    private Condition mCondition = this.LOCK.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static FailureTaskHandler init(TaskSchedulers schedulers) {
        if (INSTANCE != null) return INSTANCE;
        Class<FailureTaskHandler> clazz = FailureTaskHandler.class;
        synchronized (FailureTaskHandler.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new FailureTaskHandler(schedulers);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private FailureTaskHandler(TaskSchedulers schedulers) {
        this.mSchedulers = schedulers;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            ITask task = (ITask)FailureTaskHandler.this.mQueue.take();
                            if (FailureTaskHandler.this.mExeQueue.size() >= 5) {
                                try {
                                    FailureTaskHandler.this.LOCK.lock();
                                    FailureTaskHandler.this.mCondition.await();
                                }
                                finally {
                                    FailureTaskHandler.this.LOCK.unlock();
                                }
                                continue;
                            }
                            FailureTaskHandler.this.retryTask(task);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    private void retryTask(TASK task) {
        ITaskQueue queue = this.mSchedulers.getQueue(task.getTaskType());
        if (task.isNeedRetry()) {
            long interval = task.getTaskWrapper().getConfig().getReTryInterval();
            int num = task.getTaskWrapper().getConfig().getReTryNum();
            AriaConfig.getInstance().getAriaHandler().postDelayed(new Runnable((ITask)task, num, queue){
                final /* synthetic */ ITask val$task;
                final /* synthetic */ int val$num;
                final /* synthetic */ ITaskQueue val$queue;
                {
                    this.val$task = iTask;
                    this.val$num = n;
                    this.val$queue = iTaskQueue;
                }

                @Override
                public void run() {
                    AbsEntity entity = this.val$task.getTaskWrapper().getEntity();
                    if (entity.getFailNum() <= this.val$num) {
                        ALog.d((String)FailureTaskHandler.this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u5f00\u59cb\u91cd\u8bd5", this.val$task.getTaskName()));
                        this.val$queue.reTryStart(this.val$task);
                    } else {
                        this.val$queue.removeTaskFormQueue(this.val$task.getKey());
                        FailureTaskHandler.this.mSchedulers.startNextTask(this.val$queue, this.val$task.getSchedulerType());
                        TaskWrapperManager.getInstance().removeTaskWrapper(this.val$task.getTaskWrapper());
                    }
                    FailureTaskHandler.this.next(this.val$task);
                }
            }, interval);
        } else {
            queue.removeTaskFormQueue(task.getKey());
            this.mSchedulers.startNextTask(queue, task.getSchedulerType());
            TaskWrapperManager.getInstance().removeTaskWrapper(task.getTaskWrapper());
            this.next(task);
        }
    }

    private void next(TASK task) {
        this.mExeQueue.remove(task);
        int index = this.mHashList.indexOf(task.hashCode());
        if (index != -1) {
            this.mHashList.remove(index);
        }
        if (this.LOCK.isLocked()) {
            try {
                this.LOCK.lock();
                this.mCondition.signalAll();
            }
            finally {
                this.LOCK.unlock();
            }
        }
    }

    void offer(TASK task) {
        int hashCode = task.hashCode();
        if (this.mHashList.contains(hashCode)) {
            return;
        }
        this.mQueue.offer(task);
        this.mHashList.add(hashCode);
    }
}

