/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.queue.pool;

import android.text.TextUtils;
import com.arialyy.aria.core.queue.pool.IPool;
import com.arialyy.aria.core.task.AbsTask;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;

public class BaseExecutePool<TASK extends AbsTask>
implements IPool<TASK> {
    private final String TAG = CommonUtil.getClassName((Object)this);
    private static final Object LOCK = new Object();
    Deque<TASK> mExecuteQueue;
    int mSize = this.getMaxSize();

    BaseExecutePool() {
        this.mExecuteQueue = new LinkedBlockingDeque<TASK>(this.mSize);
    }

    protected int getMaxSize() {
        return 2;
    }

    public List<TASK> getAllTask() {
        return new ArrayList<TASK>(this.mExecuteQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putTask(TASK task) {
        Object object = LOCK;
        synchronized (object) {
            if (task == null) {
                ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
                return false;
            }
            if (this.mExecuteQueue.contains(task)) {
                ALog.e((String)this.TAG, (String)("\u4efb\u52a1\u3010" + task.getTaskName() + "\u3011\u8fdb\u5165\u6267\u884c\u961f\u5217\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5df2\u7ecf\u5728\u6267\u884c\u961f\u5217\u4e2d"));
                return false;
            }
            if (this.mExecuteQueue.size() >= this.mSize) {
                if (this.pollFirstTask()) {
                    return this.putNewTask(task);
                }
            } else {
                return this.putNewTask(task);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxNum(int maxNum) {
        Object object = LOCK;
        synchronized (object) {
            AbsTask task;
            LinkedBlockingDeque<TASK> temp = new LinkedBlockingDeque<TASK>(maxNum);
            while ((task = (AbsTask)this.mExecuteQueue.poll()) != null) {
                temp.offer(task);
            }
            this.mExecuteQueue = temp;
            this.mSize = maxNum;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean putNewTask(TASK newTask) {
        Object object = LOCK;
        synchronized (object) {
            boolean s = this.mExecuteQueue.offer(newTask);
            ALog.d((String)this.TAG, (String)("\u4efb\u52a1\u3010" + newTask.getTaskName() + "\u3011\u8fdb\u5165\u6267\u884c\u961f\u5217" + (s ? "\u6210\u529f" : "\u5931\u8d25")));
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pollFirstTask() {
        Object object = LOCK;
        synchronized (object) {
            AbsTask oldTask = (AbsTask)this.mExecuteQueue.pollFirst();
            if (oldTask == null) {
                ALog.w((String)this.TAG, (String)"\u79fb\u9664\u4efb\u52a1\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4efb\u52a1\u4e3anull");
                return false;
            }
            oldTask.stop();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TASK pollTask() {
        Object object = LOCK;
        synchronized (object) {
            return (TASK)((AbsTask)this.mExecuteQueue.poll());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TASK getTask(String key) {
        Object object = LOCK;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)key)) {
                ALog.e((String)this.TAG, (String)"key\u4e3anull");
                return null;
            }
            for (AbsTask task : this.mExecuteQueue) {
                if (!task.getKey().equals(key)) continue;
                return (TASK)task;
            }
            return null;
        }
    }

    @Override
    public boolean taskExits(String key) {
        return this.getTask(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTask(TASK task) {
        Object object = LOCK;
        synchronized (object) {
            if (task == null) {
                ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            return this.removeTask(task.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTask(String key) {
        Object object = LOCK;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)key)) {
                ALog.e((String)this.TAG, (String)"key \u4e3anull");
                return false;
            }
            return this.mExecuteQueue.remove(this.getTask(key));
        }
    }

    @Override
    public int size() {
        return this.mExecuteQueue.size();
    }
}

