/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.queue.pool;

import android.text.TextUtils;
import com.arialyy.aria.core.queue.pool.IPool;
import com.arialyy.aria.core.task.AbsTask;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;

public class BaseCachePool<TASK extends AbsTask>
implements IPool<TASK> {
    private final String TAG = CommonUtil.getClassName((Object)this);
    private static final int MAX_NUM = Integer.MAX_VALUE;
    private static final Object LOCK = new Object();
    private Deque<TASK> mCacheQueue = new LinkedBlockingDeque<TASK>(Integer.MAX_VALUE);

    BaseCachePool() {
    }

    public List<TASK> getAllTask() {
        return new ArrayList<TASK>(this.mCacheQueue);
    }

    public void clear() {
        this.mCacheQueue.clear();
    }

    public boolean putTaskToFirst(TASK task) {
        return this.mCacheQueue.offerFirst(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putTask(TASK task) {
        Object object = LOCK;
        synchronized (object) {
            if (task == null) {
                ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
                return false;
            }
            if (this.mCacheQueue.contains(task)) {
                ALog.w((String)this.TAG, (String)("\u4efb\u52a1\u3010" + task.getTaskName() + "\u3011\u8fdb\u5165\u7f13\u5b58\u961f\u5217\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5df2\u7ecf\u5728\u7f13\u5b58\u961f\u5217\u4e2d"));
                return false;
            }
            boolean s = this.mCacheQueue.offer(task);
            ALog.d((String)this.TAG, (String)("\u4efb\u52a1\u3010" + task.getTaskName() + "\u3011\u8fdb\u5165\u7f13\u5b58\u961f\u5217" + (s ? "\u6210\u529f" : "\u5931\u8d25")));
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TASK pollTask() {
        Object object = LOCK;
        synchronized (object) {
            return (TASK)((AbsTask)this.mCacheQueue.pollFirst());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TASK getTask(String key) {
        Object object = LOCK;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)key)) {
                ALog.e((String)this.TAG, (String)"key \u4e3anull");
                return null;
            }
            for (AbsTask task : this.mCacheQueue) {
                if (!task.getKey().equals(key)) continue;
                return (TASK)task;
            }
        }
        return null;
    }

    @Override
    public boolean taskExits(String key) {
        return this.getTask(key) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTask(TASK task) {
        Object object = LOCK;
        synchronized (object) {
            if (task == null) {
                ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a");
                return false;
            }
            return this.mCacheQueue.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTask(String key) {
        Object object = LOCK;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)key)) {
                ALog.e((String)this.TAG, (String)"\u8bf7\u4f20\u5165\u6709\u6548\u7684\u4e0b\u8f7d\u94fe\u63a5");
                return false;
            }
            return this.mCacheQueue.remove(this.getTask(key));
        }
    }

    @Override
    public int size() {
        return this.mCacheQueue.size();
    }
}

