/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.queue;

import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.event.DMaxNumEvent;
import com.arialyy.aria.core.event.Event;
import com.arialyy.aria.core.event.EventMsgUtil;
import com.arialyy.aria.core.queue.AbsTaskQueue;
import com.arialyy.aria.core.queue.TaskFactory;
import com.arialyy.aria.core.scheduler.TaskSchedulers;
import com.arialyy.aria.core.task.DownloadTask;
import com.arialyy.aria.util.ALog;
import java.util.LinkedHashSet;
import java.util.List;

public class DTaskQueue
extends AbsTaskQueue<DownloadTask, DTaskWrapper> {
    private static final String TAG = "DownloadTaskQueue";
    private static volatile DTaskQueue INSTANCE = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DTaskQueue getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DTaskQueue> clazz = DTaskQueue.class;
        synchronized (DTaskQueue.class) {
            INSTANCE = new DTaskQueue();
            EventMsgUtil.getDefault().register((Object)INSTANCE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private DTaskQueue() {
    }

    @Override
    int getQueueType() {
        return 1;
    }

    @Event
    public void maxTaskNum(DMaxNumEvent event) {
        this.setMaxTaskNum(event.maxNum);
    }

    @Override
    public int getOldMaxNum() {
        return AriaConfig.getInstance().getDConfig().oldMaxTaskNum;
    }

    public void setTaskHighestPriority(DownloadTask task) {
        task.setHighestPriority(true);
        List exeTasks = this.mExecutePool.getAllTask();
        if (exeTasks != null && !exeTasks.isEmpty()) {
            for (DownloadTask temp : exeTasks) {
                if (temp == null || !temp.isRunning() || !temp.isHighestPriorityTask() || temp.getKey().equals(task.getKey())) continue;
                ALog.e((String)TAG, (String)"\u8bbe\u7f6e\u6700\u9ad8\u4f18\u5148\u7ea7\u4efb\u52a1\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\u3010\u4efb\u52a1\u4e2d\u5df2\u7ecf\u6709\u6700\u9ad8\u4f18\u5148\u7ea7\u4efb\u52a1\uff0c\u8bf7\u7b49\u5f85\u4e0a\u4e00\u4e2a\u6700\u9ad8\u4f18\u5148\u7ea7\u4efb\u52a1\u5b8c\u6210\uff0c\u6216\u624b\u52a8\u6682\u505c\u8be5\u4efb\u52a1\u3011");
                task.setHighestPriority(false);
                return;
            }
            int maxSize = AriaConfig.getInstance().getDConfig().getMaxTaskNum();
            int currentSize = this.mExecutePool.size();
            if (currentSize == 0 || currentSize < maxSize) {
                this.startTask(task);
            } else {
                LinkedHashSet<DownloadTask> tempTasks = new LinkedHashSet<DownloadTask>();
                for (int i = 0; i < maxSize; ++i) {
                    DownloadTask oldTsk = (DownloadTask)this.mExecutePool.pollTask();
                    if (oldTsk == null || !oldTsk.isRunning()) continue;
                    if (i == maxSize - 1) {
                        oldTsk.stop(3);
                        this.mCachePool.putTaskToFirst(oldTsk);
                        break;
                    }
                    tempTasks.add(oldTsk);
                }
                this.startTask(task);
                for (DownloadTask temp : tempTasks) {
                    this.mExecutePool.putTask(temp);
                }
            }
        }
    }

    @Override
    public DownloadTask createTask(DTaskWrapper wrapper) {
        super.createTask(wrapper);
        DownloadTask task = null;
        if (!this.mCachePool.taskExits(wrapper.getKey()) && !this.mExecutePool.taskExits(wrapper.getKey())) {
            task = (DownloadTask)TaskFactory.getInstance().createTask(wrapper, TaskSchedulers.getInstance());
            this.addTask(task);
        } else {
            ALog.w((String)TAG, (String)"\u4efb\u52a1\u5df2\u5b58\u5728");
        }
        return task;
    }

    @Override
    public void stopTask(DownloadTask task) {
        task.setHighestPriority(false);
        super.stopTask(task);
    }

    @Override
    public int getMaxTaskNum() {
        return AriaConfig.getInstance().getDConfig().getMaxTaskNum();
    }
}

