/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.queue;

import android.text.TextUtils;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.manager.TaskWrapperManager;
import com.arialyy.aria.core.manager.ThreadTaskManager;
import com.arialyy.aria.core.queue.ITaskQueue;
import com.arialyy.aria.core.queue.pool.BaseCachePool;
import com.arialyy.aria.core.queue.pool.BaseExecutePool;
import com.arialyy.aria.core.queue.pool.DGLoadSharePool;
import com.arialyy.aria.core.queue.pool.DLoadSharePool;
import com.arialyy.aria.core.queue.pool.UploadSharePool;
import com.arialyy.aria.core.task.AbsTask;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class AbsTaskQueue<TASK extends AbsTask, TASK_WRAPPER extends AbsTaskWrapper>
implements ITaskQueue<TASK, TASK_WRAPPER> {
    final int TYPE_D_QUEUE = 1;
    final int TYPE_DG_QUEUE = 2;
    final int TYPE_U_QUEUE = 3;
    private final String TAG = CommonUtil.getClassName((Object)this);
    BaseCachePool<TASK> mCachePool;
    BaseExecutePool<TASK> mExecutePool;

    AbsTaskQueue() {
        switch (this.getQueueType()) {
            case 1: {
                this.mCachePool = DLoadSharePool.getInstance().cachePool;
                this.mExecutePool = DLoadSharePool.getInstance().executePool;
                break;
            }
            case 2: {
                this.mCachePool = DGLoadSharePool.getInstance().cachePool;
                this.mExecutePool = DGLoadSharePool.getInstance().executePool;
                break;
            }
            case 3: {
                this.mCachePool = UploadSharePool.getInstance().cachePool;
                this.mExecutePool = UploadSharePool.getInstance().executePool;
            }
        }
    }

    abstract int getQueueType();

    public <T extends AbsEntity> List<T> getRunningTask(Class<T> type) {
        List<TASK> exeTask = this.mExecutePool.getAllTask();
        List<TASK> cacheTask = this.mCachePool.getAllTask();
        ArrayList<AbsEntity> entities = new ArrayList<AbsEntity>();
        if (exeTask != null && !exeTask.isEmpty()) {
            for (AbsTask task : exeTask) {
                entities.add(task.getTaskWrapper().getEntity());
            }
        }
        if (cacheTask != null && !cacheTask.isEmpty()) {
            for (AbsTask task : cacheTask) {
                entities.add(task.getTaskWrapper().getEntity());
            }
        }
        return entities.isEmpty() ? null : entities;
    }

    @Override
    public boolean taskIsRunning(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            ALog.w((String)this.TAG, (String)"key\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u786e\u8ba4\u4efb\u52a1\u662f\u5426\u6267\u884c");
            return false;
        }
        TASK task = this.mExecutePool.getTask(key);
        if (task == null && ThreadTaskManager.getInstance().taskIsRunning(key)) {
            ThreadTaskManager.getInstance().removeTaskThread(key);
        }
        return task != null && task.isRunning() && this.taskExists(key);
    }

    @Override
    public void resumeTask(TASK task) {
        if (task == null) {
            ALog.w((String)this.TAG, (String)"resume task fail, task is null");
            return;
        }
        if (this.mExecutePool.taskExits(task.getKey())) {
            ALog.w((String)this.TAG, (String)String.format("task\u3010%s\u3011running", task.getKey()));
            return;
        }
        if (this.mExecutePool.size() >= this.getMaxTaskNum()) {
            task.getTaskWrapper().getEntity().setState(3);
            this.mCachePool.putTaskToFirst(task);
            this.stopTask(this.mExecutePool.pollTask());
        } else {
            this.startTask(task);
        }
    }

    @Override
    public void stopAllTask() {
        for (AbsTask task : this.mExecutePool.getAllTask()) {
            if (task == null) continue;
            int state = task.getState();
            if (!task.isRunning() && (state == 1 || state == 7)) continue;
            task.stop(2);
        }
        for (AbsTask task : this.mCachePool.getAllTask()) {
            if (task == null) continue;
            task.stop(2);
        }
        ThreadTaskManager.getInstance().removeAllThreadTask();
        this.mCachePool.clear();
    }

    public abstract int getOldMaxNum();

    public BaseExecutePool getExecutePool() {
        return this.mExecutePool;
    }

    public BaseCachePool getCachePool() {
        return this.mCachePool;
    }

    @Override
    public int getCurrentCachePoolNum() {
        return this.mCachePool.size();
    }

    @Override
    public int getCurrentExePoolNum() {
        return this.mExecutePool.size();
    }

    @Override
    public void setMaxTaskNum(int maxNum) {
        int i;
        int oldMaxSize = this.getOldMaxNum();
        int diff = maxNum - oldMaxSize;
        if (oldMaxSize == maxNum) {
            ALog.w((String)this.TAG, (String)"\u8bbe\u7f6e\u7684\u4e0b\u8f7d\u4efb\u52a1\u6570\u548c\u914d\u7f6e\u6587\u4ef6\u7684\u4e0b\u8f7d\u4efb\u52a1\u6570\u4e00\u76f4\uff0c\u8df3\u8fc7");
            return;
        }
        if (diff <= -1 && this.mExecutePool.size() >= oldMaxSize) {
            int len = Math.abs(diff);
            for (i = 0; i < len; ++i) {
                TASK eTask = this.mExecutePool.pollTask();
                if (eTask == null) continue;
                this.stopTask(eTask);
            }
        }
        this.mExecutePool.setMaxNum(maxNum);
        if (diff >= 1) {
            for (i = 0; i < diff; ++i) {
                TASK nextTask = this.getNextTask();
                if (nextTask == null || nextTask.getState() != 3) continue;
                this.startTask(nextTask);
            }
        }
    }

    @Override
    public TASK createTask(TASK_WRAPPER wrapper) {
        TaskWrapperManager.getInstance().putTaskWrapper((AbsTaskWrapper)wrapper);
        return null;
    }

    @Override
    public boolean taskExists(String key) {
        return this.getTask(key) != null;
    }

    @Override
    public TASK getTask(String key) {
        TASK task = this.mExecutePool.getTask(key);
        if (task == null) {
            task = this.mCachePool.getTask(key);
        }
        ALog.i((String)this.TAG, (String)("\u83b7\u53d6\u4efb\u52a1\uff0ckey\uff1a" + key));
        return task;
    }

    void addTask(TASK task) {
        if (task == null) {
            ALog.w((String)this.TAG, (String)"add task fail, task is null");
            return;
        }
        if (!this.mCachePool.taskExits(task.getKey())) {
            this.mCachePool.putTask(task);
        }
    }

    @Override
    public void startTask(TASK task) {
        this.startTask(task, 1);
    }

    @Override
    public void startTask(TASK task, int action) {
        if (task == null) {
            ALog.w((String)this.TAG, (String)"create fail, task is null");
        }
        if (this.mExecutePool.taskExits(task.getKey())) {
            ALog.w((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u6267\u884c\u4e2d", task.getKey()));
            return;
        }
        ALog.i((String)this.TAG, (String)("\u6dfb\u52a0\u4efb\u52a1\uff0ckey\uff1a" + task.getKey()));
        this.mCachePool.removeTask(task);
        this.mExecutePool.putTask(task);
        task.getTaskWrapper().getEntity().setFailNum(0);
        task.start(action);
    }

    @Override
    public void stopTask(TASK task) {
        if (task == null) {
            ALog.w((String)this.TAG, (String)"stop fail, task is null");
            return;
        }
        int state = task.getState();
        boolean canStop = false;
        switch (state) {
            case 3: {
                this.mCachePool.removeTask(task);
                canStop = true;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                this.mExecutePool.removeTask(task);
                canStop = true;
                break;
            }
            case -1: 
            case 0: 
            case 2: {
                ALog.w((String)this.TAG, (String)String.format("\u505c\u6b62\u4efb\u52a1\u3010%s\u3011\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5df2\u505c\u6b62", task.getTaskName()));
                if (!this.taskIsRunning(task.getKey())) break;
                this.removeTaskFormQueue(task.getKey());
                if (!ThreadTaskManager.getInstance().taskIsRunning(task.getKey())) break;
                ThreadTaskManager.getInstance().removeTaskThread(task.getKey());
                break;
            }
            case 7: {
                ALog.w((String)this.TAG, (String)String.format("\u505c\u6b62\u4efb\u52a1\u3010%s\u3011\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4efb\u52a1\u5df2\u5220\u9664", task.getTaskName()));
                break;
            }
            case 1: {
                ALog.w((String)this.TAG, (String)String.format("\u505c\u6b62\u4efb\u52a1\u3010%s\u3011\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5df2\u5b8c\u6210", task.getTaskName()));
            }
        }
        if (canStop) {
            task.stop();
        }
    }

    @Override
    public void removeTaskFormQueue(String key) {
        TASK task = this.mExecutePool.getTask(key);
        if (task != null) {
            ALog.d((String)this.TAG, (String)String.format("\u4ece\u6267\u884c\u6c60\u5220\u9664\u4efb\u52a1\u3010%s\u3011%s", task.getTaskName(), this.mExecutePool.removeTask(task) ? "\u6210\u529f" : "\u5931\u8d25"));
        }
        if ((task = this.mCachePool.getTask(key)) != null) {
            ALog.d((String)this.TAG, (String)String.format("\u4ece\u7f13\u5b58\u6c60\u5220\u9664\u4efb\u52a1\u3010%s\u3011%s", task.getTaskName(), this.mCachePool.removeTask(task) ? "\u6210\u529f" : "\u5931\u8d25"));
        }
    }

    @Override
    public void reTryStart(TASK task) {
        if (task == null) {
            ALog.e((String)this.TAG, (String)"reTry fail, task is null");
            return;
        }
        int state = task.getState();
        switch (state) {
            case 4: 
            case 5: 
            case 6: {
                ALog.w((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u6ca1\u6709\u505c\u6b62\uff0c\u5373\u5c06\u91cd\u65b0\u4e0b\u8f7d", task.getTaskName()));
                task.stop(2);
                task.start();
                break;
            }
            case -1: 
            case 0: 
            case 2: 
            case 3: {
                task.start();
                break;
            }
            case 7: {
                ALog.e((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u91cd\u8bd5\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u4efb\u52a1\u5df2\u5220\u9664", task.getTaskName()));
                break;
            }
            case 1: {
                ALog.e((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u91cd\u8bd5\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5df2\u5b8c\u6210", task.getTaskName()));
            }
        }
    }

    @Override
    public void cancelTask(TASK task) {
        this.cancelTask(task, 1);
    }

    @Override
    public void cancelTask(TASK task, int action) {
        task.cancel(action);
    }

    @Override
    public TASK getNextTask() {
        return this.mCachePool.pollTask();
    }
}

