/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.manager;

import android.util.LruCache;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.manager.DGTaskWrapperFactory;
import com.arialyy.aria.core.manager.DTaskWrapperFactory;
import com.arialyy.aria.core.manager.IGroupWrapperFactory;
import com.arialyy.aria.core.manager.INormalTEFactory;
import com.arialyy.aria.core.manager.UTaskWrapperFactory;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TaskWrapperManager {
    private static final String TAG = "TaskWrapperManager";
    private static volatile TaskWrapperManager INSTANCE = null;
    private LruCache<String, AbsTaskWrapper> cache = new LruCache(1024);
    private Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskWrapperManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TaskWrapperManager> clazz = TaskWrapperManager.class;
        synchronized (TaskWrapperManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new TaskWrapperManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private TaskWrapperManager() {
    }

    private IGroupWrapperFactory chooseGroupFactory(Class clazz) {
        if (clazz == DGTaskWrapper.class) {
            return DGTaskWrapperFactory.getInstance();
        }
        return null;
    }

    private INormalTEFactory chooseNormalFactory(Class clazz) {
        if (clazz == DTaskWrapper.class) {
            return DTaskWrapperFactory.getInstance();
        }
        if (clazz == UTaskWrapper.class) {
            return UTaskWrapperFactory.getInstance();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TW extends AbsTaskWrapper> TW getNormalTaskWrapper(Class<TW> clazz, long taskId) {
        Lock lock = this.lock;
        lock.lock();
        try {
            Object wrapper = (AbsTaskWrapper)this.cache.get((Object)this.convertKey(clazz, taskId));
            if (wrapper == null || wrapper.getClass() != clazz) {
                INormalTEFactory factory = this.chooseNormalFactory(clazz);
                if (factory == null) {
                    ALog.e((String)TAG, (String)"\u4efb\u52a1\u5b9e\u4f53\u521b\u5efa\u5931\u8d25");
                    TW TW = null;
                    return TW;
                }
                wrapper = factory.create(taskId);
                this.putTaskWrapper((AbsTaskWrapper)wrapper);
            }
            AbsTaskWrapper absTaskWrapper = wrapper;
            return (TW)absTaskWrapper;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TW extends AbsTaskWrapper> TW getGroupWrapper(Class<TW> clazz, long taskId) {
        Lock lock = this.lock;
        lock.lock();
        try {
            Object tWrapper = (AbsTaskWrapper)this.cache.get((Object)this.convertKey(clazz, taskId));
            if (tWrapper == null || tWrapper.getClass() != clazz) {
                IGroupWrapperFactory factory = this.chooseGroupFactory(clazz);
                if (factory == null) {
                    ALog.e((String)TAG, (String)"\u4efb\u52a1\u5b9e\u4f53\u521b\u5efa\u5931\u8d25");
                    TW TW = null;
                    return TW;
                }
                tWrapper = factory.getGroupWrapper(taskId);
                this.putTaskWrapper((AbsTaskWrapper)tWrapper);
            }
            AbsTaskWrapper absTaskWrapper = tWrapper;
            return (TW)absTaskWrapper;
        }
        finally {
            lock.unlock();
        }
    }

    public void putTaskWrapper(AbsTaskWrapper wrapper) {
        if (wrapper == null) {
            ALog.e((String)TAG, (String)"\u4efb\u52a1\u5b9e\u4f53\u6dfb\u52a0\u5931\u8d25");
            return;
        }
        if (wrapper.getEntity() == null || wrapper.getEntity().getId() == -1L) {
            return;
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            this.cache.put((Object)this.convertKey(wrapper.getClass(), wrapper.getEntity().getId()), (Object)wrapper);
        }
        finally {
            lock.unlock();
        }
    }

    public void removeTaskWrapper(AbsTaskWrapper wrapper) {
        Lock lock = this.lock;
        lock.lock();
        try {
            this.cache.remove((Object)this.convertKey(wrapper.getClass(), wrapper.getEntity().getId()));
        }
        finally {
            lock.unlock();
        }
    }

    private String convertKey(Class clazz, long taskId) {
        return CommonUtil.keyToHashKey((String)(clazz.getName() + taskId));
    }
}

