/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.manager;

import com.arialyy.aria.core.TaskRecord;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.manager.INormalTEFactory;
import java.io.File;

class DTaskWrapperFactory
implements INormalTEFactory<DownloadEntity, DTaskWrapper> {
    private final String TAG = "DTaskWrapperFactory";
    private static volatile DTaskWrapperFactory INSTANCE = null;

    private DTaskWrapperFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DTaskWrapperFactory getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DTaskWrapperFactory> clazz = DTaskWrapperFactory.class;
        synchronized (DTaskWrapperFactory.class) {
            INSTANCE = new DTaskWrapperFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public DTaskWrapper create(long taskId) {
        DTaskWrapper wrapper = taskId == -1L ? new DTaskWrapper(new DownloadEntity()) : new DTaskWrapper(this.getEntity(taskId));
        wrapper.setRequestType(((DownloadEntity)wrapper.getEntity()).getTaskType());
        return wrapper;
    }

    private DownloadEntity getEntity(long taskId) {
        DownloadEntity entity = (DownloadEntity)DownloadEntity.findFirst(DownloadEntity.class, (String[])new String[]{"rowid=? and isGroupChild='false'", String.valueOf(taskId)});
        if (entity == null) {
            entity = new DownloadEntity();
            return entity;
        }
        File file = new File(entity.getFilePath());
        if (!entity.isComplete()) {
            TaskRecord record = (TaskRecord)TaskRecord.findFirst(TaskRecord.class, (String[])new String[]{"filePath=?", entity.getFilePath()});
            if (record == null) {
                this.resetEntity(entity);
            } else if (record.isBlock) {
                int count = 0;
                int len = record.threadNum;
                for (int i = 0; i < len; ++i) {
                    File temp = new File(String.format("%s.%s.part", record.filePath, i));
                    if (temp.exists()) continue;
                    ++count;
                }
                if (count == record.threadNum) {
                    this.resetEntity(entity);
                }
            } else if (!file.exists() && record.taskType != 7) {
                this.resetEntity(entity);
            }
        }
        return entity;
    }

    private void resetEntity(DownloadEntity entity) {
        entity.setPercent(0);
        entity.setCompleteTime(0L);
        entity.setComplete(false);
        entity.setCurrentProgress(0L);
        entity.setState(3);
    }
}

