/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.manager;

import com.arialyy.aria.core.download.DGEntityWrapper;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.manager.IGroupWrapperFactory;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.DbDataHelper;
import java.util.List;

class DGTaskWrapperFactory
implements IGroupWrapperFactory<DownloadGroupEntity, DGTaskWrapper> {
    private final String TAG = CommonUtil.getClassName((Object)this);
    private static volatile DGTaskWrapperFactory INSTANCE = null;

    private DGTaskWrapperFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DGTaskWrapperFactory getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DGTaskWrapperFactory> clazz = DGTaskWrapperFactory.class;
        synchronized (DGTaskWrapperFactory.class) {
            INSTANCE = new DGTaskWrapperFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public DGTaskWrapper getGroupWrapper(long taskId) {
        DGTaskWrapper wrapper;
        if (taskId == -1L) {
            wrapper = new DGTaskWrapper(new DownloadGroupEntity());
        } else {
            DownloadGroupEntity entity = this.getOrCreateHttpDGEntity(taskId);
            wrapper = new DGTaskWrapper(entity);
            if (entity.getSubEntities() != null && !entity.getSubEntities().isEmpty()) {
                wrapper.setSubTaskWrapper(DbDataHelper.createDGSubTaskWrapper((DownloadGroupEntity)entity));
            }
        }
        wrapper.setRequestType(((DownloadGroupEntity)wrapper.getEntity()).getTaskType());
        return wrapper;
    }

    private DownloadGroupEntity getOrCreateHttpDGEntity(long taskId) {
        DownloadGroupEntity groupEntity;
        List wrapper = DbEntity.findRelationData(DGEntityWrapper.class, (String[])new String[]{"DownloadGroupEntity.rowid=?", String.valueOf(taskId)});
        if (wrapper != null && !wrapper.isEmpty()) {
            groupEntity = ((DGEntityWrapper)wrapper.get((int)0)).groupEntity;
            if (groupEntity == null) {
                groupEntity = new DownloadGroupEntity();
            }
        } else {
            groupEntity = new DownloadGroupEntity();
        }
        return groupEntity;
    }
}

