/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.inf;

import android.app.Dialog;
import android.util.Log;
import android.widget.PopupWindow;
import com.arialyy.aria.core.WidgetLiftManager;
import com.arialyy.aria.core.inf.IReceiver;
import com.arialyy.aria.util.CommonUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbsReceiver
implements IReceiver {
    protected String TAG = this.getClass().getSimpleName();
    public Object obj;
    private String targetName;
    private boolean needRmReceiver = false;
    private boolean isFragment = false;
    public boolean isLocalOrAnonymousClass = false;

    public AbsReceiver(Object obj) {
        this.obj = obj;
        this.initParams();
    }

    private void initParams() {
        try {
            this.targetName = CommonUtil.getTargetName((Object)this.obj);
            Class<?> clazz = this.obj.getClass();
            if (CommonUtil.isLocalOrAnonymousClass(clazz)) {
                this.isLocalOrAnonymousClass = true;
                String parentName = CommonUtil.getTargetName((Object)this.obj);
                Class<?> parentClazz = Class.forName(parentName);
                this.handleFragmentOrDialogParam(parentClazz, true);
                return;
            }
            this.handleFragmentOrDialogParam(clazz, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleFragmentOrDialogParam(Class clazz, boolean isLocalOrAnonymousClass) {
        WidgetLiftManager widgetLiftManager = new WidgetLiftManager();
        if (this.obj instanceof Dialog) {
            this.needRmReceiver = widgetLiftManager.handleDialogLift((Dialog)this.obj);
            return;
        }
        if (this.obj instanceof PopupWindow) {
            this.needRmReceiver = widgetLiftManager.handlePopupWindowLift((PopupWindow)this.obj);
            return;
        }
        if (CommonUtil.isFragment((Class)clazz)) {
            this.isFragment = true;
        }
        if (CommonUtil.isDialogFragment((Class)clazz)) {
            this.isFragment = true;
            if (isLocalOrAnonymousClass) {
                Log.e((String)this.TAG, (String)String.format("%s \u662f\u533f\u540d\u5185\u90e8\u7c7b\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230dialog\u5bf9\u8c61\uff0c\u4e3a\u4e86\u9632\u6b62\u5185\u5b58\u6cc4\u6f0f\uff0c\u8bf7\u5728dismiss\u65b9\u6cd5\u4e2d\u8c03\u7528Aria.download(this).unRegister();\u6765\u6ce8\u9500\u4e8b\u4ef6", this.obj.getClass().getName()));
                return;
            }
            this.needRmReceiver = widgetLiftManager.handleDialogFragmentLift(this.getDialog(this.obj));
        }
    }

    private Dialog getDialog(Object obj) {
        try {
            Method method = obj.getClass().getMethod("getDialog", new Class[0]);
            return (Dialog)method.invoke(obj, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected boolean isNeedRmListener() {
        return this.needRmReceiver;
    }

    @Override
    public boolean isFragment() {
        return this.isFragment;
    }

    public static String getKey(IReceiver receiver) {
        return String.format("%s_%s_%s", new Object[]{receiver.getTargetName(), receiver.getType(), receiver.hashCode()});
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public String getKey() {
        return AbsReceiver.getKey(this);
    }

    private void removeObj() {
        this.obj = null;
    }

    @Override
    public void destroy() {
        this.unRegisterListener();
        this.removeObj();
    }

    protected abstract void unRegisterListener();
}

