/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.download.target;

import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.target.AbsGroupConfigHandler;
import com.arialyy.aria.core.inf.AbsTarget;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.DbDataHelper;
import java.util.ArrayList;
import java.util.List;

class HttpGroupConfigHandler<TARGET extends AbsTarget>
extends AbsGroupConfigHandler<TARGET> {
    private List<String> mUrls = new ArrayList<String>();
    private List<String> mSubNameTemp = new ArrayList<String>();

    HttpGroupConfigHandler(TARGET target, long taskId) {
        super(target, taskId);
        this.mUrls.addAll(this.getEntity().getUrls());
    }

    void setGroupUrl(List<String> urls) {
        if (urls == null || urls.isEmpty()) {
            throw new NullPointerException("\u7ec4\u5408\u4efb\u52a1\u5b50\u4efb\u52a1\u4e0b\u8f7d\u5730\u5740\u5217\u8868\u4e3a\u7a7a");
        }
        this.mUrls.clear();
        this.mUrls.addAll(urls);
        String groupHash = CommonUtil.getMd5Code(urls);
        this.getEntity().setGroupHash(groupHash);
        List subEntities = DbDataHelper.createHttpSubTask((String)groupHash, this.mUrls);
        ArrayList<DTaskWrapper> wrappers = new ArrayList<DTaskWrapper>();
        for (DownloadEntity subEntity : subEntities) {
            subEntity.setTaskType(1);
            wrappers.add(new DTaskWrapper(subEntity));
        }
        this.getEntity().setUrls(urls);
        this.getEntity().setSubEntities(subEntities);
        this.getTaskWrapper().setSubTaskWrapper(wrappers);
    }

    TARGET setSubFileName(List<String> subTaskFileName) {
        if (subTaskFileName == null || subTaskFileName.isEmpty()) {
            ALog.w((String)this.TAG, (String)"\u4fee\u6539\u5b50\u4efb\u52a1\u7684\u6587\u4ef6\u540d\u5931\u8d25\uff1a\u5217\u8868\u4e3anull");
            return this.getTarget();
        }
        if (subTaskFileName.size() != this.getTaskWrapper().getSubTaskWrapper().size()) {
            ALog.w((String)this.TAG, (String)"\u4fee\u6539\u5b50\u4efb\u52a1\u7684\u6587\u4ef6\u540d\u5931\u8d25\uff1a\u5b50\u4efb\u52a1\u6587\u4ef6\u540d\u5217\u8868\u6570\u91cf\u548c\u5b50\u4efb\u52a1\u7684\u6570\u91cf\u4e0d\u5339\u914d");
            return this.getTarget();
        }
        this.mSubNameTemp.clear();
        this.mSubNameTemp.addAll(subTaskFileName);
        this.getTaskWrapper().setSubNameTemp(this.mSubNameTemp);
        return this.getTarget();
    }

    TARGET updateUrls(List<String> urls) {
        if (urls == null || urls.isEmpty()) {
            throw new NullPointerException("\u4e0b\u8f7d\u5730\u5740\u5217\u8868\u4e3a\u7a7a");
        }
        if (urls.size() != this.mUrls.size()) {
            throw new IllegalArgumentException("\u65b0\u4e0b\u8f7d\u5730\u5740\u6570\u91cf\u548c\u65e7\u4e0b\u8f7d\u5730\u5740\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        this.mUrls.clear();
        this.mUrls.addAll(urls);
        String newHash = CommonUtil.getMd5Code(urls);
        this.getEntity().setUrls(this.mUrls);
        this.getEntity().setGroupHash(newHash);
        this.getEntity().update();
        if (this.getEntity().getSubEntities() != null && !this.getEntity().getSubEntities().isEmpty()) {
            int i = 0;
            for (DownloadEntity de : this.getEntity().getSubEntities()) {
                de.setUrl(this.mUrls.get(i));
                de.setGroupHash(newHash);
                ++i;
            }
            DbEntity.updateManyData((List)this.getEntity().getSubEntities());
        }
        return this.getTarget();
    }
}

