/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.download.target;

import com.arialyy.aria.core.common.AbsBuilderTarget;
import com.arialyy.aria.core.common.BaseOption;
import com.arialyy.aria.core.common.FtpOption;
import com.arialyy.aria.core.common.SFtpOption;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.target.DNormalConfigHandler;
import com.arialyy.aria.util.CommonUtil;

public class FtpBuilderTarget
extends AbsBuilderTarget<FtpBuilderTarget> {
    private DNormalConfigHandler<FtpBuilderTarget> mConfigHandler = new DNormalConfigHandler<FtpBuilderTarget>(this, -1L);

    FtpBuilderTarget(String url) {
        this.mConfigHandler.setUrl(url);
        this.getTaskWrapper().setRequestType(3);
        this.getEntity().setTaskType(3);
        this.getTaskWrapper().setNewTask(true);
    }

    public FtpBuilderTarget option(FtpOption option) {
        if (option == null) {
            throw new NullPointerException("ftp \u4efb\u52a1\u914d\u7f6e\u4e3a\u7a7a");
        }
        option.setUrlEntity(CommonUtil.getFtpUrlInfo((String)this.mConfigHandler.getUrl()));
        this.getTaskWrapper().getOptionParams().setParams((BaseOption)option);
        return this;
    }

    public FtpBuilderTarget sftpOption(SFtpOption option) {
        if (option == null) {
            throw new NullPointerException("ftp \u4efb\u52a1\u914d\u7f6e\u4e3a\u7a7a");
        }
        option.setUrlEntity(CommonUtil.getFtpUrlInfo((String)this.mConfigHandler.getUrl()));
        this.getTaskWrapper().getOptionParams().setParams((BaseOption)option);
        this.getEntity().setTaskType(12);
        this.getTaskWrapper().setRequestType(12);
        return this;
    }

    public FtpBuilderTarget setFilePath(String filePath) {
        int lastIndex = this.mConfigHandler.getUrl().lastIndexOf("/");
        this.getEntity().setFileName(this.mConfigHandler.getUrl().substring(lastIndex + 1));
        this.mConfigHandler.setTempFilePath(filePath);
        return this;
    }

    @Deprecated
    public FtpBuilderTarget setFilePath(String filePath, boolean forceDownload) {
        this.mConfigHandler.setTempFilePath(filePath);
        this.mConfigHandler.setForceDownload(forceDownload);
        return this;
    }

    public DownloadEntity getEntity() {
        return (DownloadEntity)super.getEntity();
    }
}

