/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.download.target;

import android.text.TextUtils;
import com.arialyy.aria.core.common.AbsNormalTarget;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.event.ErrorEvent;
import com.arialyy.aria.core.inf.AbsTarget;
import com.arialyy.aria.core.inf.IConfigHandler;
import com.arialyy.aria.core.manager.TaskWrapperManager;
import com.arialyy.aria.core.queue.DTaskQueue;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;

class DNormalConfigHandler<TARGET extends AbsTarget>
implements IConfigHandler {
    private final String TAG = "DNormalDelegate";
    private DownloadEntity mEntity;
    private TARGET mTarget;
    private DTaskWrapper mWrapper;

    DNormalConfigHandler(TARGET target, long taskId) {
        this.mTarget = target;
        this.initTarget(taskId);
    }

    private void initTarget(long taskId) {
        this.mWrapper = TaskWrapperManager.getInstance().getNormalTaskWrapper(DTaskWrapper.class, taskId);
        if (this.mTarget instanceof AbsNormalTarget) {
            if (taskId < 0L) {
                this.mWrapper.setErrorEvent(new ErrorEvent(taskId, "\u4efb\u52a1id\u4e3a\u7a7a"));
            } else if (((DownloadEntity)this.mWrapper.getEntity()).getId() < 0L) {
                this.mWrapper.setErrorEvent(new ErrorEvent(taskId, "\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728"));
            }
        }
        this.mEntity = (DownloadEntity)this.mWrapper.getEntity();
        ((AbsTarget)this.mTarget).setTaskWrapper((AbsTaskWrapper)this.mWrapper);
        if (this.mEntity != null) {
            this.getWrapper().setTempFilePath(this.mEntity.getFilePath());
        }
    }

    TARGET updateUrl(String newUrl) {
        if (TextUtils.isEmpty((CharSequence)newUrl)) {
            ALog.e((String)"DNormalDelegate", (String)"url\u66f4\u65b0\u5931\u8d25\uff0cnewUrl\u4e3anull");
            return this.mTarget;
        }
        if (this.mEntity.getUrl().equals(newUrl)) {
            ALog.e((String)"DNormalDelegate", (String)"url\u66f4\u65b0\u5931\u8d25\uff0c\u65b0\u7684\u4e0b\u8f7durl\u548c\u65e7\u7684url\u4e00\u81f4");
            return this.mTarget;
        }
        this.getWrapper().setRefreshInfo(true);
        this.getWrapper().setTempUrl(newUrl);
        ALog.d((String)"DNormalDelegate", (String)"\u66f4\u65b0url\u6210\u529f");
        return this.mTarget;
    }

    public DownloadEntity getEntity() {
        return (DownloadEntity)((AbsTarget)this.mTarget).getEntity();
    }

    @Override
    public boolean taskExists() {
        return DbEntity.checkDataExist(DownloadEntity.class, (String[])new String[]{"rowid=?", String.valueOf(this.mEntity.getId())});
    }

    @Override
    public boolean isRunning() {
        return DTaskQueue.getInstance().taskIsRunning(this.mEntity.getKey());
    }

    void setForceDownload(boolean forceDownload) {
        this.getWrapper().setIgnoreFilePathOccupy(forceDownload);
    }

    void setUrl(String url) {
        this.mEntity.setUrl(url);
        this.mWrapper.setTempUrl(url);
    }

    String getUrl() {
        return this.mEntity.getUrl();
    }

    void setTempFilePath(String tempFilePath) {
        this.getWrapper().setTempFilePath(tempFilePath);
    }

    private DTaskWrapper getWrapper() {
        return this.mWrapper;
    }
}

