/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.download.target;

import android.text.TextUtils;
import com.arialyy.aria.core.common.AbsNormalTarget;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.event.ErrorEvent;
import com.arialyy.aria.core.inf.AbsTarget;
import com.arialyy.aria.core.inf.IConfigHandler;
import com.arialyy.aria.core.manager.SubTaskManager;
import com.arialyy.aria.core.manager.TaskWrapperManager;
import com.arialyy.aria.core.queue.DGroupTaskQueue;
import com.arialyy.aria.core.task.DownloadGroupTask;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.CommonUtil;

abstract class AbsGroupConfigHandler<TARGET extends AbsTarget>
implements IConfigHandler {
    protected String TAG = CommonUtil.getClassName(this.getClass());
    private TARGET mTarget;
    private DGTaskWrapper mWrapper;
    private SubTaskManager mSubTaskManager;

    AbsGroupConfigHandler(TARGET target, long taskId) {
        this.mTarget = target;
        this.mWrapper = TaskWrapperManager.getInstance().getGroupWrapper(DGTaskWrapper.class, taskId);
        if (this.mTarget instanceof AbsNormalTarget) {
            if (taskId < 0L) {
                this.mWrapper.setErrorEvent(new ErrorEvent(taskId, "\u4efb\u52a1id\u4e3a\u7a7a"));
            } else if (((DownloadGroupEntity)this.mWrapper.getEntity()).getId() < 0L) {
                this.mWrapper.setErrorEvent(new ErrorEvent(taskId, "\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728"));
            }
        }
        ((AbsTarget)this.mTarget).setTaskWrapper((AbsTaskWrapper)this.mWrapper);
        if (this.getEntity() != null) {
            this.getTaskWrapper().setDirPathTemp(this.getEntity().getDirPath());
        }
    }

    SubTaskManager getSubTaskManager() {
        if (this.mSubTaskManager == null) {
            this.mSubTaskManager = new SubTaskManager(this.getTaskWrapper());
        }
        return this.mSubTaskManager;
    }

    void setGroupAlias(String alias) {
        if (TextUtils.isEmpty((CharSequence)alias)) {
            return;
        }
        this.getEntity().setAlias(alias);
    }

    @Override
    public boolean isRunning() {
        DownloadGroupTask task = (DownloadGroupTask)DGroupTaskQueue.getInstance().getTask(this.getEntity().getKey());
        return task != null && task.isRunning();
    }

    TARGET setDirPath(String dirPath) {
        this.mWrapper.setDirPathTemp(dirPath);
        return this.mTarget;
    }

    public DownloadGroupEntity getEntity() {
        return (DownloadGroupEntity)this.mWrapper.getEntity();
    }

    @Override
    public boolean taskExists() {
        return this.getEntity().getId() != -1L && DbEntity.checkDataExist(DownloadGroupEntity.class, (String[])new String[]{"rowid=?", String.valueOf(this.getEntity().getId())});
    }

    DGTaskWrapper getTaskWrapper() {
        return this.mWrapper;
    }

    TARGET getTarget() {
        return this.mTarget;
    }
}

