/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.download;

import com.arialyy.annotations.TaskEnum;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.AriaManager;
import com.arialyy.aria.core.command.CancelAllCmd;
import com.arialyy.aria.core.command.CmdHelper;
import com.arialyy.aria.core.command.NormalCmdFactory;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.ProxyHelper;
import com.arialyy.aria.core.download.DGEntityWrapper;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.download.DownloadGroupTaskListener;
import com.arialyy.aria.core.download.DownloadTaskListener;
import com.arialyy.aria.core.download.target.DTargetFactory;
import com.arialyy.aria.core.download.target.FtpBuilderTarget;
import com.arialyy.aria.core.download.target.FtpDirBuilderTarget;
import com.arialyy.aria.core.download.target.FtpDirNormalTarget;
import com.arialyy.aria.core.download.target.FtpNormalTarget;
import com.arialyy.aria.core.download.target.GroupBuilderTarget;
import com.arialyy.aria.core.download.target.GroupNormalTarget;
import com.arialyy.aria.core.download.target.HttpBuilderTarget;
import com.arialyy.aria.core.download.target.HttpNormalTarget;
import com.arialyy.aria.core.event.EventMsgUtil;
import com.arialyy.aria.core.inf.AbsReceiver;
import com.arialyy.aria.core.inf.ReceiverType;
import com.arialyy.aria.core.queue.DGroupTaskQueue;
import com.arialyy.aria.core.queue.DTaskQueue;
import com.arialyy.aria.core.scheduler.M3U8PeerTaskListener;
import com.arialyy.aria.core.scheduler.SubTaskListener;
import com.arialyy.aria.core.scheduler.TaskInternalListenerInterface;
import com.arialyy.aria.core.scheduler.TaskSchedulers;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.ComponentUtil;
import com.arialyy.aria.util.DbDataHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DownloadReceiver
extends AbsReceiver {
    public DownloadReceiver(Object obj) {
        super(obj);
    }

    @Deprecated
    public DownloadReceiver setMaxSpeed(int maxSpeed) {
        AriaConfig.getInstance().getDConfig().setMaxSpeed(maxSpeed);
        return this;
    }

    public HttpBuilderTarget load(String url) {
        ComponentUtil.getInstance().checkComponentExist(1);
        return DTargetFactory.getInstance().generateBuilderTarget(HttpBuilderTarget.class, url);
    }

    public HttpNormalTarget load(long taskId) {
        ComponentUtil.getInstance().checkComponentExist(1);
        return DTargetFactory.getInstance().generateNormalTarget(HttpNormalTarget.class, taskId);
    }

    public GroupBuilderTarget loadGroup(List<String> urls) {
        ComponentUtil.getInstance().checkComponentExist(1);
        return DTargetFactory.getInstance().generateGroupBuilderTarget(urls);
    }

    public GroupNormalTarget loadGroup(long taskId) {
        ComponentUtil.getInstance().checkComponentExist(1);
        return DTargetFactory.getInstance().generateNormalTarget(GroupNormalTarget.class, taskId);
    }

    public FtpBuilderTarget loadFtp(String url) {
        ComponentUtil.getInstance().checkComponentExist(2);
        return DTargetFactory.getInstance().generateBuilderTarget(FtpBuilderTarget.class, url);
    }

    public FtpNormalTarget loadFtp(long taskId) {
        ComponentUtil.getInstance().checkComponentExist(2);
        return DTargetFactory.getInstance().generateNormalTarget(FtpNormalTarget.class, taskId);
    }

    public FtpDirBuilderTarget loadFtpDir(String dirUrl) {
        ComponentUtil.getInstance().checkComponentExist(2);
        return DTargetFactory.getInstance().generateDirBuilderTarget(dirUrl);
    }

    public FtpDirNormalTarget loadFtpDir(long taskId) {
        ComponentUtil.getInstance().checkComponentExist(2);
        return DTargetFactory.getInstance().generateNormalTarget(FtpDirNormalTarget.class, taskId);
    }

    @Override
    public void register() {
        if (this.obj == null) {
            ALog.e((String)this.TAG, (String)String.format("register\u3010%s\u3011\u89c2\u5bdf\u8005\u4e3a\u7a7a", this.getTargetName()));
            return;
        }
        if (this.obj instanceof TaskInternalListenerInterface) {
            if (this.obj instanceof DownloadTaskListener) {
                TaskSchedulers.getInstance().register(this.obj, TaskEnum.DOWNLOAD);
            }
            if (this.obj instanceof DownloadGroupTaskListener) {
                TaskSchedulers.getInstance().register(this.obj, TaskEnum.DOWNLOAD_GROUP);
            }
            if (this.obj instanceof M3U8PeerTaskListener) {
                TaskSchedulers.getInstance().register(this.obj, TaskEnum.M3U8_PEER);
            }
            if (this.obj instanceof SubTaskListener) {
                TaskSchedulers.getInstance().register(this.obj, TaskEnum.DOWNLOAD_GROUP_SUB);
            }
            return;
        }
        Set<Integer> set = ProxyHelper.getInstance().checkProxyType(this.obj.getClass());
        if (set != null && !set.isEmpty()) {
            for (Integer type : set) {
                if (type == ProxyHelper.PROXY_TYPE_DOWNLOAD) {
                    TaskSchedulers.getInstance().register(this.obj, TaskEnum.DOWNLOAD);
                    continue;
                }
                if (type == ProxyHelper.PROXY_TYPE_DOWNLOAD_GROUP) {
                    TaskSchedulers.getInstance().register(this.obj, TaskEnum.DOWNLOAD_GROUP);
                    continue;
                }
                if (type == ProxyHelper.PROXY_TYPE_M3U8_PEER) {
                    TaskSchedulers.getInstance().register(this.obj, TaskEnum.M3U8_PEER);
                    continue;
                }
                if (type != ProxyHelper.PROXY_TYPE_DOWNLOAD_GROUP_SUB) continue;
                TaskSchedulers.getInstance().register(this.obj, TaskEnum.DOWNLOAD_GROUP_SUB);
            }
        } else {
            ALog.e((String)this.TAG, (String)"\u6ca1\u6709Aria\u7684\u6ce8\u89e3\u65b9\u6cd5\uff0c\u8be6\u60c5\u89c1\uff1ahttps://aria.laoyuyu.me/aria_doc/other/annotaion_invalid.html");
        }
    }

    @Override
    public void unRegister() {
        if (this.isNeedRmListener()) {
            this.unRegisterListener();
        }
        AriaManager.getInstance().removeReceiver(this.obj);
    }

    @Override
    public ReceiverType getType() {
        return ReceiverType.DOWNLOAD;
    }

    @Override
    protected void unRegisterListener() {
        if (this.obj == null) {
            ALog.e((String)this.TAG, (String)String.format("unRegister\u3010%s\u3011\u89c2\u5bdf\u8005\u4e3a\u7a7a", this.getTargetName()));
            return;
        }
        Set<Integer> set = ProxyHelper.getInstance().mProxyCache.get(this.obj.getClass().getName());
        if (set != null) {
            for (Integer integer : set) {
                if (integer == ProxyHelper.PROXY_TYPE_DOWNLOAD) {
                    TaskSchedulers.getInstance().unRegister(this.obj);
                    continue;
                }
                if (integer != ProxyHelper.PROXY_TYPE_DOWNLOAD_GROUP) continue;
                TaskSchedulers.getInstance().unRegister(this.obj);
            }
        }
    }

    public DownloadEntity getDownloadEntity(long taskId) {
        if (taskId < 0L) {
            ALog.e((String)this.TAG, (String)"taskId\u9519\u8bef");
            return null;
        }
        return (DownloadEntity)DbEntity.findFirst(DownloadEntity.class, (String[])new String[]{"rowid=?", String.valueOf(taskId)});
    }

    public DownloadEntity getFirstDownloadEntity(String downloadUrl) {
        if (!CheckUtil.checkUrl((String)downloadUrl)) {
            return null;
        }
        return (DownloadEntity)DbEntity.findFirst(DownloadEntity.class, (String[])new String[]{"url=? and isGroupChild='false'", downloadUrl});
    }

    public List<DownloadEntity> getDownloadEntity(String downloadUrl) {
        if (!CheckUtil.checkUrl((String)downloadUrl)) {
            return null;
        }
        return DbEntity.findDatas(DownloadEntity.class, (String[])new String[]{"url=? and isGroupChild='false'", downloadUrl});
    }

    public DownloadGroupEntity getGroupEntity(long taskId) {
        if (taskId < 0L) {
            ALog.e((String)this.TAG, (String)"\u4efb\u52a1Id\u9519\u8bef");
        }
        return DbDataHelper.getDGEntity((long)taskId);
    }

    public DownloadGroupEntity getGroupEntity(List<String> urls) {
        if (CheckUtil.checkDownloadUrlsIsEmpty(urls)) {
            return null;
        }
        return DbDataHelper.getDGEntityByHash((String)CommonUtil.getMd5Code(urls));
    }

    public DownloadGroupEntity getFtpDirEntity(String url) {
        if (!CheckUtil.checkUrl((String)url)) {
            return null;
        }
        return DbDataHelper.getDGEntityByHash((String)url);
    }

    public List<DownloadEntity> getDRunningTask() {
        return DTaskQueue.getInstance().getRunningTask(DownloadEntity.class);
    }

    public List<DownloadGroupEntity> getDGRunningTask() {
        return DGroupTaskQueue.getInstance().getRunningTask(DownloadGroupEntity.class);
    }

    public boolean taskExists(String downloadUrl) {
        return DbEntity.checkDataExist(DownloadEntity.class, (String[])new String[]{"url=?", downloadUrl});
    }

    public boolean taskExists(List<String> urls) {
        if (urls == null || urls.isEmpty()) {
            return false;
        }
        String groupHash = CommonUtil.getMd5Code(urls);
        return DbEntity.checkDataExist(DownloadGroupEntity.class, (String[])new String[]{"groupHash=?", groupHash});
    }

    public List<DownloadEntity> getTaskList() {
        return DbEntity.findDatas(DownloadEntity.class, (String[])new String[]{"isGroupChild=? and downloadPath!=''", "false"});
    }

    public List<DownloadEntity> getTaskList(int page, int num) {
        CheckUtil.checkPageParams((int)page, (int)num);
        return DbEntity.findDatas(DownloadEntity.class, (int)page, (int)num, (String[])new String[]{"isGroupChild=? and downloadPath!=''", "false"});
    }

    public List<DownloadEntity> getAllNotCompleteTask() {
        return DbEntity.findDatas(DownloadEntity.class, (String[])new String[]{"isGroupChild=? and downloadPath!='' and isComplete=?", "false", "false"});
    }

    public List<DownloadEntity> getAllNotCompleteTask(int page, int num) {
        CheckUtil.checkPageParams((int)page, (int)num);
        return DbEntity.findDatas(DownloadEntity.class, (int)page, (int)num, (String[])new String[]{"isGroupChild=? and downloadPath!='' and isComplete=?", "false", "false"});
    }

    public List<DownloadEntity> getAllCompleteTask() {
        return DbEntity.findDatas(DownloadEntity.class, (String[])new String[]{"isGroupChild=? and downloadPath!='' and isComplete=?", "false", "true"});
    }

    public List<DownloadEntity> getAllCompleteTask(int page, int num) {
        CheckUtil.checkPageParams((int)page, (int)num);
        return DbEntity.findDatas(DownloadEntity.class, (String[])new String[]{"isGroupChild=? and downloadPath!='' and isComplete=?", "false", "true"});
    }

    public List<DownloadGroupEntity> getGroupTaskList() {
        return this.getGroupTaskList(1, 10);
    }

    public List<DownloadGroupEntity> getGroupTaskList(int page, int num) {
        List wrappers = DbEntity.findRelationData(DGEntityWrapper.class, (int)page, (int)num, (String[])new String[0]);
        if (wrappers == null || wrappers.isEmpty()) {
            return null;
        }
        ArrayList<DownloadGroupEntity> entities = new ArrayList<DownloadGroupEntity>();
        for (DGEntityWrapper wrapper : wrappers) {
            entities.add(wrapper.groupEntity);
        }
        return entities;
    }

    public List<AbsEntity> getTotalTaskList() {
        ArrayList<AbsEntity> list = new ArrayList<AbsEntity>();
        List<DownloadEntity> simpleTask = this.getTaskList();
        List<DownloadGroupEntity> groupTask = this.getGroupTaskList();
        if (simpleTask != null && !simpleTask.isEmpty()) {
            list.addAll(simpleTask);
        }
        if (groupTask != null && !groupTask.isEmpty()) {
            list.addAll(groupTask);
        }
        return list;
    }

    public void stopAllTask() {
        EventMsgUtil.getDefault().post((Object)NormalCmdFactory.getInstance().createCmd((AbsTaskWrapper)new DTaskWrapper(null), 183, 1));
    }

    public void resumeAllTask() {
        EventMsgUtil.getDefault().post((Object)NormalCmdFactory.getInstance().createCmd((AbsTaskWrapper)new DTaskWrapper(null), 184, 1));
    }

    public void removeAllTask(boolean removeFile) {
        AriaManager ariaManager = AriaManager.getInstance();
        CancelAllCmd cancelCmd = (CancelAllCmd)CmdHelper.createNormalCmd(new DTaskWrapper(null), 185, 1);
        cancelCmd.removeFile = removeFile;
        EventMsgUtil.getDefault().post((Object)cancelCmd);
        Set<String> keys = ariaManager.getReceiver().keySet();
        for (String key : keys) {
            ariaManager.getReceiver().remove(key);
        }
    }
}

