/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.download;

import android.text.TextUtils;
import com.arialyy.aria.core.FtpUrlEntity;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.inf.ICheckEntityUtil;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import java.io.File;

public class CheckFtpDirEntityUtil
implements ICheckEntityUtil {
    private final String TAG = "CheckFtpDirEntityUtil";
    private DGTaskWrapper mWrapper;
    private DownloadGroupEntity mEntity;
    private int action;

    public static CheckFtpDirEntityUtil newInstance(DGTaskWrapper wrapper, int action) {
        return new CheckFtpDirEntityUtil(wrapper, action);
    }

    private CheckFtpDirEntityUtil(DGTaskWrapper wrapper, int action) {
        this.action = action;
        this.mWrapper = wrapper;
        this.mEntity = (DownloadGroupEntity)this.mWrapper.getEntity();
    }

    private boolean checkDirPath() {
        if (TextUtils.isEmpty((CharSequence)this.mWrapper.getDirPathTemp())) {
            ALog.e((String)"CheckFtpDirEntityUtil", (String)"\u6587\u4ef6\u5939\u8def\u5f84\u4e0d\u80fd\u4e3anull");
            return false;
        }
        if (!this.mWrapper.getDirPathTemp().startsWith("/")) {
            ALog.e((String)"CheckFtpDirEntityUtil", (String)String.format("\u6587\u4ef6\u5939\u8def\u5f84\u3010%s\u3011\u9519\u8bef", this.mWrapper.getDirPathTemp()));
            return false;
        }
        File file = new File(this.mWrapper.getDirPathTemp());
        if (file.isFile()) {
            ALog.e((String)"CheckFtpDirEntityUtil", (String)String.format("\u8def\u5f84\u3010%s\u3011\u662f\u6587\u4ef6\uff0c\u8bf7\u8bbe\u7f6e\u6587\u4ef6\u5939\u8def\u5f84", this.mWrapper.getDirPathTemp()));
            return false;
        }
        if (this.mWrapper.isNewTask() && !CheckUtil.checkDGPathConflicts((boolean)this.mWrapper.isIgnoreFilePathOccupy(), (String)this.mWrapper.getDirPathTemp())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mEntity.getDirPath()) || !this.mEntity.getDirPath().equals(this.mWrapper.getDirPathTemp())) {
            if (!file.exists()) {
                file.mkdirs();
            }
            this.mEntity.setDirPath(this.mWrapper.getDirPathTemp());
            ALog.i((String)"CheckFtpDirEntityUtil", (String)String.format("\u6587\u4ef6\u5939\u8def\u5f84\u6539\u53d8\uff0c\u5c06\u66f4\u65b0\u6587\u4ef6\u5939\u8def\u5f84\u4e3a\uff1a%s", this.mWrapper.getDirPathTemp()));
        }
        return true;
    }

    @Override
    public boolean checkEntity() {
        boolean b;
        if (this.mWrapper.getErrorEvent() != null) {
            ALog.e((String)"CheckFtpDirEntityUtil", (String)String.format("\u4efb\u52a1\u64cd\u4f5c\u5931\u8d25\uff0c%s", this.mWrapper.getErrorEvent().errorMsg));
            return false;
        }
        boolean bl = b = this.checkDirPath() && this.checkUrl();
        if (b) {
            this.mEntity.save();
        }
        FtpUrlEntity urlEntity = (FtpUrlEntity)this.mWrapper.getOptionParams().getParam("urlEntity");
        assert (urlEntity != null);
        if (urlEntity.isFtps) {
            if (TextUtils.isEmpty((CharSequence)urlEntity.idEntity.storePath)) {
                ALog.e((String)"CheckFtpDirEntityUtil", (String)"\u8bc1\u4e66\u8def\u5f84\u4e3a\u7a7a");
                return false;
            }
            if (TextUtils.isEmpty((CharSequence)urlEntity.idEntity.keyAlias)) {
                ALog.e((String)"CheckFtpDirEntityUtil", (String)"\u8bc1\u4e66\u522b\u540d\u4e3a\u7a7a");
                return false;
            }
        }
        return b;
    }

    private boolean checkUrl() {
        String url = this.mEntity.getKey();
        if (TextUtils.isEmpty((CharSequence)url)) {
            ALog.e((String)"CheckFtpDirEntityUtil", (String)"\u4e0b\u8f7d\u5931\u8d25\uff0curl\u4e3anull");
            return false;
        }
        if (!url.startsWith("ftp")) {
            ALog.e((String)"CheckFtpDirEntityUtil", (String)("\u4e0b\u8f7d\u5931\u8d25\uff0curl\u3010" + url + "\u3011\u9519\u8bef"));
            return false;
        }
        int index = url.indexOf("://");
        if (index == -1) {
            ALog.e((String)"CheckFtpDirEntityUtil", (String)("\u4e0b\u8f7d\u5931\u8d25\uff0curl\u3010" + url + "\u3011\u4e0d\u5408\u6cd5"));
            return false;
        }
        return true;
    }
}

