/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.download;

import android.text.TextUtils;
import com.arialyy.aria.core.common.RequestEnum;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.inf.ICheckEntityUtil;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import com.arialyy.aria.util.RecordUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CheckDGEntityUtil
implements ICheckEntityUtil {
    private final String TAG = "CheckDGEntityUtil";
    private DGTaskWrapper mWrapper;
    private DownloadGroupEntity mEntity;
    private boolean needModifyPath = false;
    private int action;

    public static CheckDGEntityUtil newInstance(DGTaskWrapper wrapper, int action) {
        return new CheckDGEntityUtil(wrapper, action);
    }

    private CheckDGEntityUtil(DGTaskWrapper wrapper, int action) {
        this.action = action;
        this.mWrapper = wrapper;
        this.mEntity = (DownloadGroupEntity)this.mWrapper.getEntity();
    }

    private boolean checkDirPath() {
        if (TextUtils.isEmpty((CharSequence)this.mWrapper.getDirPathTemp())) {
            ALog.e((String)"CheckDGEntityUtil", (String)"\u6587\u4ef6\u5939\u8def\u5f84\u4e0d\u80fd\u4e3anull");
            return false;
        }
        if (!this.mWrapper.getDirPathTemp().startsWith("/")) {
            ALog.e((String)"CheckDGEntityUtil", (String)String.format("\u6587\u4ef6\u5939\u8def\u5f84\u3010%s\u3011\u9519\u8bef", this.mWrapper.getDirPathTemp()));
            return false;
        }
        File file = new File(this.mWrapper.getDirPathTemp());
        if (file.isFile()) {
            ALog.e((String)"CheckDGEntityUtil", (String)String.format("\u8def\u5f84\u3010%s\u3011\u662f\u6587\u4ef6\uff0c\u8bf7\u8bbe\u7f6e\u6587\u4ef6\u5939\u8def\u5f84", this.mWrapper.getDirPathTemp()));
            return false;
        }
        if (this.mWrapper.isNewTask() && !CheckUtil.checkDGPathConflicts((boolean)this.mWrapper.isIgnoreFilePathOccupy(), (String)this.mWrapper.getDirPathTemp())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.mEntity.getDirPath()) || !this.mEntity.getDirPath().equals(this.mWrapper.getDirPathTemp())) {
            if (!file.exists()) {
                file.mkdirs();
            }
            this.needModifyPath = true;
            this.mEntity.setDirPath(this.mWrapper.getDirPathTemp());
            ALog.i((String)"CheckDGEntityUtil", (String)String.format("\u6587\u4ef6\u5939\u8def\u5f84\u6539\u53d8\uff0c\u5c06\u66f4\u65b0\u6587\u4ef6\u5939\u8def\u5f84\u4e3a\uff1a%s", this.mWrapper.getDirPathTemp()));
        }
        return true;
    }

    private void reChangeDirPath(String newDirPath) {
        ALog.d((String)"CheckDGEntityUtil", (String)String.format("\u4fee\u6539\u65b0\u8def\u5f84\u4e3a\uff1a%s", newDirPath));
        List subTasks = this.mWrapper.getSubTaskWrapper();
        if (subTasks != null && !subTasks.isEmpty()) {
            for (DTaskWrapper dte : subTasks) {
                DownloadEntity de = (DownloadEntity)dte.getEntity();
                String oldPath = de.getFilePath();
                String newPath = newDirPath + "/" + de.getFileName();
                File file = new File(oldPath);
                if (file.exists()) {
                    file.renameTo(new File(newPath));
                }
                de.setFilePath(newPath);
            }
        }
    }

    private boolean checkGroupHash(boolean isIgnoreTaskOccupy, String groupHash) {
        DownloadGroupEntity dge = (DownloadGroupEntity)DbEntity.findFirst(DownloadGroupEntity.class, (String[])new String[]{"groupHash=?", groupHash});
        if (dge != null && dge.getGroupHash().equals(this.mEntity.getGroupHash())) {
            this.mEntity.rowID = dge.rowID;
            return true;
        }
        if (DbEntity.checkDataExist(DownloadGroupEntity.class, (String[])new String[]{"groupHash=?", groupHash})) {
            if (!isIgnoreTaskOccupy) {
                ALog.e((String)"CheckDGEntityUtil", (String)String.format("\u4e0b\u8f7d\u5931\u8d25\uff0c\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u7684url\u7684\u7ec4\u4efb\u52a1\uff0cgroupHash = %s", groupHash));
                return false;
            }
            ALog.w((String)"CheckDGEntityUtil", (String)String.format("\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u7684url\u7684\u7ec4\u4efb\u52a1\uff0c\u5c06\u5220\u9664groupHash = %s \u7684\u65e7\u4efb\u52a1", groupHash));
            RecordUtil.delGroupTaskRecordByHash((String)groupHash, (boolean)true);
            return true;
        }
        return true;
    }

    @Override
    public boolean checkEntity() {
        if (this.mWrapper.getErrorEvent() != null) {
            ALog.e((String)"CheckDGEntityUtil", (String)String.format("\u4efb\u52a1\u64cd\u4f5c\u5931\u8d25\uff0c%s", this.mWrapper.getErrorEvent().errorMsg));
            return false;
        }
        if (!(this.action != 1 && this.action != 5 || this.checkGroupHash(this.mWrapper.isIgnoreTaskOccupy(), this.mEntity.getGroupHash()))) {
            return false;
        }
        if (!this.checkDirPath()) {
            return false;
        }
        if (!this.checkSubName()) {
            return false;
        }
        if (!this.checkUrls()) {
            return false;
        }
        if (this.action != 4 && !this.mWrapper.isUnknownSize() && this.mEntity.getFileSize() == 0L) {
            ALog.e((String)"CheckDGEntityUtil", (String)"\u7ec4\u5408\u4efb\u52a1\u5fc5\u987b\u8bbe\u7f6e\u6587\u4ef6\u6587\u4ef6\u5927\u5c0f\uff0c\u9ed8\u8ba4\u9700\u8981\u5f3a\u5236\u8bbe\u7f6e\u6587\u4ef6\u5927\u5c0f\u3002\u5982\u679c\u65e0\u6cd5\u83b7\u53d6\u5230\u603b\u957f\u5ea6\uff0c\u8bf7\u8c03\u7528#unknownSize()\u6765\u6807\u5fd7\u8be5\u7ec4\u5408\u4efb\u52a1");
            return false;
        }
        if (this.mWrapper.getOptionParams().getParam("requestEnum") == RequestEnum.POST) {
            for (DTaskWrapper subWrapper : this.mWrapper.getSubTaskWrapper()) {
                subWrapper.getOptionParams().setParams("requestEnum", (Object)RequestEnum.POST);
            }
        }
        if (this.needModifyPath) {
            this.reChangeDirPath(this.mWrapper.getDirPathTemp());
        }
        if (!this.mWrapper.getSubNameTemp().isEmpty()) {
            this.updateSingleSubFileName();
        }
        this.saveEntity();
        return true;
    }

    private void saveEntity() {
        this.mEntity.save();
        DbEntity.saveAll((List)this.mEntity.getSubEntities());
    }

    private void updateSingleSubFileName() {
        List entities = this.mWrapper.getSubTaskWrapper();
        int i = 0;
        for (DTaskWrapper taskWrapper : entities) {
            DownloadEntity entity;
            String newName;
            if (i < this.mWrapper.getSubNameTemp().size() && !(newName = (String)this.mWrapper.getSubNameTemp().get(i)).equals((entity = (DownloadEntity)taskWrapper.getEntity()).getFileName())) {
                String oldPath = this.mEntity.getDirPath() + "/" + entity.getFileName();
                String newPath = this.mEntity.getDirPath() + "/" + newName;
                if (DbEntity.checkDataExist(DownloadEntity.class, (String[])new String[]{"downloadPath=?", newPath})) {
                    ALog.w((String)"CheckDGEntityUtil", (String)String.format("\u66f4\u65b0\u6587\u4ef6\u540d\u5931\u8d25\uff0c\u8def\u5f84\u3010%s\u3011\u88ab\u5176\u5b83\u4efb\u52a1\u5360\u7528", newPath));
                    return;
                }
                RecordUtil.modifyTaskRecord((String)oldPath, (String)newPath, (int)this.mEntity.getTaskType());
                entity.setFilePath(newPath);
                entity.setFileName(newName);
            }
            ++i;
        }
    }

    private boolean checkUrls() {
        if (this.mEntity.getUrls().isEmpty()) {
            ALog.e((String)"CheckDGEntityUtil", (String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5b50\u4efb\u52a1\u4e0b\u8f7d\u5217\u8868\u4e3anull");
            return false;
        }
        HashSet<String> repeated = new HashSet<String>();
        ArrayList<String> results = new ArrayList<String>();
        for (String url : this.mEntity.getUrls()) {
            if (repeated.add(url)) continue;
            results.add(url);
        }
        if (!results.isEmpty()) {
            ALog.e((String)"CheckDGEntityUtil", (String)String.format("\u7ec4\u5408\u4efb\u52a1\u4e2d\u6709url\u91cd\u590d\uff0c\u91cd\u590d\u7684url\uff1a%s", Arrays.toString(results.toArray())));
            return false;
        }
        HashSet<Integer> delItem = new HashSet<Integer>();
        int i = 0;
        for (String url : this.mEntity.getUrls()) {
            if (TextUtils.isEmpty((CharSequence)url)) {
                ALog.e((String)"CheckDGEntityUtil", (String)"\u5b50\u4efb\u52a1url\u4e3anull\uff0c\u5373\u5c06\u5220\u9664\u8be5\u5b50\u4efb\u52a1\u3002");
                delItem.add(i);
                continue;
            }
            if (!url.startsWith("http")) {
                ALog.e((String)"CheckDGEntityUtil", (String)("\u5b50\u4efb\u52a1url\u3010" + url + "\u3011\u9519\u8bef\uff0c\u5373\u5c06\u5220\u9664\u8be5\u5b50\u4efb\u52a1\u3002"));
                delItem.add(i);
                continue;
            }
            int index = url.indexOf("://");
            if (index == -1) {
                ALog.e((String)"CheckDGEntityUtil", (String)("\u5b50\u4efb\u52a1url\u3010" + url + "\u3011\u4e0d\u5408\u6cd5\uff0c\u5373\u5c06\u5220\u9664\u8be5\u5b50\u4efb\u52a1\u3002"));
                delItem.add(i);
                continue;
            }
            ++i;
        }
        Iterator iterator = delItem.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            this.mEntity.getUrls().remove(index);
            if (this.mWrapper.getSubNameTemp() == null || this.mWrapper.getSubNameTemp().isEmpty()) continue;
            this.mWrapper.getSubNameTemp().remove(index);
        }
        return true;
    }

    private boolean checkSubName() {
        if (this.mWrapper.getSubNameTemp() == null || this.mWrapper.getSubNameTemp().isEmpty()) {
            return true;
        }
        if (this.mEntity.getUrls().size() != this.mWrapper.getSubNameTemp().size()) {
            ALog.e((String)"CheckDGEntityUtil", (String)"\u5b50\u4efb\u52a1\u6587\u4ef6\u540d\u5fc5\u987b\u548c\u5b50\u4efb\u52a1\u6570\u91cf\u4e00\u81f4");
            return false;
        }
        return true;
    }
}

