/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.download;

import android.text.TextUtils;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.M3U8Entity;
import com.arialyy.aria.core.inf.ICheckEntityUtil;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.FileUtil;
import com.arialyy.aria.util.RecordUtil;
import java.io.File;

public class CheckDEntityUtil
implements ICheckEntityUtil {
    private final String TAG = CommonUtil.getClassName(this.getClass());
    private DTaskWrapper mWrapper;
    private DownloadEntity mEntity;
    private int action;

    public static CheckDEntityUtil newInstance(DTaskWrapper wrapper, int action) {
        return new CheckDEntityUtil(wrapper, action);
    }

    private CheckDEntityUtil(DTaskWrapper wrapper, int action) {
        this.action = action;
        this.mWrapper = wrapper;
        this.mEntity = (DownloadEntity)this.mWrapper.getEntity();
    }

    @Override
    public boolean checkEntity() {
        boolean b;
        if (this.mWrapper.getErrorEvent() != null) {
            ALog.e((String)this.TAG, (String)String.format("\u4efb\u52a1\u64cd\u4f5c\u5931\u8d25\uff0c%s", this.mWrapper.getErrorEvent().errorMsg));
            return false;
        }
        boolean bl = b = this.checkUrl() && this.checkFilePath();
        if (b) {
            this.mEntity.save();
        }
        if (this.mWrapper.getRequestType() == 7 || this.mWrapper.getRequestType() == 8) {
            this.handleM3U8();
        }
        return b;
    }

    private void handleM3U8() {
        File file = new File(this.mWrapper.getTempFilePath());
        Object bw = this.mWrapper.getM3U8Params().getParam("bandWidth");
        int bandWidth = bw == null ? 0 : (Integer)bw;
        String cacheDir = FileUtil.getTsCacheDir((String)file.getPath(), (int)bandWidth);
        this.mWrapper.getM3U8Params().setParams("cacheDir", (Object)cacheDir);
        M3U8Entity m3U8Entity = this.mEntity.getM3U8Entity();
        if (m3U8Entity == null) {
            m3U8Entity = new M3U8Entity();
            m3U8Entity.setFilePath(this.mEntity.getFilePath());
            m3U8Entity.setPeerIndex(0);
            m3U8Entity.setCacheDir(cacheDir);
            m3U8Entity.insert();
        } else {
            m3U8Entity.update();
        }
        if (this.mWrapper.getRequestType() == 7 && this.action == 1) {
            if (this.mEntity.getFileSize() == 0L) {
                ALog.w((String)this.TAG, (String)"\u7531\u4e8em3u8\u534f\u8bae\u7684\u7279\u6b8a\u6027\u8d28\uff0c\u65e0\u6cd5\u6709\u6548\u5feb\u901f\u83b7\u53d6\u5230\u6b63\u786e\u5230\u6587\u4ef6\u957f\u5ea6\uff0c\u5982\u679c\u4f60\u9700\u8981\u663e\u793a\u6587\u4ef6\u4e2d\u957f\u5ea6\uff0c\u4f60\u9700\u8981\u81ea\u884c\u8bbe\u7f6e\u6587\u4ef6\u957f\u5ea6\uff1a.asM3U8().asVod().setFileSize(xxx)");
            }
        } else if (this.mWrapper.getRequestType() == 8 && this.action != 4 && file.exists()) {
            ALog.w((String)this.TAG, (String)"\u5bf9\u4e8e\u76f4\u64ad\u6765\u8bf4\uff0c\u6bcf\u6b21\u4e0b\u8f7d\u90fd\u662f\u4e00\u4e2a\u65b0\u6587\u4ef6\uff0c\u6240\u4ee5\u4f60\u9700\u8981\u8bbe\u7f6e\u65b0\u90fd\u6587\u4ef6\u8def\u5f84\uff0c\u5426\u5219Aria\u6846\u67b6\u5c06\u4f1a\u8986\u76d6\u5df2\u4e0b\u8f7d\u7684\u6587\u4ef6");
            file.delete();
        }
        if (this.action != 4 && this.mWrapper.getM3U8Params().getHandler("bandWidthUrlConverter") != null && bandWidth == 0) {
            ALog.w((String)this.TAG, (String)"\u4f60\u5df2\u7ecf\u8bbe\u7f6e\u4e86\u7801\u7387url\u8f6c\u6362\u5668\uff0c\u4f46\u662f\u6ca1\u6709\u8bbe\u7f6e\u7801\u7387\uff0cAria\u6846\u67b6\u5c06\u91c7\u7528\u7b2c\u4e00\u4e2a\u83b7\u53d6\u5230\u7684\u7801\u7387");
        }
    }

    private boolean checkFilePath() {
        String filePath = this.mWrapper.getTempFilePath();
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            ALog.e((String)this.TAG, (String)"\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84\u4e3anull");
            return false;
        }
        if (!filePath.startsWith("/")) {
            ALog.e((String)this.TAG, (String)String.format("\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4fdd\u5b58\u8def\u5f84\u3010%s\u3011\u9519\u8bef", filePath));
            return false;
        }
        File file = new File(filePath);
        if (file.isDirectory()) {
            if (this.mWrapper.getRequestType() == 1 || this.mWrapper.getRequestType() == 7) {
                ALog.e((String)this.TAG, (String)String.format("\u4e0b\u8f7d\u5931\u8d25\uff0c\u4fdd\u5b58\u8def\u5f84\u3010%s\u3011\u4e0d\u80fd\u4e3a\u6587\u4ef6\u5939\uff0c\u8def\u5f84\u9700\u8981\u662f\u5b8c\u6574\u7684\u6587\u4ef6\u8def\u5f84\uff0c\u5982\uff1a/mnt/sdcard/game.zip", filePath));
                return false;
            }
            if (this.mWrapper.getRequestType() == 4) {
                filePath = filePath + this.mEntity.getFileName();
            }
        } else if (TextUtils.isEmpty((CharSequence)this.mEntity.getFileName())) {
            this.mEntity.setFileName(file.getName());
        }
        return this.checkPathConflicts(filePath);
    }

    private boolean checkPathConflicts(String filePath) {
        DownloadEntity de = (DownloadEntity)DbEntity.findFirst(DownloadEntity.class, (String[])new String[]{"downloadPath=?", filePath});
        if (de != null && de.getUrl().equals(this.mEntity.getUrl())) {
            this.mEntity.rowID = de.rowID;
            this.mEntity.setFilePath(filePath);
            this.mEntity.setFileName(new File(filePath).getName());
            return true;
        }
        if (!filePath.equals(this.mEntity.getFilePath())) {
            if (!CheckUtil.checkDPathConflicts((boolean)this.mWrapper.isIgnoreFilePathOccupy(), (String)filePath, (int)this.mWrapper.getRequestType())) {
                return false;
            }
            File newFile = new File(filePath);
            this.mEntity.setFilePath(filePath);
            this.mEntity.setFileName(newFile.getName());
            Object usf = this.mWrapper.getOptionParams().getParam("useServerFileName");
            if (usf != null && ((Boolean)usf).booleanValue() || this.mWrapper.getRequestType() == 8) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.mEntity.getFilePath())) {
                File oldFile = new File(this.mEntity.getFilePath());
                if (oldFile.exists()) {
                    RecordUtil.modifyTaskRecord((String)oldFile.getPath(), (String)newFile.getPath(), (int)this.mEntity.getTaskType());
                    ALog.i((String)this.TAG, (String)String.format("\u5c06\u4efb\u52a1\u91cd\u547d\u540d\u4e3a\uff1a%s", newFile.getName()));
                } else if (RecordUtil.blockTaskExists((String)oldFile.getPath())) {
                    RecordUtil.modifyTaskRecord((String)oldFile.getPath(), (String)newFile.getPath(), (int)this.mEntity.getTaskType());
                    ALog.i((String)this.TAG, (String)String.format("\u5c06\u5206\u5757\u4efb\u52a1\u91cd\u547d\u540d\u4e3a\uff1a%s", newFile.getName()));
                }
            }
        }
        return true;
    }

    private boolean checkUrl() {
        String url = this.mEntity.getUrl();
        if (TextUtils.isEmpty((CharSequence)url)) {
            ALog.e((String)this.TAG, (String)"\u4e0b\u8f7d\u5931\u8d25\uff0curl\u4e3anull");
            return false;
        }
        if (!CheckUtil.checkUrl((String)url)) {
            ALog.e((String)this.TAG, (String)("\u4e0b\u8f7d\u5931\u8d25\uff0curl\u3010" + url + "\u3011\u9519\u8bef"));
            return false;
        }
        int index = url.indexOf("://");
        if (index == -1) {
            ALog.e((String)this.TAG, (String)("\u4e0b\u8f7d\u5931\u8d25\uff0curl\u3010" + url + "\u3011\u4e0d\u5408\u6cd5"));
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mWrapper.getTempUrl())) {
            this.mEntity.setUrl(this.mWrapper.getTempUrl());
        }
        return true;
    }
}

