/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.common.controller;

import android.os.Handler;
import android.os.Looper;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.common.controller.ControllerType;
import com.arialyy.aria.core.download.CheckDEntityUtil;
import com.arialyy.aria.core.download.CheckDGEntityUtil;
import com.arialyy.aria.core.download.CheckFtpDirEntityUtil;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.inf.ICheckEntityUtil;
import com.arialyy.aria.core.scheduler.TaskSchedulers;
import com.arialyy.aria.core.upload.CheckUEntityUtil;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class FeatureController {
    private static final int ACTION_DEF = 0;
    public static final int ACTION_CREATE = 1;
    public static final int ACTION_RESUME = 2;
    public static final int ACTION_STOP = 3;
    public static final int ACTION_CANCEL = 4;
    public static final int ACTION_ADD = 5;
    public static final int ACTION_PRIORITY = 6;
    public static final int ACTION_RETRY = 7;
    public static final int ACTION_RESTART = 8;
    public static final int ACTION_SAVE = 9;
    private final String TAG;
    private AbsTaskWrapper mTaskWrapper;
    private boolean ignoreCheckPermissions = false;
    private int action = 0;

    FeatureController(AbsTaskWrapper wrapper) {
        this.mTaskWrapper = wrapper;
        this.TAG = CommonUtil.getClassName(this.getClass());
    }

    public static <T extends FeatureController> T newInstance(Class<T> clazz, AbsTaskWrapper wrapper) {
        if (wrapper.getEntity().getId() == -1L && clazz != ControllerType.CREATE_CONTROLLER) {
            throw new IllegalArgumentException("\u5bf9\u4e8e\u4e0d\u5b58\u5728\u7684\u4efb\u52a1\uff08\u7b2c\u4e00\u6b21\u4e0b\u8f7d\uff09\uff0c\u53ea\u80fd\u4f7f\u7528\"ControllerType.CREATE_CONTROLLER\"");
        }
        if (wrapper.getEntity().getId() != -1L && clazz != ControllerType.TASK_CONTROLLER) {
            throw new IllegalArgumentException("\u5bf9\u4e8e\u5df2\u5b58\u5728\u7684\u4efb\u52a1\uff0c\u53ea\u80fd\u4f7f\u7528\" ControllerType.TASK_CONTROLLER\"\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u91cd\u590d\u8c03\u7528#create()\u65b9\u6cd5");
        }
        Class[] paramTypes = new Class[]{AbsTaskWrapper.class};
        Object[] params = new Object[]{wrapper};
        try {
            Constructor<T> con = clazz.getConstructor(paramTypes);
            return (T)((FeatureController)con.newInstance(params));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    void setAction(int action) {
        this.action = action;
    }

    public void ignoreCheckPermissions() {
        this.ignoreCheckPermissions = true;
    }

    public void ignoreFilePathOccupy() {
        this.mTaskWrapper.setIgnoreFilePathOccupy(true);
    }

    protected AbsTaskWrapper getTaskWrapper() {
        return this.mTaskWrapper;
    }

    protected AbsEntity getEntity() {
        return this.mTaskWrapper.getEntity();
    }

    int checkTaskType() {
        int taskType = 0;
        if (this.mTaskWrapper instanceof DTaskWrapper) {
            taskType = 1;
        } else if (this.mTaskWrapper instanceof DGTaskWrapper) {
            taskType = 3;
        } else if (this.mTaskWrapper instanceof UTaskWrapper) {
            taskType = 2;
        }
        return taskType;
    }

    boolean checkConfig() {
        if (!this.ignoreCheckPermissions && !this.checkPermission()) {
            return false;
        }
        boolean b = this.checkEntity();
        TaskSchedulers schedulers = TaskSchedulers.getInstance();
        if (!b && schedulers != null) {
            new Handler(Looper.getMainLooper(), (Handler.Callback)schedulers).obtainMessage(11, this.checkTaskType(), -1, null).sendToTarget();
        }
        return b;
    }

    private boolean checkPermission() {
        if (AriaConfig.getInstance().getAPP().checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            ALog.e((String)this.TAG, (String)"\u542f\u52a8\u5931\u8d25\uff0c\u7f3a\u5c11\u6743\u9650\uff1aManifest.permission.WRITE_EXTERNAL_STORAGE");
            return false;
        }
        if (AriaConfig.getInstance().getAPP().checkCallingOrSelfPermission("android.permission.INTERNET") != 0) {
            ALog.e((String)this.TAG, (String)"\u542f\u52a8\u5931\u8d25\uff0c\u7f3a\u5c11\u6743\u9650\uff1aManifest.permission.INTERNET");
            return false;
        }
        if (AriaConfig.getInstance().getAPP().checkCallingOrSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0) {
            ALog.e((String)this.TAG, (String)"\u542f\u52a8\u5931\u8d25\uff0c\u7f3a\u5c11\u6743\u9650\uff1aManifest.permission.READ_EXTERNAL_STORAGE");
            return false;
        }
        return true;
    }

    private boolean checkEntity() {
        ICheckEntityUtil checkUtil = null;
        if (this.mTaskWrapper instanceof DTaskWrapper) {
            checkUtil = CheckDEntityUtil.newInstance((DTaskWrapper)this.mTaskWrapper, this.action);
        } else if (this.mTaskWrapper instanceof DGTaskWrapper) {
            if (this.mTaskWrapper.getRequestType() == 4) {
                checkUtil = CheckFtpDirEntityUtil.newInstance((DGTaskWrapper)this.mTaskWrapper, this.action);
            } else if (this.mTaskWrapper.getRequestType() == 2) {
                checkUtil = CheckDGEntityUtil.newInstance((DGTaskWrapper)this.mTaskWrapper, this.action);
            }
        } else if (this.mTaskWrapper instanceof UTaskWrapper) {
            checkUtil = CheckUEntityUtil.newInstance((UTaskWrapper)this.mTaskWrapper, this.action);
        }
        return checkUtil != null && checkUtil.checkEntity();
    }
}

