/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.common;

import com.arialyy.annotations.TaskEnum;
import com.arialyy.aria.core.download.DownloadGroupTaskListener;
import com.arialyy.aria.core.download.DownloadTaskListener;
import com.arialyy.aria.core.scheduler.M3U8PeerTaskListener;
import com.arialyy.aria.core.scheduler.SubTaskListener;
import com.arialyy.aria.core.scheduler.TaskInternalListenerInterface;
import com.arialyy.aria.core.upload.UploadTaskListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyHelper {
    public static int PROXY_TYPE_DOWNLOAD = 1;
    public static int PROXY_TYPE_DOWNLOAD_GROUP = 2;
    public static int PROXY_TYPE_UPLOAD = 3;
    public static int PROXY_TYPE_M3U8_PEER = 4;
    public static int PROXY_TYPE_DOWNLOAD_GROUP_SUB = 5;
    public Map<String, Set<Integer>> mProxyCache = new ConcurrentHashMap<String, Set<Integer>>();
    public static volatile ProxyHelper INSTANCE = null;

    private ProxyHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProxyHelper getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ProxyHelper> clazz = ProxyHelper.class;
        synchronized (ProxyHelper.class) {
            INSTANCE = new ProxyHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public Set<Integer> checkProxyType(Class clazz) {
        Set<Integer> result = this.mProxyCache.get(clazz.getName());
        if (result != null) {
            return result;
        }
        result = this.checkProxyTypeByInterface(clazz);
        if (result != null) {
            return result;
        }
        result = this.checkProxyTypeByProxyClass(clazz);
        if (!result.isEmpty()) {
            this.mProxyCache.put(clazz.getName(), result);
        }
        return result;
    }

    private Set<Integer> checkProxyTypeByProxyClass(Class clazz) {
        String className = clazz.getName();
        HashSet<Integer> result = new HashSet<Integer>();
        if (this.checkProxyExist(className, TaskEnum.DOWNLOAD_GROUP.proxySuffix)) {
            result.add(PROXY_TYPE_DOWNLOAD_GROUP);
        }
        if (this.checkProxyExist(className, TaskEnum.DOWNLOAD.proxySuffix)) {
            result.add(PROXY_TYPE_DOWNLOAD);
        }
        if (this.checkProxyExist(className, TaskEnum.UPLOAD.proxySuffix)) {
            result.add(PROXY_TYPE_UPLOAD);
        }
        if (this.checkProxyExist(className, TaskEnum.M3U8_PEER.proxySuffix)) {
            result.add(PROXY_TYPE_M3U8_PEER);
        }
        if (this.checkProxyExist(className, TaskEnum.DOWNLOAD_GROUP_SUB.proxySuffix)) {
            result.add(PROXY_TYPE_DOWNLOAD_GROUP_SUB);
        }
        return result;
    }

    private Set<Integer> checkProxyTypeByInterface(Class clazz) {
        if (!TaskInternalListenerInterface.class.isAssignableFrom(clazz)) {
            return null;
        }
        HashSet<Integer> result = new HashSet<Integer>();
        if (DownloadGroupTaskListener.class.isAssignableFrom(clazz)) {
            result.add(PROXY_TYPE_DOWNLOAD_GROUP);
        }
        if (DownloadTaskListener.class.isAssignableFrom(clazz)) {
            result.add(PROXY_TYPE_DOWNLOAD);
        }
        if (UploadTaskListener.class.isAssignableFrom(clazz)) {
            result.add(PROXY_TYPE_UPLOAD);
        }
        if (M3U8PeerTaskListener.class.isAssignableFrom(clazz)) {
            result.add(PROXY_TYPE_M3U8_PEER);
        }
        if (SubTaskListener.class.isAssignableFrom(clazz)) {
            result.add(PROXY_TYPE_DOWNLOAD_GROUP_SUB);
        }
        return result;
    }

    private boolean checkProxyExist(String className, String proxySuffix) {
        String clsName = className.concat(proxySuffix);
        try {
            if (this.getClass().getClassLoader().loadClass(clsName) != null) {
                return true;
            }
            if (Class.forName(clsName) != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }
}

