/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.common;

import android.text.TextUtils;
import com.arialyy.aria.core.common.BaseOption;
import com.arialyy.aria.core.common.RequestEnum;
import com.arialyy.aria.core.processor.IHttpFileLenAdapter;
import com.arialyy.aria.core.processor.IHttpFileNameAdapter;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;

public class HttpOption
extends BaseOption {
    private Map<String, String> params;
    private Map<String, String> headers;
    private RequestEnum requestEnum = RequestEnum.GET;
    private Map<String, String> formFields;
    private Proxy proxy;
    private boolean useServerFileName = false;
    private IHttpFileLenAdapter fileLenAdapter;
    private IHttpFileNameAdapter fileNameAdapter;
    private String attachment;

    public HttpOption setRequestType(RequestEnum requestEnum) {
        this.requestEnum = requestEnum;
        return this;
    }

    public HttpOption setParams(Map<String, String> params) {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        this.params.putAll(params);
        return this;
    }

    public HttpOption setParam(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)value)) {
            ALog.d((String)this.TAG, (String)"key \u6216value \u4e3a\u7a7a");
            return this;
        }
        if (this.params == null) {
            this.params = new HashMap<String, String>();
        }
        this.params.put(key, value);
        return this;
    }

    public HttpOption setFormFields(Map<String, String> formFields) {
        this.formFields = formFields;
        return this;
    }

    public HttpOption setAttachment(String attachment) {
        if (TextUtils.isEmpty((CharSequence)attachment)) {
            attachment = "file";
        }
        this.attachment = attachment;
        return this;
    }

    public HttpOption addHeader(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            ALog.w((String)this.TAG, (String)"\u8bbe\u7f6eheader\u5931\u8d25\uff0cheader\u5bf9\u5e94\u7684key\u4e0d\u80fd\u4e3anull");
            return this;
        }
        if (TextUtils.isEmpty((CharSequence)value)) {
            ALog.w((String)this.TAG, (String)"\u8bbe\u7f6eheader\u5931\u8d25\uff0cheader\u5bf9\u5e94\u7684value\u4e0d\u80fd\u4e3anull");
            return this;
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
        return this;
    }

    public HttpOption addHeaders(Map<String, String> headers) {
        if (headers.size() == 0) {
            ALog.w((String)this.TAG, (String)"\u8bbe\u7f6eheader\u5931\u8d25\uff0cmap\u6ca1\u6709header\u6570\u636e");
            return this;
        }
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.putAll(headers);
        return this;
    }

    public HttpOption setUrlProxy(Proxy proxy) {
        this.proxy = proxy;
        return this;
    }

    public HttpOption useServerFileName(boolean use) {
        this.useServerFileName = use;
        return this;
    }

    public HttpOption setFileLenAdapter(IHttpFileLenAdapter fileLenAdapter) {
        if (fileLenAdapter == null) {
            throw new IllegalArgumentException("adapter\u4e3a\u7a7a");
        }
        CheckUtil.checkMemberClass(fileLenAdapter.getClass());
        this.fileLenAdapter = fileLenAdapter;
        return this;
    }

    public HttpOption setFilNameAdapter(IHttpFileNameAdapter fileNameAdapter) {
        if (fileNameAdapter == null) {
            throw new IllegalArgumentException("adapter\u4e3a\u7a7a");
        }
        CheckUtil.checkMemberClass(fileNameAdapter.getClass());
        this.fileNameAdapter = fileNameAdapter;
        return this;
    }
}

