/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.common;

import android.text.TextUtils;
import com.arialyy.aria.core.FtpUrlEntity;
import com.arialyy.aria.core.IdEntity;
import com.arialyy.aria.core.common.BaseOption;
import com.arialyy.aria.core.processor.IFtpUploadInterceptor;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CheckUtil;
import java.text.DateFormatSymbols;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class FtpOption
extends BaseOption {
    private String charSet;
    private String userName;
    private String password;
    private String account;
    private boolean isNeedLogin = false;
    private FtpUrlEntity urlEntity;
    private String protocol;
    private boolean isImplicit = true;
    private IFtpUploadInterceptor uploadInterceptor;
    private int connMode = 0;
    private int minPort;
    private int maxPort;
    private String activeExternalIPAddress;
    private String defaultDateFormatStr = null;
    private String recentDateFormatStr = null;
    private String serverLanguageCode = null;
    private String shortMonthNames = null;
    private String serverTimeZoneId = null;
    private String systemKey = "UNIX";
    private IdEntity idEntity = new IdEntity();
    private static final Map<String, Object> LANGUAGE_CODE_MAP = new TreeMap<String, Object>();

    public FtpOption charSet(String charSet) {
        if (TextUtils.isEmpty((CharSequence)charSet)) {
            throw new NullPointerException("\u5b57\u7b26\u7f16\u7801\u4e3a\u7a7a");
        }
        this.charSet = charSet;
        return this;
    }

    public FtpOption login(String userName, String password) {
        return this.login(userName, password, null);
    }

    public FtpOption login(String userName, String password, String account) {
        if (TextUtils.isEmpty((CharSequence)userName)) {
            ALog.e((String)this.TAG, (String)"\u7528\u6237\u540d\u4e0d\u80fd\u4e3anull");
            return this;
        }
        if (TextUtils.isEmpty((CharSequence)password)) {
            ALog.e((String)this.TAG, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3anull");
            return this;
        }
        this.userName = userName;
        this.password = password;
        this.account = account;
        this.isNeedLogin = true;
        return this;
    }

    public FtpOption setProtocol(String protocol) {
        if (TextUtils.isEmpty((CharSequence)protocol)) {
            ALog.e((String)this.TAG, (String)"\u8bbe\u7f6e\u534f\u8bae\u5931\u8d25\uff0c\u534f\u8bae\u4fe1\u606f\u4e3a\u7a7a");
            return this;
        }
        this.protocol = protocol;
        return this;
    }

    public FtpOption setAlias(String keyAlias) {
        if (TextUtils.isEmpty((CharSequence)keyAlias)) {
            ALog.e((String)this.TAG, (String)"\u8bbe\u7f6e\u8bc1\u4e66\u522b\u540d\u5931\u8d25\uff0c\u8bc1\u4e66\u522b\u540d\u4e3a\u7a7a");
            return this;
        }
        this.idEntity.keyAlias = keyAlias;
        return this;
    }

    public FtpOption setStorePass(String storePass) {
        if (TextUtils.isEmpty((CharSequence)storePass)) {
            ALog.e((String)this.TAG, (String)"\u8bbe\u7f6e\u8bc1\u4e66\u5bc6\u7801\u5931\u8d25\uff0c\u8bc1\u4e66\u5bc6\u7801\u4e3a\u7a7a");
            return this;
        }
        this.idEntity.storePass = storePass;
        return this;
    }

    public FtpOption setStorePath(String storePath) {
        if (TextUtils.isEmpty((CharSequence)storePath)) {
            ALog.e((String)this.TAG, (String)"\u8bbe\u7f6e\u8bc1\u4e66\u8def\u5f84\u5931\u8d25\uff0c\u8bc1\u4e66\u8def\u5f84\u4e3a\u7a7a");
            return this;
        }
        this.idEntity.storePath = storePath;
        return this;
    }

    public FtpOption setImplicit(boolean isImplicit) {
        this.isImplicit = isImplicit;
        return this;
    }

    public FtpOption setUploadInterceptor(IFtpUploadInterceptor uploadInterceptor) {
        if (uploadInterceptor == null) {
            throw new NullPointerException("ftp\u62e6\u622a\u5668\u4e3a\u7a7a");
        }
        CheckUtil.checkMemberClass(uploadInterceptor.getClass());
        this.uploadInterceptor = uploadInterceptor;
        return this;
    }

    public FtpOption setConnectionMode(int connMode) {
        if (connMode != 0 && connMode != 1) {
            ALog.e((String)this.TAG, (String)"\u8fde\u63a5\u6a21\u5f0f\u8bbe\u7f6e\u5931\u8d25\uff0c\u9ed8\u8ba4\u542f\u7528\u88ab\u52a8\u6a21\u5f0f");
            return this;
        }
        this.connMode = connMode;
        return this;
    }

    public FtpOption setActivePortRange(int minPort, int maxPort) {
        if (minPort > maxPort) {
            ALog.e((String)this.TAG, (String)"\u8bbe\u7f6e\u7aef\u53e3\u8303\u56f4\u9519\u8bef\uff0cminPort > maxPort");
            return this;
        }
        if (minPort <= 0 || minPort >= 65535) {
            ALog.e((String)this.TAG, (String)"\u7aef\u53e3\u8303\u56f4\u9519\u8bef");
            return this;
        }
        if (maxPort >= 65535) {
            ALog.e((String)this.TAG, (String)"\u7aef\u53e3\u8303\u56f4\u9519\u8bef");
            return this;
        }
        this.minPort = minPort;
        this.maxPort = maxPort;
        return this;
    }

    public FtpOption setActiveExternalIPAddress(String ip) {
        if (TextUtils.isEmpty((CharSequence)ip)) {
            ALog.e((String)this.TAG, (String)"ip\u4e3a\u7a7a");
            return this;
        }
        if (!CheckUtil.checkIp((String)ip)) {
            ALog.e((String)this.TAG, (String)("ip\u5730\u5740\u9519\u8bef\uff1a" + ip));
            return this;
        }
        this.activeExternalIPAddress = ip;
        return this;
    }

    public FtpOption setServerIdentifier(String identifier) {
        this.systemKey = identifier;
        return this;
    }

    public FtpOption setDefaultDateFormatStr(String defaultDateFormatStr) {
        this.defaultDateFormatStr = defaultDateFormatStr;
        return this;
    }

    public FtpOption setRecentDateFormatStr(String recentDateFormatStr) {
        this.recentDateFormatStr = recentDateFormatStr;
        return this;
    }

    public void setServerTimeZoneId(String serverTimeZoneId) {
        this.serverTimeZoneId = serverTimeZoneId;
    }

    public void setShortMonthNames(String shortMonthNames) {
        this.shortMonthNames = shortMonthNames;
    }

    public FtpOption setServerLanguageCode(String serverLanguageCode) {
        this.serverLanguageCode = serverLanguageCode;
        return this;
    }

    public void setUrlEntity(FtpUrlEntity urlEntity) {
        this.urlEntity = urlEntity;
        urlEntity.needLogin = this.isNeedLogin;
        urlEntity.user = this.userName;
        urlEntity.password = this.password;
        urlEntity.account = this.account;
        urlEntity.idEntity = this.idEntity;
        if (!TextUtils.isEmpty((CharSequence)this.idEntity.storePath) || !TextUtils.isEmpty((CharSequence)this.idEntity.prvKey)) {
            urlEntity.isFtps = true;
            urlEntity.protocol = this.protocol;
            urlEntity.isImplicit = this.isImplicit;
        }
    }

    public static DateFormatSymbols lookupDateFormatSymbols(String languageCode) {
        Object lang = LANGUAGE_CODE_MAP.get(languageCode);
        if (lang != null) {
            if (lang instanceof Locale) {
                return new DateFormatSymbols((Locale)lang);
            }
            if (lang instanceof String) {
                return FtpOption.getDateFormatSymbols((String)lang);
            }
        }
        return new DateFormatSymbols(Locale.US);
    }

    public static DateFormatSymbols getDateFormatSymbols(String shortmonths) {
        String[] months = FtpOption.splitShortMonthString(shortmonths);
        DateFormatSymbols dfs = new DateFormatSymbols(Locale.US);
        dfs.setShortMonths(months);
        return dfs;
    }

    private static String[] splitShortMonthString(String shortmonths) {
        StringTokenizer st = new StringTokenizer(shortmonths, "|");
        int monthcnt = st.countTokens();
        if (12 != monthcnt) {
            throw new IllegalArgumentException("expecting a pipe-delimited string containing 12 tokens");
        }
        String[] months = new String[13];
        int pos = 0;
        while (st.hasMoreTokens()) {
            months[pos++] = st.nextToken();
        }
        months[pos] = "";
        return months;
    }

    public static Collection<String> getSupportedLanguageCodes() {
        return LANGUAGE_CODE_MAP.keySet();
    }

    static {
        LANGUAGE_CODE_MAP.put("en", Locale.ENGLISH);
        LANGUAGE_CODE_MAP.put("de", Locale.GERMAN);
        LANGUAGE_CODE_MAP.put("it", Locale.ITALIAN);
        LANGUAGE_CODE_MAP.put("es", new Locale("es", "", ""));
        LANGUAGE_CODE_MAP.put("pt", new Locale("pt", "", ""));
        LANGUAGE_CODE_MAP.put("da", new Locale("da", "", ""));
        LANGUAGE_CODE_MAP.put("sv", new Locale("sv", "", ""));
        LANGUAGE_CODE_MAP.put("no", new Locale("no", "", ""));
        LANGUAGE_CODE_MAP.put("nl", new Locale("nl", "", ""));
        LANGUAGE_CODE_MAP.put("ro", new Locale("ro", "", ""));
        LANGUAGE_CODE_MAP.put("sq", new Locale("sq", "", ""));
        LANGUAGE_CODE_MAP.put("sh", new Locale("sh", "", ""));
        LANGUAGE_CODE_MAP.put("sk", new Locale("sk", "", ""));
        LANGUAGE_CODE_MAP.put("sl", new Locale("sl", "", ""));
        LANGUAGE_CODE_MAP.put("fr", "jan|f\u00e9v|mar|avr|mai|jun|jui|ao\u00fb|sep|oct|nov|d\u00e9c");
    }

    public static interface FTPServerIdentifier {
        public static final String SYST_UNIX = "UNIX";
        public static final String SYST_UNIX_TRIM_LEADING = "UNIX_LTRIM";
        public static final String SYST_VMS = "VMS";
        public static final String SYST_NT = "WINDOWS";
        public static final String SYST_OS2 = "OS/2";
        public static final String SYST_OS400 = "OS/400";
        public static final String SYST_AS400 = "AS/400";
        public static final String SYST_MVS = "MVS";
        public static final String SYST_L8 = "TYPE: L8";
        public static final String SYST_NETWARE = "NETWARE";
        public static final String SYST_MACOS_PETER = "MACOS PETER";
    }
}

