/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.common;

import com.arialyy.aria.core.common.AbsNormalEntity;
import com.arialyy.aria.core.common.controller.INormalFeature;
import com.arialyy.aria.core.common.controller.NormalController;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.inf.AbsTarget;
import com.arialyy.aria.core.manager.TaskWrapperManager;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.DeleteDGRecord;
import com.arialyy.aria.util.RecordUtil;

public abstract class AbsNormalTarget<TARGET extends AbsNormalTarget>
extends AbsTarget<TARGET>
implements INormalFeature {
    private NormalController mNormalController;

    protected void onPre() {
    }

    public TARGET ignoreCheckPermissions() {
        this.getController().ignoreCheckPermissions();
        return (TARGET)this;
    }

    public boolean isRunning() {
        return false;
    }

    public boolean taskExists() {
        return false;
    }

    private synchronized NormalController getController() {
        if (this.mNormalController == null) {
            this.mNormalController = new NormalController(this.getTaskWrapper());
        }
        return this.mNormalController;
    }

    public void removeRecord() {
        if (this.isRunning()) {
            ALog.d((String)"AbsTarget", (String)"\u4efb\u52a1\u6b63\u5728\u4e0b\u8f7d\uff0c\u5373\u5c06\u5220\u9664\u4efb\u52a1");
            this.cancel();
        } else {
            if (this.getEntity() instanceof AbsNormalEntity) {
                RecordUtil.delNormalTaskRecord((AbsNormalEntity)((AbsNormalEntity)this.getEntity()), (boolean)this.getTaskWrapper().isRemoveFile());
            } else if (this.getEntity() instanceof DownloadGroupEntity) {
                DeleteDGRecord.getInstance().deleteRecord(this.getEntity(), this.getTaskWrapper().isRemoveFile(), true);
            }
            TaskWrapperManager.getInstance().removeTaskWrapper(this.getTaskWrapper());
        }
    }

    public long getCurrentProgress() {
        return this.getEntity() == null ? -1L : this.getEntity().getCurrentProgress();
    }

    public long getFileSize() {
        return this.getEntity() == null ? 0L : this.getEntity().getFileSize();
    }

    public String getConvertFileSize() {
        return this.getEntity() == null ? "0b" : CommonUtil.formatFileSize((double)this.getEntity().getFileSize());
    }

    public String getExtendField() {
        return this.getEntity().getStr();
    }

    public int getTaskState() {
        return this.getEntity().getState();
    }

    public int getPercent() {
        if (this.getEntity() == null) {
            ALog.e((String)"AbsTarget", (String)"\u4e0b\u8f7d\u7ba1\u7406\u5668\u4e2d\u6ca1\u6709\u8be5\u4efb\u52a1");
            return 0;
        }
        if (this.getEntity().getFileSize() != 0L) {
            return (int)(this.getEntity().getCurrentProgress() * 100L / this.getEntity().getFileSize());
        }
        return 0;
    }

    @Override
    public void stop() {
        this.onPre();
        this.getController().stop();
    }

    @Override
    public void resume() {
        this.resume(false);
    }

    @Override
    public void resume(boolean newStart) {
        this.onPre();
        this.getController().resume(newStart);
    }

    @Override
    public void cancel() {
        this.cancel(false);
    }

    @Override
    public void reTry() {
        this.onPre();
        this.getController().reTry();
    }

    @Override
    public void cancel(boolean removeFile) {
        this.onPre();
        this.getController().cancel(removeFile);
    }

    @Override
    public long reStart() {
        this.onPre();
        return this.getController().reStart();
    }

    @Override
    public void save() {
        this.onPre();
        this.getController().save();
    }
}

