/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.command;

import android.content.Context;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.command.AbsNormalCmd;
import com.arialyy.aria.core.command.ResumeThread;
import com.arialyy.aria.core.common.QueueMod;
import com.arialyy.aria.core.task.AbsTask;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.NetUtils;

public final class StartCmd<T extends AbsTaskWrapper>
extends AbsNormalCmd<T> {
    private boolean nowStart = false;

    StartCmd(T entity, int taskType) {
        super(entity, taskType);
    }

    public void setNowStart(boolean nowStart) {
        this.nowStart = nowStart;
    }

    @Override
    public void executeCmd() {
        if (!this.canExeCmd) {
            return;
        }
        if (!NetUtils.isConnected((Context)AriaConfig.getInstance().getAPP())) {
            ALog.e((String)this.TAG, (String)"\u542f\u52a8\u4efb\u52a1\u5931\u8d25\uff0c\u7f51\u7edc\u672a\u8fde\u63a5");
            return;
        }
        int maxTaskNum = this.mQueue.getMaxTaskNum();
        AriaConfig config = AriaConfig.getInstance();
        String mod = this.isDownloadCmd ? config.getDConfig().getQueueMod() : config.getUConfig().getQueueMod();
        AbsTask task = this.getTask();
        if (task == null) {
            task = this.createTask();
            if (mod.equals(QueueMod.NOW.getTag())) {
                this.startTask();
            } else if (mod.equals(QueueMod.WAIT.getTag())) {
                int state = task.getState();
                if (this.mQueue.getCurrentExePoolNum() < maxTaskNum) {
                    if (state == 2 || state == 0 || state == -1 || state == 5 || state == 6 || state == 1) {
                        this.resumeTask();
                    } else if (state == 4) {
                        ALog.w((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u5df2\u7ecf\u5728\u8fd0\u884c", task.getTaskName()));
                    } else {
                        ALog.d((String)this.TAG, (String)String.format("\u5f00\u59cb\u65b0\u4efb\u52a1, \u4efb\u52a1\u72b6\u6001\uff1a%s", state));
                        this.startTask();
                    }
                } else if (this.nowStart) {
                    this.startTask();
                } else {
                    this.sendWaitState(task);
                }
            }
        } else if (!this.mQueue.taskIsRunning(task.getKey())) {
            if (mod.equals(QueueMod.NOW.getTag())) {
                this.resumeTask();
            } else if (this.mQueue.getCurrentExePoolNum() < maxTaskNum) {
                this.resumeTask();
            } else if (this.nowStart) {
                this.resumeTask();
            } else {
                this.sendWaitState(task);
            }
        } else {
            ALog.w((String)this.TAG, (String)String.format("\u4efb\u52a1\u3010%s\u3011\u5df2\u7ecf\u5728\u8fd0\u884c", task.getTaskName()));
        }
        if (this.mQueue.getCurrentCachePoolNum() == 0) {
            this.findAllWaitTask();
        }
    }

    private void findAllWaitTask() {
        new Thread(new ResumeThread(this.isDownloadCmd, String.format("state=%s", 3))).start();
    }
}

