/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.command;

import android.text.TextUtils;
import com.arialyy.aria.core.common.AbsEntity;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.manager.TaskWrapperManager;
import com.arialyy.aria.core.queue.AbsTaskQueue;
import com.arialyy.aria.core.queue.DGroupTaskQueue;
import com.arialyy.aria.core.queue.DTaskQueue;
import com.arialyy.aria.core.queue.UTaskQueue;
import com.arialyy.aria.core.task.AbsTask;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.util.ArrayList;
import java.util.List;

public class ResumeThread
implements Runnable {
    private String TAG = CommonUtil.getClassName(this.getClass());
    private List<AbsTaskWrapper> mWaitList = new ArrayList<AbsTaskWrapper>();
    private boolean isDownloadCmd;
    private String sqlCondition;

    ResumeThread(boolean isDownload, String sqlCondition) {
        this.isDownloadCmd = isDownload;
        this.sqlCondition = sqlCondition;
    }

    private void findTaskData(int type) {
        block5: {
            List entities;
            block6: {
                block4: {
                    if (type != 1) break block4;
                    List entities2 = DbEntity.findDatas(DownloadEntity.class, (String[])new String[]{String.format("NOT(isGroupChild) AND NOT(isComplete) AND %s ORDER BY stopTime DESC", this.sqlCondition)});
                    if (entities2 == null || entities2.isEmpty()) break block5;
                    for (DownloadEntity entity : entities2) {
                        this.addResumeEntity((AbsTaskWrapper)TaskWrapperManager.getInstance().getNormalTaskWrapper(DTaskWrapper.class, entity.getId()));
                    }
                    break block5;
                }
                if (type != 2) break block6;
                List entities3 = DbEntity.findDatas(DownloadGroupEntity.class, (String[])new String[]{String.format("NOT(isComplete) AND %s ORDER BY stopTime DESC", this.sqlCondition)});
                if (entities3 == null || entities3.isEmpty()) break block5;
                for (DownloadGroupEntity entity : entities3) {
                    this.addResumeEntity((AbsTaskWrapper)TaskWrapperManager.getInstance().getGroupWrapper(DGTaskWrapper.class, entity.getId()));
                }
                break block5;
            }
            if (type == 3 && (entities = DbEntity.findDatas(UploadEntity.class, (String[])new String[]{String.format("NOT(isComplete) AND %s ORDER BY stopTime DESC", this.sqlCondition)})) != null && !entities.isEmpty()) {
                for (UploadEntity entity : entities) {
                    this.addResumeEntity((AbsTaskWrapper)TaskWrapperManager.getInstance().getNormalTaskWrapper(UTaskWrapper.class, entity.getId()));
                }
            }
        }
    }

    private void addResumeEntity(AbsTaskWrapper te) {
        if (te == null || te.getEntity() == null || TextUtils.isEmpty((CharSequence)te.getKey())) {
            return;
        }
        this.mWaitList.add(te);
    }

    private void resumeWaitTask() {
        if (this.mWaitList == null || this.mWaitList.isEmpty()) {
            return;
        }
        ArrayList<AbsEntity> resumeEntities = new ArrayList<AbsEntity>();
        for (AbsTaskWrapper wrapper : this.mWaitList) {
            AbsTaskQueue queue = null;
            if (wrapper instanceof DTaskWrapper) {
                queue = DTaskQueue.getInstance();
            } else if (wrapper instanceof UTaskWrapper) {
                queue = UTaskQueue.getInstance();
            } else if (wrapper instanceof DGTaskWrapper) {
                queue = DGroupTaskQueue.getInstance();
            }
            if (queue == null) {
                ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u7c7b\u578b\u9519\u8bef");
                continue;
            }
            if (wrapper.getEntity() == null || TextUtils.isEmpty((CharSequence)wrapper.getKey())) {
                ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u5b9e\u4f53\u4e3a\u7a7a\u6216key\u4e3a\u7a7a");
                continue;
            }
            Object task = queue.getTask(wrapper.getKey());
            if (task != null) {
                ALog.w((String)this.TAG, (String)"\u4efb\u52a1\u5df2\u5b58\u5728");
                continue;
            }
            int maxTaskNum = queue.getMaxTaskNum();
            task = queue.createTask(wrapper);
            if (task == null) continue;
            this.handleWrapper(wrapper);
            if (queue.getCurrentExePoolNum() < maxTaskNum) {
                queue.startTask(task);
                continue;
            }
            wrapper.getEntity().setState(3);
            this.sendWaitState((AbsTask)task);
            resumeEntities.add(wrapper.getEntity());
        }
        if (!resumeEntities.isEmpty()) {
            DbEntity.updateManyData(resumeEntities);
        }
    }

    private void handleWrapper(AbsTaskWrapper wrapper) {
        int requestType = wrapper.getRequestType();
        if (requestType == 3 || requestType == 6 || requestType == 4) {
            wrapper.getOptionParams().setParams("urlEntity", (Object)CommonUtil.getFtpUrlInfo((String)wrapper.getEntity().getKey()));
        }
    }

    private void sendWaitState(AbsTask task) {
        if (task != null) {
            task.getTaskWrapper().setState(3);
            task.getOutHandler().obtainMessage(10, (Object)task).sendToTarget();
        }
    }

    @Override
    public void run() {
        if (this.isDownloadCmd) {
            this.findTaskData(1);
            this.findTaskData(2);
        } else {
            this.findTaskData(3);
        }
        this.resumeWaitTask();
    }
}

