/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.command;

import com.arialyy.aria.core.command.AbsNormalCmd;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.manager.TaskWrapperManager;
import com.arialyy.aria.core.queue.DGroupTaskQueue;
import com.arialyy.aria.core.queue.DTaskQueue;
import com.arialyy.aria.core.queue.UTaskQueue;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.util.ALog;
import java.util.List;

public final class CancelAllCmd<T extends AbsTaskWrapper>
extends AbsNormalCmd<T> {
    public boolean removeFile = false;

    CancelAllCmd(T entity, int taskType) {
        super(entity, taskType);
    }

    @Override
    public void executeCmd() {
        if (!this.canExeCmd) {
            return;
        }
        if (this.isDownloadCmd) {
            this.removeAllDTask();
            this.removeAllDGTask();
        } else {
            this.removeUTask();
        }
    }

    private void removeAllDTask() {
        List entities = DbEntity.findDatas(DownloadEntity.class, (String[])new String[]{"isGroupChild=?", "false"});
        if (entities != null && !entities.isEmpty()) {
            for (DownloadEntity entity : entities) {
                this.remove((AbsTaskWrapper)TaskWrapperManager.getInstance().getNormalTaskWrapper(DTaskWrapper.class, entity.getId()));
            }
        }
    }

    private void removeAllDGTask() {
        List entities = DbEntity.findDatas(DownloadGroupEntity.class, (String[])new String[]{"state!=?", "-1"});
        if (entities != null && !entities.isEmpty()) {
            for (DownloadGroupEntity entity : entities) {
                this.remove((AbsTaskWrapper)TaskWrapperManager.getInstance().getGroupWrapper(DGTaskWrapper.class, entity.getId()));
            }
        }
    }

    private void removeUTask() {
        List entities = DbEntity.findDatas(UploadEntity.class, (String[])new String[]{"isGroupChild=?", "false"});
        if (entities != null && !entities.isEmpty()) {
            for (UploadEntity entity : entities) {
                this.remove((AbsTaskWrapper)TaskWrapperManager.getInstance().getNormalTaskWrapper(UTaskWrapper.class, entity.getId()));
            }
        }
    }

    private void remove(AbsTaskWrapper te) {
        if (te == null) {
            ALog.w((String)this.TAG, (String)"\u53d6\u6d88\u4efb\u52a1\u5931\u8d25\uff0c\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (te instanceof DTaskWrapper) {
            this.mQueue = DTaskQueue.getInstance();
        } else if (te instanceof UTaskWrapper) {
            this.mQueue = UTaskQueue.getInstance();
        } else if (te instanceof DGTaskWrapper) {
            this.mQueue = DGroupTaskQueue.getInstance();
        }
        te.setRemoveFile(this.removeFile);
        this.removeTask(te);
    }
}

