/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core.command;

import com.arialyy.aria.core.command.AbsCmd;
import com.arialyy.aria.core.download.DGTaskWrapper;
import com.arialyy.aria.core.download.DTaskWrapper;
import com.arialyy.aria.core.queue.DGroupTaskQueue;
import com.arialyy.aria.core.queue.DTaskQueue;
import com.arialyy.aria.core.queue.UTaskQueue;
import com.arialyy.aria.core.task.AbsTask;
import com.arialyy.aria.core.upload.UTaskWrapper;
import com.arialyy.aria.core.wrapper.AbsTaskWrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;

public abstract class AbsNormalCmd<T extends AbsTaskWrapper>
extends AbsCmd<T> {
    boolean canExeCmd = true;
    int taskType;

    AbsNormalCmd(T entity, int taskType) {
        this.taskType = taskType;
        this.mTaskWrapper = entity;
        this.TAG = CommonUtil.getClassName((Object)this);
        if (taskType == 1) {
            if (!(entity instanceof DTaskWrapper)) {
                ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u7c7b\u578b\u9519\u8bef\uff0c\u4efb\u52a1\u7c7b\u578b\u5e94\u8be5\u4e3aICM.TASK_TYPE_DOWNLOAD");
                return;
            }
            this.mQueue = DTaskQueue.getInstance();
        } else if (taskType == 3) {
            if (!(entity instanceof DGTaskWrapper)) {
                ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u7c7b\u578b\u9519\u8bef\uff0c\u4efb\u52a1\u7c7b\u578b\u5e94\u8be5\u4e3aICM.TASK_TYPE_DOWNLOAD_GROUP");
                return;
            }
            this.mQueue = DGroupTaskQueue.getInstance();
        } else if (taskType == 2) {
            if (!(entity instanceof UTaskWrapper)) {
                ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u7c7b\u578b\u9519\u8bef\uff0c\u4efb\u52a1\u7c7b\u578b\u5e94\u8be5\u4e3aICM.TASK_TYPE_UPLOAD");
                return;
            }
            this.mQueue = UTaskQueue.getInstance();
        } else {
            ALog.e((String)this.TAG, (String)"\u4efb\u52a1\u7c7b\u578b\u9519\u8bef\uff0c\u4efb\u52a1\u7c7b\u578b\u5e94\u8be5\u4e3aICM.TASK_TYPE_DOWNLOAD\u3001TASK_TYPE_DOWNLOAD_GROUP\u3001TASK_TYPE_UPLOAD");
            return;
        }
        this.isDownloadCmd = taskType == 1 || taskType == 3;
    }

    void sendWaitState() {
        AbsTask task = this.getTask();
        if (task == null) {
            task = this.createTask();
        }
        this.sendWaitState(task);
    }

    void sendWaitState(AbsTask task) {
        if (task != null) {
            task.getTaskWrapper().setState(3);
            task.getOutHandler().obtainMessage(10, (Object)task).sendToTarget();
        }
    }

    void stopAll() {
        this.mQueue.stopAllTask();
    }

    void stopTask() {
        AbsTask task = this.getTask();
        if (task == null) {
            task = this.createTask();
        }
        this.mQueue.stopTask(task);
    }

    void removeTask() {
        AbsTask task = this.getTask();
        if (task == null) {
            task = this.createTask();
        }
        this.mQueue.cancelTask(task);
    }

    void removeTask(AbsTaskWrapper wrapper) {
        AbsTask tempTask = this.getTask(wrapper.getKey());
        if (tempTask == null) {
            tempTask = this.createTask(wrapper);
        }
        this.mQueue.cancelTask(tempTask);
    }

    void startTask() {
        AbsTask task = this.getTask();
        if (task == null) {
            task = this.createTask();
        }
        this.mQueue.startTask(task);
    }

    void resumeTask() {
        AbsTask task = this.getTask();
        if (task == null) {
            task = this.createTask();
        }
        this.mQueue.resumeTask(task);
    }

    AbsTask getTask() {
        return this.mQueue.getTask(this.mTaskWrapper.getEntity().getKey());
    }

    AbsTask getTask(String key) {
        return this.mQueue.getTask(key);
    }

    AbsTask createTask() {
        return this.mQueue.createTask(this.mTaskWrapper);
    }

    AbsTask createTask(AbsTaskWrapper wrapper) {
        return this.mQueue.createTask(wrapper);
    }
}

