/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core;

import android.annotation.TargetApi;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Message;
import android.widget.PopupWindow;
import com.arialyy.aria.core.AriaManager;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;
import java.lang.reflect.Field;

public final class WidgetLiftManager {
    private final String TAG = "WidgetLiftManager";

    @TargetApi(value=11)
    public boolean handleDialogFragmentLift(Dialog dialog) {
        return this.handleDialogLift(dialog);
    }

    public boolean handlePopupWindowLift(PopupWindow popupWindow) {
        try {
            Field dismissField = CommonUtil.getField(popupWindow.getClass(), (String)"mOnDismissListener");
            PopupWindow.OnDismissListener listener = (PopupWindow.OnDismissListener)dismissField.get(popupWindow);
            if (listener != null) {
                ALog.e((String)"WidgetLiftManager", (String)"\u4f60\u5df2\u7ecf\u5bf9PopupWindow\u8bbe\u7f6e\u4e86Dismiss\u4e8b\u4ef6\u3002\u4e3a\u4e86\u9632\u6b62\u5185\u5b58\u6cc4\u9732\uff0c\u8bf7\u5728dismiss\u65b9\u6cd5\u4e2d\u8c03\u7528Aria.download(this).unRegister();\u6765\u6ce8\u9500\u4e8b\u4ef6");
                return true;
            }
            popupWindow.setOnDismissListener(this.createPopupWindowListener(popupWindow));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    private PopupWindow.OnDismissListener createPopupWindowListener(final PopupWindow popupWindow) {
        return new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                AriaManager.getInstance().removeReceiver(popupWindow);
            }
        };
    }

    public boolean handleDialogLift(Dialog dialog) {
        if (dialog == null) {
            ALog.w((String)"WidgetLiftManager", (String)"dialog \u4e3a\u7a7a\uff0c\u6ca1\u6709\u8bbe\u7f6e\u81ea\u52a8\u9500\u6bc1\u4e8b\u4ef6\uff0c\u4e3a\u4e86\u9632\u6b62\u5185\u5b58\u6cc4\u9732\uff0c\u8bf7\u5728dismiss\u65b9\u6cd5\u4e2d\u8c03\u7528Aria.download(this).unRegister();\u6765\u6ce8\u9500\u4e8b\u4ef6\n\u5982\u679c\u4f60\u4f7f\u7528\u7684\u662fDialogFragment\uff0c\u90a3\u4e48\u4f60\u9700\u8981\u5728onDestroy()\u4e2d\u8fdb\u884c\u9500\u6bc1Aria\u4e8b\u4ef6\u64cd\u4f5c");
            return false;
        }
        try {
            Field dismissField = CommonUtil.getField(dialog.getClass(), (String)"mDismissMessage");
            Message dismissMsg = (Message)dismissField.get(dialog);
            if (dismissMsg != null) {
                Field cancelField = CommonUtil.getField(dialog.getClass(), (String)"mCancelMessage");
                Message cancelMsg = (Message)cancelField.get(dialog);
                if (cancelMsg != null) {
                    ALog.e((String)"WidgetLiftManager", (String)"\u4f60\u5df2\u7ecf\u5bf9Dialog\u8bbe\u7f6e\u4e86Dismiss\u548ccancel\u4e8b\u4ef6\u3002\u4e3a\u4e86\u9632\u6b62\u5185\u5b58\u6cc4\u9732\uff0c\u8bf7\u5728dismiss\u65b9\u6cd5\u4e2d\u8c03\u7528Aria.download(this).unRegister();\u6765\u6ce8\u9500\u4e8b\u4ef6\n\u5982\u679c\u4f60\u4f7f\u7528\u7684\u662fDialogFragment\uff0c\u90a3\u4e48\u4f60\u9700\u8981\u5728onDestroy()\u4e2d\u8fdb\u884c\u9500\u6bc1Aria\u4e8b\u4ef6\u64cd\u4f5c");
                    return true;
                }
                dialog.setOnCancelListener(this.createCancelListener());
            } else {
                dialog.setOnDismissListener(this.createDismissListener());
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    private DialogInterface.OnCancelListener createCancelListener() {
        return new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                AriaManager.getInstance().removeReceiver(dialog);
            }
        };
    }

    private DialogInterface.OnDismissListener createDismissListener() {
        return new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                AriaManager.getInstance().removeReceiver(dialog);
            }
        };
    }
}

