/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.arialyy.aria.core.AriaConfig;
import com.arialyy.aria.core.command.CommandManager;
import com.arialyy.aria.core.common.QueueMod;
import com.arialyy.aria.core.config.AppConfig;
import com.arialyy.aria.core.config.DGroupConfig;
import com.arialyy.aria.core.config.DownloadConfig;
import com.arialyy.aria.core.config.UploadConfig;
import com.arialyy.aria.core.download.DownloadEntity;
import com.arialyy.aria.core.download.DownloadGroupEntity;
import com.arialyy.aria.core.download.DownloadReceiver;
import com.arialyy.aria.core.inf.AbsReceiver;
import com.arialyy.aria.core.inf.IReceiver;
import com.arialyy.aria.core.inf.ReceiverType;
import com.arialyy.aria.core.upload.UploadEntity;
import com.arialyy.aria.core.upload.UploadReceiver;
import com.arialyy.aria.orm.DbEntity;
import com.arialyy.aria.orm.DelegateWrapper;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.AriaCrashHandler;
import com.arialyy.aria.util.CommonUtil;
import com.arialyy.aria.util.DeleteURecord;
import com.arialyy.aria.util.RecordUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@TargetApi(value=14)
public class AriaManager {
    private static final String TAG = "AriaManager";
    private static final Object LOCK = new Object();
    @SuppressLint(value={"StaticFieldLeak"})
    private static volatile AriaManager INSTANCE = null;
    private Map<String, AbsReceiver> mReceivers = new ConcurrentHashMap<String, AbsReceiver>();
    private static Context APP;
    private DelegateWrapper mDbWrapper;
    private AriaConfig mConfig;

    private AriaManager(Context context) {
        APP = context.getApplicationContext();
    }

    public static AriaManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AriaManager init(Context context) {
        if (INSTANCE == null) {
            Object object = LOCK;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new AriaManager(context);
                    INSTANCE.initData();
                }
            }
        }
        return INSTANCE;
    }

    private void initData() {
        this.mConfig = AriaConfig.init((Context)APP);
        this.initDb(APP);
        this.regAppLifeCallback(APP);
        this.initAria();
    }

    public Context getAPP() {
        return APP;
    }

    private void initDb(Context context) {
        String oldDbName = "AriaLyyDb";
        File oldDbFile = context.getDatabasePath(oldDbName);
        if (oldDbFile != null && oldDbFile.exists()) {
            File dbConfig = new File(String.format("%s/%s", oldDbFile.getParent(), "AriaLyyDb-journal"));
            oldDbFile.renameTo(new File(String.format("%s/%s", oldDbFile.getParent(), "AndroidAria.db")));
            if (dbConfig.exists()) {
                dbConfig.delete();
            }
        }
        this.mDbWrapper = DelegateWrapper.init((Context)context.getApplicationContext());
        this.amendTaskState();
    }

    private void initAria() {
        AppConfig appConfig = this.mConfig.getAConfig();
        if (appConfig.getUseAriaCrashHandler()) {
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new AriaCrashHandler());
        }
        appConfig.setLogLevel(appConfig.getLogLevel());
        CommandManager.init();
    }

    private void amendTaskState() {
        Class[] clazzs = new Class[]{DownloadEntity.class, UploadEntity.class, DownloadGroupEntity.class};
        String sql = "UPDATE %s SET state=2 WHERE state IN (4,5,6)";
        for (Class clazz : clazzs) {
            if (!this.mDbWrapper.tableExists(clazz)) continue;
            String temp = String.format(sql, clazz.getSimpleName());
            DbEntity.exeSql((String)temp);
        }
    }

    public Map<String, AbsReceiver> getReceiver() {
        return this.mReceivers;
    }

    @Deprecated
    public AriaManager setUploadQueueMod(QueueMod mod) {
        this.mConfig.getUConfig().setQueueMod(mod.tag);
        return this;
    }

    @Deprecated
    public AriaManager setDownloadQueueMod(QueueMod mod) {
        this.mConfig.getDConfig().setQueueMod(mod.tag);
        return this;
    }

    public DownloadConfig getDownloadConfig() {
        return this.mConfig.getDConfig();
    }

    public UploadConfig getUploadConfig() {
        return this.mConfig.getUConfig();
    }

    public AppConfig getAppConfig() {
        return this.mConfig.getAConfig();
    }

    public DGroupConfig getDGroupConfig() {
        return this.mConfig.getDGConfig();
    }

    DownloadReceiver download(Object obj) {
        IReceiver receiver = this.mReceivers.get(this.getKey(ReceiverType.DOWNLOAD, obj));
        if (receiver == null) {
            receiver = this.putReceiver(ReceiverType.DOWNLOAD, obj);
        }
        return receiver instanceof DownloadReceiver ? (DownloadReceiver)receiver : null;
    }

    UploadReceiver upload(Object obj) {
        IReceiver receiver = this.mReceivers.get(this.getKey(ReceiverType.UPLOAD, obj));
        if (receiver == null) {
            receiver = this.putReceiver(ReceiverType.UPLOAD, obj);
        }
        return receiver instanceof UploadReceiver ? (UploadReceiver)receiver : null;
    }

    public void delRecord(int type, String key, boolean removeFile) {
        switch (type) {
            case 1: {
                RecordUtil.delTaskRecord((String)key, (int)1, (boolean)removeFile, (boolean)true);
                break;
            }
            case 2: {
                RecordUtil.delGroupTaskRecordByHash((String)key, (boolean)removeFile);
                break;
            }
            case 3: {
                DeleteURecord.getInstance().deleteRecord(key, removeFile, true);
            }
        }
    }

    private IReceiver putReceiver(ReceiverType type, Object obj) {
        String key = this.getKey(type, obj);
        IReceiver receiver = this.mReceivers.get(key);
        if (receiver == null) {
            AbsReceiver absReceiver = type.equals((Object)ReceiverType.DOWNLOAD) ? new DownloadReceiver(obj) : new UploadReceiver(obj);
            this.mReceivers.put(key, absReceiver);
            receiver = absReceiver;
        }
        return receiver;
    }

    private String getKey(ReceiverType type, Object obj) {
        return String.format("%s_%s_%s", CommonUtil.getTargetName((Object)obj), type.name(), obj.hashCode());
    }

    private void regAppLifeCallback(Context context) {
        Context app = context.getApplicationContext();
        if (app instanceof Application) {
            LifeCallback lifeCallback = new LifeCallback();
            ((Application)app).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)lifeCallback);
        }
    }

    public void removeReceiver(Object obj) {
        if (obj == null) {
            ALog.e((String)TAG, (String)"target obj is null");
            return;
        }
        Iterator<Map.Entry<String, AbsReceiver>> iter = this.mReceivers.entrySet().iterator();
        while (iter.hasNext()) {
            Method method;
            Map.Entry<String, AbsReceiver> entry = iter.next();
            String key = entry.getKey();
            AbsReceiver receiver = entry.getValue();
            if (receiver.isFragment() && (method = CommonUtil.getMethod(receiver.obj.getClass(), (String)"getActivity", (Class[])new Class[0])) != null) {
                try {
                    Activity ac = (Activity)method.invoke(receiver.obj, new Object[0]);
                    if (ac == obj) {
                        receiver.destroy();
                        iter.remove();
                        continue;
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            String objClsName = obj.getClass().getName();
            if (receiver.isLocalOrAnonymousClass && key.startsWith(objClsName)) {
                receiver.destroy();
                iter.remove();
                continue;
            }
            if (!key.equals(this.getKey(ReceiverType.DOWNLOAD, obj)) && !key.equals(this.getKey(ReceiverType.UPLOAD, obj))) continue;
            receiver.destroy();
            iter.remove();
        }
        Log.d((String)TAG, (String)"debug");
    }

    private class LifeCallback
    implements Application.ActivityLifecycleCallbacks {
        private LifeCallback() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
            AriaManager.this.removeReceiver(activity);
        }
    }
}

