/*
 * Decompiled with CFR 0.152.
 */
package com.arialyy.aria.core;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.Dialog;
import android.app.Service;
import android.content.Context;
import android.widget.PopupWindow;
import com.arialyy.aria.core.AriaManager;
import com.arialyy.aria.core.download.DownloadReceiver;
import com.arialyy.aria.core.upload.UploadReceiver;
import com.arialyy.aria.util.ALog;
import com.arialyy.aria.util.CommonUtil;

@TargetApi(value=15)
public class Aria {
    private Aria() {
    }

    public static DownloadReceiver download(Object obj) {
        if (AriaManager.getInstance() != null) {
            return AriaManager.getInstance().download(obj);
        }
        return Aria.get(Aria.convertContext(obj)).download(obj);
    }

    public static UploadReceiver upload(Object obj) {
        if (AriaManager.getInstance() != null) {
            return AriaManager.getInstance().upload(obj);
        }
        return Aria.get(Aria.convertContext(obj)).upload(obj);
    }

    public static AriaManager get(Context context) {
        if (context == null) {
            throw new NullPointerException("context \u65e0\u6548\uff0c\u5728\u975e\u3010Activity\u3001Service\u3001Application\u3001DialogFragment\u3001Fragment\u3001PopupWindow\u3001Dialog\u3011\uff0c\u8bf7\u53c2\u8003\u3010https://aria.laoyuyu.me/aria_doc/create/any_java.html\u3011\uff0c\u53c2\u6570\u8bf7\u4f7f\u7528 download(this) \u6216 upload(this);\u4e0d\u8981\u4f7f\u7528 download(getContext()) \u6216 upload(getContext())");
        }
        return AriaManager.init(context);
    }

    public static AriaManager init(Context context) {
        return Aria.get(context);
    }

    private static Context convertContext(Object obj) {
        if (obj instanceof Application) {
            return (Application)obj;
        }
        if (obj instanceof Service) {
            return (Service)obj;
        }
        if (obj instanceof Activity) {
            return (Activity)obj;
        }
        if (CommonUtil.isFragment(obj.getClass())) {
            return CommonUtil.getFragmentActivity((Object)obj);
        }
        if (obj instanceof Dialog) {
            return ((Dialog)obj).getContext();
        }
        if (obj instanceof PopupWindow) {
            return ((PopupWindow)obj).getContentView().getContext();
        }
        ALog.e((String)"Aria", (String)"\u8bf7\u4f7f\u7528download(this)\u6216upload(this)");
        return null;
    }
}

